/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import se.ericsson.cello.licensing.LicensingMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractRbsConfigurationAction;
import se.ericsson.crbs.common.ExceptionHelper;

public class SetUniqueLogicalNameAction
extends AbstractRbsConfigurationAction {
    protected static final int MAX_ULN_LENGTH = 255;
    private static final Class THIS_CLASS = SetUniqueLogicalNameAction.class;
    private final String uniqueLogicalName;
    private final Coordinator coordinator;

    public SetUniqueLogicalNameAction(RbsConfigurationMao inputRbsConfigurationMao, String inputUniqueLogicalName, Coordinator inputCoordinator) {
        super(THIS_CLASS, inputRbsConfigurationMao);
        this.uniqueLogicalName = inputUniqueLogicalName.trim();
        this.coordinator = inputCoordinator;
    }

    public void execute() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "execute()");
        if (this.uniqueLogicalName.length() > 255) {
            throw new RbsConfigurationFailedException("The unique logical name is too long");
        }
        ManagedObject lic = this.moRepositoryWrapper.lookup("ManagedElement=1,SystemFunctions=1,Licensing=1");
        if (lic instanceof LicensingMo) {
            try {
                LicensingMo licensingMo = (LicensingMo)lic;
                licensingMo.setUln(this.uniqueLogicalName, this.coordinator);
            }
            catch (MoAccessException mae) {
                String slogan = "Licensing";
                String errorMsg = "Failed to execute action: " + StringHelper.doubleQuote((String)ExceptionHelper.getExceptionMessage((Throwable)mae));
                throw new RbsConfigurationFailedException("Licensing", ExceptionHelper.appendReason((String)errorMsg, (Throwable)mae), (Exception)((Object)mae));
            }
        } else {
            throw new RbsConfigurationFailedException("Could not find Licensing Mo in repository");
        }
        this.logger.traceReturn(THIS_CLASS, "execute()");
    }
}

