/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.PersistentDataCleaner;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractRbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.ClientTimeSetter;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.StartNetworkLoaderGuiDataParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.DomXmlModifyHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.transactionpackages.SetLogicalNameTp;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.ScenarioParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.FileEncryptor;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.fetchsiteinstallation.SiteInstallationFileParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.initialipconfiguration.IpStackConfigurator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.FileLogger;

public class StartNetworkLoaderAction
extends AbstractRbsConfigurationAction {
    private StartNetworkLoaderGuiDataParser guiParser;
    private final String guiParameters;
    private final String sif;
    private int scenario;
    private FileParameters fileParameters;
    private static final Class THIS_CLASS = StartNetworkLoaderAction.class;
    private RbsConfigurationIsiHelper isiHelper;

    public StartNetworkLoaderAction(RbsConfigurationMao inputRbsConfigurationMao, String receivedGuiParameters, String receivedSif) {
        super(THIS_CLASS, inputRbsConfigurationMao);
        this.fileParameters = FileParameters.instance(this.rbsConfigurationMao);
        this.guiParameters = receivedGuiParameters;
        this.sif = receivedSif;
        this.scenario = 0;
    }

    public void execute() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "execute()");
        try {
            this.init();
        }
        catch (RbsConfigurationFailedException e) {
            this.rbsConfigurationMao.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OTHER_FAULT, "Action StartNetworkLoader failed", e.getFormattedMessages(), null);
            this.rbsConfigurationMao.integrationFinishedOrFailed();
            throw e;
        }
        this.guiParser = new StartNetworkLoaderGuiDataParser(this.guiParameters, this.rbsConfigurationMao);
        this.guiParser.parse();
        this.setNodeTime();
        SiteInstallationFileParser SifParser = new SiteInstallationFileParser(this.sif, this.rbsConfigurationMao);
        SifParser.parse();
        this.decideScenario();
        this.copySummaryFilePath();
        String localPath = ((RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class)).getLocalPath();
        this.encryptAndSaveStringToFile(localPath + "SiteInstallation.xml", this.sif, this.isiHelper.getXmlEncryptionKey());
        this.setLogicalName();
        if (this.stateHandler.getWaitForIntegrate()) {
            this.logger.traceDebug(THIS_CLASS, "WaitForAutoIntegrationActionStateExecutor received new request to start downloading");
            if (this.scenario != 1) {
                this.logger.traceDebug(THIS_CLASS, "state executor will be continued with: FetchFilesStateExecutor");
                this.stateHandler.reset(21);
            } else {
                this.logger.traceDebug(THIS_CLASS, " state executorwill be continued with: IpConfigurationStateExecutor");
                this.stateHandler.reset(11);
            }
            this.stateHandler.setWaitForIntegrate(false);
        } else {
            if (this.scenario != 1) {
                this.updateProgressReport();
                this.helper.setConfigurationStateAndProgressLevel(21);
            } else {
                String detailedInformation = "Skipped by MO action - StartNetworkLoaderAction";
                this.updateProgressReportInformation(20, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
                this.updateProgressReportInformation(50, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
                this.helper.setConfigurationStateAndProgressLevel(11);
            }
            this.stateHandler.setWaitForIntegrate(true);
            this.stateHandler.start();
        }
        this.logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void updateProgressReport() {
        String detailedInformation = "Skipped by MO action - StartNetworkLoaderAction";
        this.updateProgressReportInformation(20, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
        this.updateProgressReportInformation(50, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
        this.updateProgressReportInformation(95, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
        this.updateProgressReportInformation(100, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
        this.updateProgressReportInformation(150, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
        this.updateProgressReportInformation(200, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
        this.updateProgressReportInformation(250, 2, "Skipped by MO action - StartNetworkLoaderAction", true);
    }

    private void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }

    private void copySummaryFilePath() {
        if (this.guiParser.sftpDataReceived()) {
            this.fileParameters = FileParameters.instance(this.rbsConfigurationMao);
            String sftpSummaryFilePath = this.fileParameters.getSmrsSummaryFilePath();
            this.fileParameters.setSftpSummaryFilePath(sftpSummaryFilePath);
        }
    }

    private void init() throws RbsConfigurationFailedException {
        this.cleanUp();
        FileLogger progressReportFileHandler = this.rbsConfigurationMao.getFileLogger();
        ProgressReportHandler progressReportHandler = this.rbsConfigurationMao.getProgressReportHandler();
        this.rbsConfigurationMao.integrationStarted();
        try {
            this.rbsConfigurationMao.setReadOnlyAttribute("progressLevel", new Integer(0));
            this.rbsConfigurationMao.storePersistently("integrationLogFilePath", progressReportFileHandler.getDefaultFileLogPath());
        }
        catch (MoAccessException e1) {
            this.rbsConfigurationMao.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OTHER_FAULT, "Action StartNetworkLoader failed.", e1.getMessage(), null);
            this.rbsConfigurationMao.integrationFinishedOrFailed();
            throw new RbsConfigurationFailedException("MO Access error", "Action StartNetworkLoader failed with a MO access error", (Exception)((Object)e1));
        }
        this.helper.verifyConfigLevel(RbsConfigurationDefinitions.RBS_CL_BASIC_CV);
        boolean activateSecurity = SecurityParameters.instance(this.rbsConfigurationMao).getActivateSecurityAsBoolean();
        boolean activateIpSecurity = SecurityParameters.instance(this.rbsConfigurationMao).getActivateIpSecurityAsBoolean();
        this.logger.traceDebug(THIS_CLASS, "startNetworkLoader::downloadFiles(): calling progressReportHandler with activateSecurity = " + activateSecurity);
        progressReportHandler.integrationHasBeenStarted(activateSecurity, activateIpSecurity);
        ProgressReportHandler.getInstance().setIntegrationCanBeCancelled(Boolean.TRUE);
        this.helper.clearConfigFaultReason();
        ConfigurationReportLoggerFactory.getLogger().removeOldBackupFiles(true);
        ConfigurationReportLoggerFactory.getLogger().finishAndSaveReportFile(false);
        try {
            Object reportAttr = this.rbsConfigurationMao.getAttribute("configurationReport");
            StringBuffer reportAttrBuffer = reportAttr == null ? new StringBuffer() : new StringBuffer((String)reportAttr);
            ConfigurationReportLoggerFactory.getLogger().setConfigurationReportStringBuffer(reportAttrBuffer);
            this.rbsConfigurationMao.setReadOnlyAttribute("configurationReport", "");
        }
        catch (MoAccessException e) {
            this.rbsConfigurationMao.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OTHER_FAULT, "Action StartNetworkLoader failed.", e.getMessage(), null);
            this.rbsConfigurationMao.integrationFinishedOrFailed();
            throw new RbsConfigurationFailedException("MO Access error", "Action StartNetworkLoader failed with a MO access error", (Exception)((Object)e));
        }
    }

    private void cleanUp() {
        this.fileParameters = FileParameters.instance(this.rbsConfigurationMao);
        if (RbsConfigurationHelper.existsAndNotEmpty(this.fileParameters.getSmrsSummaryFilePath())) {
            IpStackConfigurator ipStackConfigurator = new IpStackConfigurator(this.rbsConfigurationMao);
            ipStackConfigurator.cleanIpStack(true);
            PersistentDataCleaner persistentAttributesCleaner = new PersistentDataCleaner(this.rbsConfigurationMao);
            persistentAttributesCleaner.cleanPersistentAttributesAndRemoveFiles("init_");
            this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_BASIC_CV);
        }
        this.isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationIsiHelper.class);
        try {
            this.isiHelper.cleanConfigurationFilesAndIsiTempFiles("");
            this.isiHelper.removeMergedIbpLoadModules("", this.rbsConfigurationMao);
        }
        catch (FileHelper.FileException e) {
            this.logger.traceDebug(THIS_CLASS, "Fail to remove File: " + e.getMessage());
        }
        catch (MoAccessException e) {
            this.logger.traceDebug(THIS_CLASS, "Fail to get Executing CV name: " + e.getMessage());
        }
    }

    private void setNodeTime() {
        this.logger.traceEnter(THIS_CLASS, "setNodeTime()");
        if (this.guiParser.isParsingDone()) {
            if (this.guiParser.didGuiDataContainTime()) {
                long utcTime = 0L;
                try {
                    utcTime = Long.parseLong(this.guiParser.getGuiDataUtcTime());
                }
                catch (NumberFormatException e) {
                    String errorMsg = ExceptionHelper.appendReason((String)"Wrong format on timestamp in StartNetworkLoader action", (Throwable)e);
                    this.logger.traceAbnormal(THIS_CLASS, errorMsg);
                }
                if (utcTime > 0L) {
                    ClientTimeSetter clientTimeSetter = new ClientTimeSetter(this.moRepositoryWrapper, this.helper);
                    try {
                        clientTimeSetter.setTime(utcTime);
                    }
                    catch (MoAccessException e) {
                        String errorMsg = ExceptionHelper.appendReason((String)"Failed to set time on the node", (Throwable)e);
                        this.logger.traceAbnormal(THIS_CLASS, errorMsg);
                    }
                }
            }
        } else {
            this.logger.traceAbnormal(THIS_CLASS, "setNodeTime() called before Gui Data was parsed");
        }
        this.logger.traceReturn(THIS_CLASS, "setNodeTime()");
    }

    private void decideScenario() {
        this.logger.traceEnter(THIS_CLASS, "decideScenario()");
        if (this.guiParser.isParsingDone()) {
            if (this.guiParser.smrsDataReceived()) {
                if (this.guiParser.sftpDataReceived()) {
                    this.scenario = 2;
                    this.logger.traceGeneral(THIS_CLASS, "Running Warehouse scenario");
                } else {
                    this.scenario = 1;
                    this.logger.traceGeneral(THIS_CLASS, "Running Auto Integration With Laptop scenario");
                }
            } else if (this.guiParser.sftpDataReceived()) {
                this.scenario = 3;
                this.logger.traceGeneral(THIS_CLASS, "Running Semi Automatic scenario");
            } else {
                this.scenario = -1;
                this.logger.traceAbnormal(THIS_CLASS, "There is no scenario when neither smrs nor sftp data is provided");
            }
        } else {
            this.logger.traceAbnormal(THIS_CLASS, "decideScenario() called before Gui Data was parsed");
        }
        ScenarioParameters.instance(this.rbsConfigurationMao).setWithGuiScenario(this.scenario);
        this.logger.traceReturn(THIS_CLASS, "decideScenario()");
    }

    private void setLogicalName() throws RbsConfigurationFailedException {
        try {
            ManagedObject licensingMo = this.moRepositoryWrapper.lookup("ManagedElement=1,SystemFunctions=1,Licensing=1");
            if (licensingMo == null) {
                this.logger.traceError(THIS_CLASS, "Unable to find LicensingMo!");
            } else {
                String fingerPrint = (String)licensingMo.getAttribute("fingerprint", null);
                if (!NodeParameters.instance().getLogicalName().equals(fingerPrint)) {
                    TransactionHandler.run(new SetLogicalNameTp(NodeParameters.instance().getLogicalName(), this.moRepositoryWrapper));
                }
            }
        }
        catch (RbsConfigurationFailedException e) {
            throw e;
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Access error", "Access exception caught while setting up parameters for download", (Exception)((Object)e));
        }
    }

    private void encryptAndSaveStringToFile(String filePath, String dataString, String encryptionKey) throws RbsConfigurationFailedException {
        this.saveStringToFile(filePath, dataString);
        int scenarioId = ScenarioParameters.instance(this.rbsConfigurationMao).getWithGuiScenario();
        if (scenarioId == 1 || scenarioId == 2) {
            DomXmlModifyHelper domXmlModifier = new DomXmlModifyHelper(filePath);
            domXmlModifier.updateXmlAttribute("SmrsData", "userName", this.fileParameters.getSmrsUserName());
            domXmlModifier.updateXmlAttribute("SmrsData", "password", this.fileParameters.getSmrsPassword());
            domXmlModifier.writeToFile();
        }
        FileEncryptor encryptor = new FileEncryptor();
        try {
            encryptor.encryptFile(filePath, encryptionKey);
        }
        catch (IOException ioe) {
            this.logger.traceDebug(THIS_CLASS, "Read " + filePath + " failed: " + ioe.getMessage());
        }
        catch (GeneralSecurityException gse) {
            this.logger.traceDebug(THIS_CLASS, "Encryption of " + filePath + " failed: " + gse.getMessage());
            this.deleteFileIfItExists(filePath);
        }
    }

    private void saveStringToFile(String filePath, String dataString) {
        this.deleteFileIfItExists(filePath);
        FileHelper.writeToFile((String)filePath, (String)dataString, (boolean)true);
    }

    private void deleteFileIfItExists(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }
}

