/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class StartNetworkLoaderGuiDataParser
extends DefaultHandler {
    private static final Class THIS_CLASS = StartNetworkLoaderGuiDataParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String EXCEPTION_SLOGAN = "startNetworkLoaderActionParser parser";
    private String guiParametersXml;
    private boolean parserInGuiData;
    private boolean parsingDone;
    private boolean smrsDataReceived;
    private boolean sftpDataReceived;
    private boolean didGuiDataContainTime;
    private String guiDataUtcTime;
    private FileParameters fileParameters;

    public StartNetworkLoaderGuiDataParser(String guiParameters, RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "StartNetworkLoaderGuiDataParser()");
        this.fileParameters = FileParameters.instance(rbsConfigurationMao);
        this.guiParametersXml = guiParameters;
        this.parserInGuiData = true;
        this.parsingDone = false;
        this.smrsDataReceived = false;
        this.sftpDataReceived = false;
        this.didGuiDataContainTime = false;
        this.guiDataUtcTime = null;
        logger.traceReturn(THIS_CLASS, "StartNetworkLoaderGuiDataParser()");
    }

    public void parse() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "Parse()");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new StringReader(this.guiParametersXml)), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            String emsg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            logger.traceDebug(THIS_CLASS, "Failed to parse StartNetworkLoader GUI parameters " + emsg);
            throw new RbsConfigurationFailedException(EXCEPTION_SLOGAN, "Failed to parse StartNetworkLoader GUI parameters: " + this.guiParametersXml + ", " + emsg, e);
        }
        catch (SAXException e) {
            String emsg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            logger.traceDebug(THIS_CLASS, "Failed to parse StartNetworkLoader GUI parameters " + emsg);
            throw new RbsConfigurationFailedException(EXCEPTION_SLOGAN, "Failed to parse StartNetworkLoader GUI parameters: " + this.guiParametersXml + ", " + emsg, e);
        }
        catch (IOException e) {
            String emsg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            logger.traceDebug(THIS_CLASS, "IOException while parsing StartNetworkLoader GUI parameters " + emsg);
            throw new RbsConfigurationFailedException(EXCEPTION_SLOGAN, "Failed to parse StartNetworkLoader GUI parameters: " + this.guiParametersXml + ", " + emsg, e);
        }
        this.parsingDone = true;
        logger.traceReturn(THIS_CLASS, "Parse()");
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        logger.traceEnter(THIS_CLASS, "startElement()");
        if (qName.equals("GuiData")) {
            this.parserInGuiData = true;
        }
        if (this.parserInGuiData) {
            if (qName.equals("LocalFileServer")) {
                this.getLocalFileServerData(attributes);
            } else if (qName.equals("SmrsData")) {
                this.getSmrsData(attributes);
            } else if (qName.equals("Time")) {
                for (int index = 0; index < attributes.getLength(); ++index) {
                    if (!attributes.getQName(index).equals("currentUtcTime")) continue;
                    this.didGuiDataContainTime = true;
                    this.guiDataUtcTime = attributes.getValue(index);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "startElement()");
    }

    public void endElement(String uri, String localName, String qName) {
        logger.traceEnter(THIS_CLASS, "endElement()");
        if (qName.equals("GuiData")) {
            this.parserInGuiData = false;
        }
        logger.traceReturn(THIS_CLASS, "endElement()");
    }

    private void getLocalFileServerData(Attributes attributes) {
        this.sftpDataReceived = true;
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equals("username")) {
                this.fileParameters.setSftpUserName(attributes.getValue(index));
                continue;
            }
            if (attributes.getQName(index).equals("password")) {
                this.fileParameters.setSftpPassword(attributes.getValue(index));
                continue;
            }
            if (!attributes.getQName(index).equals("ipAddress")) continue;
            this.fileParameters.setSftpAddress(attributes.getValue(index));
        }
    }

    private void getSmrsData(Attributes attributes) {
        this.smrsDataReceived = true;
        for (int index = 0; index < attributes.getLength(); ++index) {
            if (attributes.getQName(index).equals("username")) {
                this.fileParameters.setSmrsUserName(attributes.getValue(index));
                continue;
            }
            if (!attributes.getQName(index).equals("password")) continue;
            this.fileParameters.setSmrsPassword(attributes.getValue(index));
        }
    }

    protected boolean smrsDataReceived() {
        return this.smrsDataReceived;
    }

    protected boolean sftpDataReceived() {
        return this.sftpDataReceived;
    }

    protected boolean isParsingDone() {
        return this.parsingDone;
    }

    protected boolean didGuiDataContainTime() {
        return this.didGuiDataContainTime;
    }

    protected String getGuiDataUtcTime() {
        return this.guiDataUtcTime;
    }
}

