/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.actions;

import java.io.IOException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.actions.AbstractRbsConfigurationAction;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ric.parser.RicInfoParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.parser.SmrsInfoParser;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.ModifyInitialAccessControlListTp;
import se.ericsson.crbs.common.ExceptionHelper;

public class UpdateRbsIntegrationParametersAction
extends AbstractRbsConfigurationAction {
    private static final Class THIS_CLASS = UpdateRbsIntegrationParametersAction.class;
    protected long timeToSleep = 10000L;
    private final String updatedParametersXml;

    public UpdateRbsIntegrationParametersAction(RbsConfigurationMao inputRbsConfigurationMao, String inputUpdatedParametersXml) {
        super(THIS_CLASS, inputRbsConfigurationMao);
        this.updatedParametersXml = inputUpdatedParametersXml.trim();
    }

    public void execute() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "execute()");
        this.parseSmrsInfo();
        this.parseRicInfo();
        this.logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void parseRicInfo() throws RbsConfigurationFailedException {
        try {
            RicInfoParser ricInfoParser = new RicInfoParser();
            ricInfoParser.parse(this.updatedParametersXml);
            if (ricInfoParser.isRicInfoPresent()) {
                String ric = ricInfoParser.getRic();
                this.sensitiveDataHelper.storeRbsIntegrationCode(ric, null);
                ProgressReportHandler.getInstance().removeWrongRbsIntegrationCode();
                this.logger.traceGeneral(THIS_CLASS, "Stored updated RIC persistently");
            }
        }
        catch (MoAccessException mae) {
            String slogan = "Update Input";
            String message = ExceptionHelper.appendReason((String)("Failed to store RIC data persistently: " + StringHelper.doubleQuote((String)this.updatedParametersXml)), (Throwable)mae);
            throw new RbsConfigurationFailedException("Update Input", message, (Exception)((Object)mae));
        }
        catch (IOException ioe) {
            String slogan = "Update Input";
            String message = ExceptionHelper.appendReason((String)("Failed to parse RIC info from: " + StringHelper.doubleQuote((String)this.updatedParametersXml)), (Throwable)ioe);
            throw new RbsConfigurationFailedException("Update Input", message, ioe);
        }
    }

    private void parseSmrsInfo() throws RbsConfigurationFailedException {
        try {
            SmrsInfoParser smrsInfoParser = new SmrsInfoParser();
            smrsInfoParser.parse(this.updatedParametersXml);
            if (smrsInfoParser.isSmrsInfoPresent()) {
                String smrsUserName = smrsInfoParser.getSmrsUserName();
                String smrsPassword = smrsInfoParser.getSmrsPassword();
                String smrsServer = smrsInfoParser.getSmrsServer();
                String summaryFilePath = smrsInfoParser.getSummaryFilePath();
                RbsConfigurationSmrsHelper rbsConfigurationSmrsHelper = (RbsConfigurationSmrsHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationSmrsHelper.class);
                String oldSmrsServer = FileParameters.instance(this.rbsConfigurationMao).getSmrsAddress();
                rbsConfigurationSmrsHelper.storeSmrsDataPersistently(smrsUserName, smrsPassword, smrsServer, summaryFilePath);
                if (oldSmrsServer != null && !oldSmrsServer.equalsIgnoreCase(smrsServer)) {
                    this.updateInitialAcl(oldSmrsServer, smrsServer);
                }
                ProgressReportHandler.getInstance().removeErroneousSmrsInfo();
                this.logger.traceGeneral(THIS_CLASS, "Stored updated SMRS user name persistently: " + StringHelper.doubleQuote((String)smrsUserName));
            }
        }
        catch (MoAccessException mae) {
            String slogan = "Update Input";
            String message = ExceptionHelper.appendReason((String)("Failed to store SMRS data persistently: " + StringHelper.doubleQuote((String)this.updatedParametersXml)), (Throwable)mae);
            throw new RbsConfigurationFailedException("Update Input", message, (Exception)((Object)mae));
        }
        catch (IOException ioe) {
            String slogan = "Update Input";
            String message = ExceptionHelper.appendReason((String)("Failed to parse SMRS info from: " + StringHelper.doubleQuote((String)this.updatedParametersXml)), (Throwable)ioe);
            throw new RbsConfigurationFailedException("Update Input", message, ioe);
        }
    }

    private void updateInitialAcl(String oldSmrsServer, String smrsServer) throws RbsConfigurationFailedException {
        TransactionHandler.run(new ModifyInitialAccessControlListTp(this.moRepositoryWrapper, oldSmrsServer, smrsServer));
    }
}

