/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck;

import se.ericsson.cello.ConstDefs.EventTypeValue;
import se.ericsson.cello.ConstDefs.PerceivedSeverityValue;
import se.ericsson.cello.ConstDefs.ProbableCauseValue;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmDuplicatedException;
import se.ericsson.cello.faultmanagement.AlarmFactory;
import se.ericsson.cello.faultmanagement.UpdatableAlarm;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.AlarmFactoryInstanceWrapper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.AlarmHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.geolocationcheck.UpdatableAlarmWrapper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataFinder;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.indications.MaoFroAlarmObject;

public class AlarmHandlerImpl
implements AlarmHandler {
    protected UpdatableAlarmWrapper alarmPosUnavailable = null;
    protected UpdatableAlarmWrapper alarmPosMismatch = null;
    protected MaoFroAlarmObject alarmInfoPosMismatch;
    protected MaoFroAlarmObject alarmInfoPosUnavailable;
    private final int CLIB_CONST_FH_FAULT_ID_RBS_PHYSICAL_AND_CONFIGURED_POSITION_MISMATCH = 1544;
    private final int CLIB_CONST_FH_FAULT_ID_RBS_PHYSICAL_POSITION_UNAVAILABLE = 1545;
    protected final ManagedObject rbsConfigurationMo;
    private static final Class THIS_CLASS = AlarmHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private MoMetaDataFinder finder;
    protected AlarmFactoryWrapper alarmFactoryWrapper = new AlarmFactoryWrapper();

    public AlarmHandlerImpl(ManagedObject aMo) {
        logger.traceEnter(THIS_CLASS, "AlarmHandlerImpl()");
        if (aMo == null) {
            logger.traceAbnormal(THIS_CLASS, "AlarmHandlerImpl constructor, managed object is null.");
        }
        this.rbsConfigurationMo = aMo;
        logger.traceReturn(THIS_CLASS, "AlarmHandlerImpl()");
    }

    public void readAlarmParameters(GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "readAlarmParameters()");
        if (aGenericMaoContext != null) {
            this.finder = aGenericMaoContext.getMoMetaDataFinder();
            if (this.finder != null) {
                this.alarmInfoPosMismatch = this.finder.getMoData(this.rbsConfigurationMo.getType()).getAlarm(1544);
                this.alarmInfoPosUnavailable = this.finder.getMoData(this.rbsConfigurationMo.getType()).getAlarm(1545);
            }
        }
        if (this.alarmInfoPosMismatch == null) {
            logger.traceAbnormal(THIS_CLASS, "Failed to get alarm properties from MO data for position mismatch, setting alarm parameters manually.");
        }
        if (this.alarmInfoPosUnavailable == null) {
            logger.traceAbnormal(THIS_CLASS, "Failed to get alarm properties from MO data for position unavailable alarm, setting alarm parameters manually.");
        }
        logger.traceReturn(THIS_CLASS, "readAlarmParameters()");
    }

    public void raiseAlarmPositionMismatch(AdditionalInfo[] additionalInfo) {
        logger.traceEnter(THIS_CLASS, "raiseAlarmPositionMismatch()");
        if (this.isMismatchAlarmRaised()) {
            logger.traceGeneral(THIS_CLASS, "Updating additional information for already raised mismatch alarm");
            this.alarmPosMismatch.setAdditionalInfo(additionalInfo);
        } else {
            String msg = "Create alarm; moType = " + this.rbsConfigurationMo.getType() + ", moFullDistinguishedName = " + this.rbsConfigurationMo.getFullDistinguishedName() + ", " + this.alarmInfoPosMismatch.toStringBuffer();
            logger.traceGeneral(THIS_CLASS, msg);
            try {
                AlarmFactoryInstanceWrapper alarmFactory = this.alarmFactoryWrapper.getInstance();
                if (alarmFactory != null) {
                    this.alarmPosMismatch = alarmFactory.createAlarm(this.rbsConfigurationMo.getType(), this.rbsConfigurationMo.getFullDistinguishedName(), this.getEventType(this.alarmInfoPosMismatch.getEventType()), "", this.getProbableCause(this.alarmInfoPosMismatch.getProbableCause()), this.getPerceivedSeverity(this.alarmInfoPosMismatch.getPerceivedSeverity()), this.alarmInfoPosMismatch.getSpecificProblem(), "", additionalInfo, null, this.alarmInfoPosMismatch.isSecondaryAlarm());
                }
            }
            catch (AlarmDuplicatedException e) {
                logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "The alarm with specific problem: " + this.alarmInfoPosMismatch.getSpecificProblem() + " to fMo: " + this.rbsConfigurationMo.getFullDistinguishedName() + " is already sent to alarm service");
            }
        }
        logger.traceReturn(THIS_CLASS, "raiseAlarmPositionMismatch()");
    }

    public void raiseAlarmPositionUnavailable(AdditionalInfo[] additionalInfo) {
        logger.traceEnter(THIS_CLASS, "raiseAlarmPositionUnavailable()");
        if (this.isUnavailableAlarmRaised()) {
            logger.traceGeneral(THIS_CLASS, "Updating additional information for already raised unavailable alarm");
            this.alarmPosUnavailable.setAdditionalInfo(additionalInfo);
        } else {
            String msg = "Create alarm; moType = " + this.rbsConfigurationMo.getType() + ", moFullDistinguishedName = " + this.rbsConfigurationMo.getFullDistinguishedName() + ", " + this.alarmInfoPosUnavailable.toStringBuffer();
            logger.traceGeneral(THIS_CLASS, msg);
            try {
                AlarmFactoryInstanceWrapper alarmFactory = this.alarmFactoryWrapper.getInstance();
                if (alarmFactory != null) {
                    this.alarmPosUnavailable = alarmFactory.createAlarm(this.rbsConfigurationMo.getType(), this.rbsConfigurationMo.getFullDistinguishedName(), this.getEventType(this.alarmInfoPosUnavailable.getEventType()), "", this.getProbableCause(this.alarmInfoPosUnavailable.getProbableCause()), this.getPerceivedSeverity(this.alarmInfoPosUnavailable.getPerceivedSeverity()), this.alarmInfoPosUnavailable.getSpecificProblem(), "", additionalInfo, null, this.alarmInfoPosUnavailable.isSecondaryAlarm());
                }
            }
            catch (AlarmDuplicatedException e) {
                logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "The alarm with specific problem: " + this.alarmInfoPosUnavailable.getSpecificProblem() + " to fMo: " + this.rbsConfigurationMo.getFullDistinguishedName() + " is already sent to alarm service");
            }
        }
        logger.traceReturn(THIS_CLASS, "raiseAlarmPositionUnavailable()");
    }

    public void ceaseAlarmPositionUnavailable() {
        logger.traceEnter(THIS_CLASS, "ceaseAlarmPositionUnavailable()");
        if (this.alarmPosUnavailable != null) {
            String msg = "Cease alarm; moType = " + this.rbsConfigurationMo.getType() + ", moFullDistinguishedName = " + this.rbsConfigurationMo.getFullDistinguishedName() + ", " + this.alarmInfoPosUnavailable.toStringBuffer();
            logger.traceGeneral(THIS_CLASS, msg);
            this.alarmPosUnavailable.clear();
            this.alarmPosUnavailable = null;
        }
        logger.traceReturn(THIS_CLASS, "ceaseAlarmPositionUnavailable()");
    }

    public void ceaseAlarmPositionMismatch() {
        logger.traceEnter(THIS_CLASS, "ceaseAlarmPositionMismatch()");
        if (this.alarmPosMismatch != null) {
            String msg = "Cease alarm; moType = " + this.rbsConfigurationMo.getType() + ", moFullDistinguishedName = " + this.rbsConfigurationMo.getFullDistinguishedName() + ", " + this.alarmInfoPosUnavailable.toStringBuffer();
            logger.traceGeneral(THIS_CLASS, msg);
            this.alarmPosMismatch.clear();
            this.alarmPosMismatch = null;
        }
        logger.traceReturn(THIS_CLASS, "ceaseAlarmPositionMismatch()");
    }

    public boolean isUnavailableAlarmRaised() {
        return this.alarmPosUnavailable != null;
    }

    public boolean isMismatchAlarmRaised() {
        return this.alarmPosMismatch != null;
    }

    protected String getEventType(String inValue) {
        try {
            return (String)EventTypeValue.class.getField(inValue).get(null);
        }
        catch (IllegalAccessException e) {
            logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "Can not get fault info parameters for " + this.rbsConfigurationMo.toString());
        }
        catch (NoSuchFieldException e) {
            logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "Can not get fault info parameters for " + this.rbsConfigurationMo.toString());
        }
        return "";
    }

    protected String getProbableCause(String inValue) {
        try {
            return (String)ProbableCauseValue.class.getField(inValue).get(null);
        }
        catch (IllegalAccessException e) {
            logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "Can not get fault info parameters for " + this.rbsConfigurationMo.toString());
        }
        catch (NoSuchFieldException e) {
            logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "Can not get fault info parameters for " + this.rbsConfigurationMo.toString());
        }
        return "";
    }

    protected String getPerceivedSeverity(String inValue) {
        try {
            return (String)PerceivedSeverityValue.class.getField(inValue).get(null);
        }
        catch (IllegalAccessException e) {
            logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "Can not get fault info parameters for " + this.rbsConfigurationMo.toString());
        }
        catch (NoSuchFieldException e) {
            logger.traceAbnormal(this.rbsConfigurationMo.getClass(), "Can not get fault info parameters for " + this.rbsConfigurationMo.toString());
        }
        return "";
    }

    class AlarmFactoryWrapper {
        private AlarmFactoryInstanceWrapper instanceForTest = null;

        AlarmFactoryWrapper() {
        }

        public AlarmFactoryInstanceWrapper getInstance() {
            if (this.instanceForTest != null) {
                return this.instanceForTest;
            }
            return new AlarmFactoryInstanceWrapperImpl(AlarmFactory.getInstance());
        }

        public void setInstanceForTest(AlarmFactoryInstanceWrapper _instance) {
            this.instanceForTest = _instance;
        }
    }

    class AlarmFactoryInstanceWrapperImpl
    implements AlarmFactoryInstanceWrapper {
        private AlarmFactory instance = null;

        public AlarmFactoryInstanceWrapperImpl(AlarmFactory _instance) {
            this.instance = _instance;
        }

        public UpdatableAlarmWrapper createAlarm(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6, String arg7, AdditionalInfo[] arg8, int[] arg9, boolean arg10) throws AlarmDuplicatedException {
            return new UpdatableAlarmWrapperImpl(this.instance.createAlarm(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10));
        }
    }

    public class UpdatableAlarmWrapperImpl
    implements UpdatableAlarmWrapper {
        private UpdatableAlarm instance;

        public UpdatableAlarmWrapperImpl(UpdatableAlarm _instance) {
            this.instance = _instance;
        }

        public void clear() {
            this.instance.clear();
        }

        public void setAdditionalInfo(AdditionalInfo[] arg0) {
            this.instance.setAdditionalInfo(arg0);
        }
    }
}

