/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AddressResolver {
    private static final Class THIS_CLASS = AddressResolver.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public static String getIpAddressFromFqdn(String fqdn) throws UnknownHostException {
        logger.traceDebug(THIS_CLASS, "Resolve FQDN from DNS: " + fqdn);
        InetAddress inetAddress = InetAddress.getByName(fqdn);
        String result2 = inetAddress != null ? inetAddress.getHostAddress() : null;
        logger.traceDebug(THIS_CLASS, "Succeed to resolve FQDN from DNS: " + fqdn + " " + result2);
        return result2;
    }

    public static String getFqdnFromIpAddress(String ipAddress) throws UnknownHostException {
        logger.traceDebug(THIS_CLASS, "Resolve IP from DNS: " + ipAddress);
        InetAddress inetAddress = InetAddress.getByName(ipAddress);
        String result2 = inetAddress.getCanonicalHostName();
        if (result2.equalsIgnoreCase(ipAddress)) {
            result2 = "";
        }
        logger.traceDebug(THIS_CLASS, "Succeed to resolve IP from DNS: " + ipAddress + "" + result2);
        return result2;
    }
}

