/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPack;
import se.ericsson.crbs.omf.mao.genericmo.xml.XmlPackFactoryFactory;

public class DomXmlModifyHelper {
    private static final Class THIS_CLASS = DomXmlModifyHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Document doc;
    private final String fileToModify;
    private static final String EXCEPTION_SLOGAN = "Dom Xml Modifier";

    public DomXmlModifyHelper(String filePath) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "DomXmlModifyHelper()");
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.parse(filePath);
            this.fileToModify = filePath;
        }
        catch (Exception e) {
            String emsg = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
            logger.traceDebug(THIS_CLASS, "Failed to modify XML file() " + emsg);
            throw new RbsConfigurationFailedException(EXCEPTION_SLOGAN, "Failed to get DomXmlModifier , " + emsg, e);
        }
        logger.traceReturn(THIS_CLASS, "DomXmlModifyHelper()");
    }

    public boolean updateXmlAttribute(String element, String attribute, String attributeValue) {
        logger.traceEnter(THIS_CLASS, "updateXmlAttribute()");
        boolean success = false;
        NodeList elementList = this.doc.getElementsByTagName(element);
        if (elementList != null && elementList.getLength() == 1) {
            Element elementFound = (Element)elementList.item(0);
            elementFound.setAttribute(attribute, attributeValue);
            success = true;
        }
        logger.traceReturn(THIS_CLASS, "updateXmlAttribute(): " + success);
        return success;
    }

    public boolean updateXmlElement(String parentElement, String element, String[] attributes, String[] attributesValue) {
        logger.traceEnter(THIS_CLASS, "updateXmlElement()");
        boolean success = false;
        Element elementToAdd = this.doc.createElement(element);
        for (int i = 0; i < attributes.length; ++i) {
            elementToAdd.setAttribute(attributes[i], attributesValue[i]);
        }
        NodeList parentElementList = this.doc.getElementsByTagName(parentElement);
        if (parentElementList != null && parentElementList.getLength() == 1) {
            Element parentElementFound = (Element)parentElementList.item(0);
            NodeList elementList = parentElementFound.getElementsByTagName(element);
            if (elementList != null && elementList.getLength() == 1) {
                Element elementFound = (Element)elementList.item(0);
                parentElementFound.replaceChild(elementToAdd, elementFound);
                success = true;
            } else if (elementList != null && elementList.getLength() == 0) {
                parentElementFound.appendChild(elementToAdd);
                success = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "updateXmlElement(): " + success);
        return success;
    }

    public void writeToFile() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "writeToFile()");
        try {
            XmlPack xmlPack = XmlPackFactoryFactory.getXmlPackFactory().getXmlPack();
            String formattedDocument = xmlPack.transformDocument(this.doc);
            FileHelper.writeToFile((String)this.fileToModify, (String)formattedDocument, (boolean)false);
        }
        catch (SoftwareErrorException e) {
            String emsg = e.getMessage() == null ? ((Object)((Object)e)).getClass().getName() : e.getMessage();
            logger.traceDebug(THIS_CLASS, "Failed to modify XML file() " + emsg);
            throw new RbsConfigurationFailedException(EXCEPTION_SLOGAN, "Failed to modify file " + this.fileToModify + ", " + emsg, (Exception)((Object)e));
        }
        logger.traceReturn(THIS_CLASS, "writeToFile(): " + this.fileToModify);
    }
}

