/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistratorFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class IpAccessHostEtAddressSubscriber
implements AvcSubscriber {
    private static final Class THIS_CLASS = IpAccessHostEtAddressSubscriber.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepositoryWrapper;
    private String ipAddress = "";

    public IpAccessHostEtAddressSubscriber(RbsConfigurationMao rbsConfigurationMaoIn) {
        this.moRepositoryWrapper = rbsConfigurationMaoIn.getRbsConfigurationContext().getMoRepositoryWrapper();
    }

    public void subscribe() {
        logger.traceEnter(THIS_CLASS, "subscribe()");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, "IpAccessHostEt", "ipAddress");
        logger.traceReturn(THIS_CLASS, "subscribe()");
    }

    public void unsubscribe() {
        logger.traceEnter(THIS_CLASS, "unsubscribe()");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, "IpAccessHostEt", "ipAddress");
        logger.traceReturn(THIS_CLASS, "unsubscribe()");
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAvc(String ldnIn, String attrName, Object attrValue, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "reportAvc()");
        boolean unlock = false;
        IpAccessHostEtMo ipAccessHostEtMo = (IpAccessHostEtMo)this.moRepositoryWrapper.lookup(ldnIn);
        if (ipAccessHostEtMo != null && attrName.equals("ipAddress")) {
            this.ipAddress = ipAccessHostEtMo.getIpAddress(coordinator);
            unlock = true;
        } else {
            logger.traceAbnormal(THIS_CLASS, "Invalid AVC report received");
        }
        ConfigurationReportLoggerFactory.getLogger().logAttribute("IpAccessHostEt", attrName, (Object)this.ipAddress);
        if (unlock) {
            IpAccessHostEtAddressSubscriber ipAccessHostEtAddressSubscriber = this;
            synchronized (ipAccessHostEtAddressSubscriber) {
                this.notifyAll();
            }
        }
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    public void reportSubscriptionProblem(Coordinator coordinator) {
        logger.traceAbnormal(THIS_CLASS, "Subscription problem reported");
    }
}

