/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistratorFactoryImpl;
import se.ericsson.crbs.omf.mao.indications.avc.AvcSubscriber;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class IpHostLinkAddressSubscriber
implements AvcSubscriber {
    private static final Class THIS_CLASS = IpHostLinkAddressSubscriber.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepositoryWrapper;
    private String ipAddress = "";

    public IpHostLinkAddressSubscriber(RbsConfigurationMao rbsConfigurationMaoIn) {
        this.moRepositoryWrapper = rbsConfigurationMaoIn.getRbsConfigurationContext().getMoRepositoryWrapper();
    }

    public void subscribe() {
        logger.traceEnter(THIS_CLASS, "subscribe()");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, "IpHostLink", "ipv4Addresses");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().registerForUpdate((AvcSubscriber)this, "IpHostLink", "ipv6Addresses");
        logger.traceReturn(THIS_CLASS, "subscribe()");
    }

    public void unsubscribe() {
        logger.traceEnter(THIS_CLASS, "unsubscribe()");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, "IpHostLink", "ipv4Addresses");
        AvcRegistratorFactoryImpl.getInstance().getAvcRegistrator().unregisterForUpdate((AvcSubscriber)this, "IpHostLink", "ipv6Addresses");
        logger.traceReturn(THIS_CLASS, "unsubscribe()");
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportAvc(String ldnIn, String attrName, Object attrValue, Coordinator coordinator) throws MoAccessException {
        String[] addresses;
        logger.traceEnter(THIS_CLASS, "reportAvc()");
        boolean unlock = false;
        String logValue = null;
        IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.moRepositoryWrapper.lookup(ldnIn);
        if (ipHostLinkMo != null && attrName.equals("ipv4Addresses")) {
            addresses = ipHostLinkMo.getIpv4Addresses(coordinator);
            if (addresses != null && addresses.length > 0) {
                this.ipAddress = logValue = addresses[0];
                unlock = true;
            }
        } else if (ipHostLinkMo != null && attrName.equals("ipv6Addresses")) {
            addresses = ipHostLinkMo.getIpv6Addresses(coordinator);
            if (addresses != null && addresses.length > 0) {
                this.ipAddress = logValue = (String)addresses[0].getValue("ipAddress");
                unlock = true;
            }
        } else {
            logger.traceAbnormal(THIS_CLASS, "Invalid AVC report received");
        }
        if (logValue != null) {
            ConfigurationReportLoggerFactory.getLogger().logAttribute("IpHostLink", attrName, logValue);
        }
        if (unlock) {
            IpHostLinkAddressSubscriber ipHostLinkAddressSubscriber = this;
            synchronized (ipHostLinkAddressSubscriber) {
                this.notifyAll();
            }
        }
        logger.traceReturn(THIS_CLASS, "reportAvc()");
    }

    public void reportSubscriptionProblem(Coordinator coordinator) {
        logger.traceAbnormal(THIS_CLASS, "Subscription problem reported");
    }
}

