/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpV4AddressHolder {
    private static final Class THIS_CLASS = IpV4AddressHolder.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final int ipA;
    private final int ipB;
    private final int ipC;
    private final int ipD;

    public IpV4AddressHolder(String inIpAddress) {
        int start = 0;
        int stop = inIpAddress.indexOf(46, start);
        this.ipA = new Integer(inIpAddress.substring(start, stop));
        start = stop + 1;
        stop = inIpAddress.indexOf(46, start);
        this.ipB = new Integer(inIpAddress.substring(start, stop));
        start = stop + 1;
        stop = inIpAddress.indexOf(46, start + 1);
        this.ipC = new Integer(inIpAddress.substring(start, stop));
        start = stop + 1;
        stop = inIpAddress.indexOf(46, start + 1);
        this.ipD = new Integer(inIpAddress.substring(start));
    }

    public IpV4AddressHolder(int inIpA, int inIpB, int inIpC, int inIpD) {
        this.ipA = inIpA;
        this.ipB = inIpB;
        this.ipC = inIpC;
        this.ipD = inIpD;
    }

    public String toString() {
        return this.getIpA() + "." + this.getIpB() + "." + this.getIpC() + "." + this.getIpD();
    }

    public static IpV4AddressHolder bitwiseAnd(IpV4AddressHolder firstIpAddres, IpV4AddressHolder secondIpAddres) {
        logger.traceEnter(THIS_CLASS, "bitwiseAnd() with arguments " + firstIpAddres.toString() + " and " + secondIpAddres.toString());
        IpV4AddressHolder result2 = new IpV4AddressHolder(firstIpAddres.getIpA() & secondIpAddres.getIpA(), firstIpAddres.getIpB() & secondIpAddres.getIpB(), firstIpAddres.getIpC() & secondIpAddres.getIpC(), firstIpAddres.getIpD() & secondIpAddres.getIpD());
        logger.traceReturn(THIS_CLASS, "bitwiseAnd() returned " + result2.toString());
        return result2;
    }

    public static IpV4AddressHolder invert(IpV4AddressHolder ipAddres) {
        logger.traceEnter(THIS_CLASS, "invert() with argument " + ipAddres.toString());
        IpV4AddressHolder result2 = new IpV4AddressHolder(ipAddres.getIpA() ^ 0xFF, ipAddres.getIpB() ^ 0xFF, ipAddres.getIpC() ^ 0xFF, ipAddres.getIpD() ^ 0xFF);
        logger.traceReturn(THIS_CLASS, "invert() returned " + result2.toString());
        return result2;
    }

    public static IpV4AddressHolder bitwiseOr(IpV4AddressHolder firstIpAddres, IpV4AddressHolder secondIpAddres) {
        logger.traceEnter(THIS_CLASS, "bitwiseOr() with arguments " + firstIpAddres.toString() + " and " + secondIpAddres.toString());
        IpV4AddressHolder result2 = new IpV4AddressHolder(firstIpAddres.getIpA() | secondIpAddres.getIpA(), firstIpAddres.getIpB() | secondIpAddres.getIpB(), firstIpAddres.getIpC() | secondIpAddres.getIpC(), firstIpAddres.getIpD() | secondIpAddres.getIpD());
        logger.traceReturn(THIS_CLASS, "bitwiseOr() returned " + result2.toString());
        return result2;
    }

    public int getIpA() {
        logger.traceEnter(THIS_CLASS, "getIpA");
        logger.traceReturn(THIS_CLASS, "getIpA() returns " + this.ipA);
        return this.ipA;
    }

    public int getIpB() {
        logger.traceEnter(THIS_CLASS, "getIpB");
        logger.traceReturn(THIS_CLASS, "getIpB() returns " + this.ipB);
        return this.ipB;
    }

    public int getIpC() {
        logger.traceEnter(THIS_CLASS, "getIpC");
        logger.traceReturn(THIS_CLASS, "getIpC() returns " + this.ipC);
        return this.ipC;
    }

    public int getIpD() {
        logger.traceEnter(THIS_CLASS, "getIpD");
        logger.traceReturn(THIS_CLASS, "getIpD() returns " + this.ipD);
        return this.ipD;
    }
}

