/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.ORB;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.OrbCreatorFactory;

public class OrbSupervisingThread
extends Thread {
    private static final Class THIS_CLASS = OrbSupervisingThread.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static int defaultRetryInterval = 250;
    private final int retryInterval = defaultRetryInterval;
    protected boolean keepRunning = true;
    private boolean orbDown = false;
    private boolean orbRestarted = false;

    public OrbSupervisingThread() {
        super("lteRbsOmf_ORB_Supervising_Thread");
    }

    public void stopIt() {
        this.keepRunning = false;
    }

    public static void setRetryInterval(int theDefaultRetryInterval) {
        if (System.getProperty("UNIT_TEST", "false").equalsIgnoreCase("true")) {
            defaultRetryInterval = theDefaultRetryInterval;
        }
    }

    public boolean orbHasBeenDownAndComeUpAgain() {
        return this.orbDown && this.orbRestarted;
    }

    public void run() {
        this.orbDown = this.waitForOrbToGoDown();
        this.waitForOrbToComUpAgain(this.orbDown);
    }

    private boolean waitForOrbToGoDown() {
        logger.traceEnter(THIS_CLASS, "waitForOrbToGoDown()");
        while (this.keepRunning && !this.orbDown) {
            try {
                ORB cppOrb = OrbCreatorFactory.getInstance().getOrbCreator().getOrb();
                this.checkOrbStatus(cppOrb);
                this.orbDown = false;
                this.waitForNextRetry();
            }
            catch (OrbIsDownException orbDownException) {
                this.orbDown = true;
                logger.traceGeneral(THIS_CLASS, "ORB is shut down");
            }
            catch (Exception ignore) {
                this.orbDown = false;
                this.waitForNextRetry();
            }
        }
        logger.traceReturn(THIS_CLASS, "waitForOrbToGoDown(" + this.orbDown + ")");
        return this.orbDown;
    }

    private void waitForOrbToComUpAgain(boolean orbHasBeenDown) {
        while (this.keepRunning && orbHasBeenDown && !this.orbRestarted) {
            try {
                ORB cppOrb = OrbCreatorFactory.getInstance().getOrbCreator().getOrb();
                this.checkOrbStatus(cppOrb);
                this.orbRestarted = true;
                logger.traceGeneral(THIS_CLASS, "ORB is restarted");
            }
            catch (OrbIsDownException orbDownException) {
                this.orbRestarted = false;
                this.waitForNextRetry();
            }
            catch (Exception ignore) {
                this.orbRestarted = false;
                this.waitForNextRetry();
            }
        }
    }

    private void waitForNextRetry() {
        try {
            Thread.sleep(this.retryInterval);
        }
        catch (InterruptedException interrupted) {
            logger.traceDebug(THIS_CLASS, "Interrupted while waiting for CPP OORB.");
        }
    }

    private void checkOrbStatus(ORB cppOrb) throws OrbIsDownException {
        try {
            if (cppOrb != null) {
                cppOrb.work_pending();
            }
        }
        catch (BAD_INV_ORDER orbDownException) {
            throw new OrbIsDownException();
        }
    }

    private class OrbIsDownException
    extends Exception {
        public OrbIsDownException() {
            super("The ORB is down");
        }
    }
}

