/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.ParserFactoryImpl;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class ParserHelper
extends se.ericsson.crbs.common.ParserHelper {
    private static final Class THIS_CLASS = ParserHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String xsdFileExtension = ".xsd";
    private static final String dtdFileExtension = ".dtd";
    private static final String revisionFilePart = "Rev";
    private static final Map validationSchemas = new HashMap();

    private ParserHelper() {
    }

    public static Parser createParser(String filePath) throws IOException {
        return ParserHelper.createParser(filePath, false, null);
    }

    public static Parser createParser(String filePath, boolean validateXml, String schemaPath) throws IOException {
        logger.traceEnter(THIS_CLASS, "createParser()");
        if (validateXml && schemaPath == null) {
            throw new IOException("Wrong use of ParserHelper.createParser, schemaPath cannot be null when validateXml is true.");
        }
        ParserFactoryImpl parserFactory = new ParserFactoryImpl();
        File xmlFile = new File(filePath);
        if (!xmlFile.exists()) {
            throw new IOException("Unable to find file: " + filePath);
        }
        if (xmlFile.isDirectory()) {
            throw new IOException("Provided path is not a file! " + filePath);
        }
        String fileDir = FileHelper.extractFileDirFromFilePath((String)filePath);
        String fileName = FileHelper.extractFileNameFromFilePath((String)filePath);
        Parser parser = null;
        if (validateXml) {
            String[] fileTypeAndRevision = ParserHelper.getFileTypeAndRevision(filePath);
            String schemaFilePath = ParserHelper.getSchemaFilePath(schemaPath, fileTypeAndRevision[0], fileTypeAndRevision[1]);
            parser = parserFactory.createParser(fileName, fileDir, schemaFilePath);
        } else {
            parser = parserFactory.createParser(fileName, fileDir);
        }
        logger.traceReturn(THIS_CLASS, "createParser()");
        return parser;
    }

    public static String[] getFileTypeAndRevision(String filePath) throws IOException {
        logger.traceEnter(THIS_CLASS, "getFileTypeAndRevision()");
        String fileType = null;
        String revision = null;
        BufferedReader reader = null;
        try {
            File xmlFile = new File(filePath);
            reader = new BufferedReader(new FileReader(xmlFile));
            String line = reader.readLine();
            while (line != null) {
                if (fileType == null) {
                    fileType = ParserHelper.getFileType(line);
                }
                if (ParserHelper.fileTypeAndRevisionIsCorrect(fileType, revision = ParserHelper.getRevision(line))) {
                    break;
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            logger.traceDebug(THIS_CLASS, "Error when trying to find file: " + filePath);
            throw new IOException("XML file, " + filePath + ", could not be found.");
        }
        catch (IOException e) {
            logger.traceDebug(THIS_CLASS, "Error when trying to read file: " + filePath);
            throw new IOException("XML file, " + filePath + ", could not be read.");
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        ParserHelper.checkFileTypeAndRevision(filePath, fileType, revision);
        logger.traceReturn(THIS_CLASS, "getFileTypeAndRevision()");
        return new String[]{fileType, revision};
    }

    private static boolean fileTypeAndRevisionIsCorrect(String fileType, String revision) {
        return fileType != null && revision != null;
    }

    private static void checkFileTypeAndRevision(String filePath, String fileType, String revision) throws IOException {
        if (fileType == null || revision == null) {
            logger.traceDebug(THIS_CLASS, "Error when trying determine type of file and/or revision for: " + filePath);
            throw new IOException("Could not determine type of file and/or revision for: " + filePath);
        }
    }

    private static String getFileType(String fileLine) {
        logger.traceEnter(THIS_CLASS, "getFileType()");
        String fileType = null;
        if (fileLine.indexOf("<SiteBasic") != -1) {
            fileType = (String)validationSchemas.get("SiteBasic");
        } else if (fileLine.indexOf("<SiteEquipment") != -1) {
            fileType = (String)validationSchemas.get("SiteEquipment");
        } else if (fileLine.indexOf("<RbsSiteInstallationFile") != -1) {
            fileType = (String)validationSchemas.get("RbsSiteInstallationFile");
        } else if (fileLine.indexOf("<AutoIntegrationRbsSummaryFile") != -1) {
            fileType = (String)validationSchemas.get("AutoIntegrationRbsSummaryFile");
        } else if (fileLine.indexOf("<NpcConfig") != -1) {
            fileType = (String)validationSchemas.get("NpcConfig");
        } else if (fileLine.indexOf("<NlHandoverFile") != -1) {
            fileType = (String)validationSchemas.get("NlHandoverFile");
        }
        logger.traceReturn(THIS_CLASS, "getFileType()");
        return fileType;
    }

    private static String getRevision(String textLine) {
        int endOfRevision;
        logger.traceEnter(THIS_CLASS, "getRevision()");
        String revision = null;
        int revisionIndex = textLine.indexOf("revision=\"");
        if (revisionIndex != -1 && (endOfRevision = textLine.indexOf("\"", revisionIndex + "revision".length() + 2)) != -1) {
            revision = textLine.substring(revisionIndex + "revision".length() + 2, endOfRevision);
        }
        logger.traceReturn(THIS_CLASS, "getRevision()");
        return revision;
    }

    public static String getSchemaFilePath(String schemaPath, String fileType, String revision) throws IOException {
        logger.traceEnter(THIS_CLASS, "getSchemaFilePath(), filePath = " + fileType + ", revision = " + revision);
        String schemaFilePath = schemaPath + fileType + revisionFilePart + revision;
        URL url = ClassLoader.getSystemClassLoader().getResource(schemaFilePath + xsdFileExtension);
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource(schemaFilePath + dtdFileExtension);
        }
        if (url == null) {
            logger.traceDebug(THIS_CLASS, "Error when trying to find validation schema for " + fileType + " revision " + revision + ".");
            throw new IOException("Could not find validation schema for " + fileType + " revision " + revision + ".");
        }
        logger.traceReturn(THIS_CLASS, "getSchemaFilePath(), path = " + url.toString());
        return url.toString();
    }

    public static void checkCardinality(String elementName, Object[] elementArray, int minOccurs, int maxOccurs) throws IOException {
        logger.traceEnter(THIS_CLASS, "checkCardinality() name: " + elementName + " min: " + minOccurs + " max: " + maxOccurs);
        int arraySize = 0;
        if (elementArray != null) {
            arraySize = elementArray.length;
        }
        if (arraySize < minOccurs || arraySize > maxOccurs) {
            throw new IOException("Invalid XML file: " + elementName + " is out of bounds. Min: " + minOccurs + " Max: " + maxOccurs + ".");
        }
        logger.traceReturn(THIS_CLASS, "checkCardinality()");
    }

    public static void checkMandatoryAttribute(String name, Object value) throws IOException {
        logger.traceEnter(THIS_CLASS, "checkMandatoryAttribute() name: " + name);
        if (value == null) {
            throw new IOException("Invalid XML file: " + name + " is missing.");
        }
        logger.traceReturn(THIS_CLASS, "checkMandatoryAttribute() value: " + value);
    }

    public static Map createAttrNameValueMap(AttributesImpl attrNameValues) {
        HashMap<String, String> attrNameValueMap = new HashMap<String, String>();
        for (int index = 0; index < attrNameValues.getLength(); ++index) {
            attrNameValueMap.put(attrNameValues.getQName(index).toLowerCase(Locale.getDefault()), StringHelper.emptyStringToNull((String)attrNameValues.getValue(index)));
        }
        return attrNameValueMap;
    }

    public static Map createXmlTypeElementMap(List xmlElementList) {
        HashMap xmlTypeElementMap = new HashMap();
        Iterator xmlIter = xmlElementList.iterator();
        while (xmlIter.hasNext()) {
            List<XMLElement> elements;
            XMLElement xmlElement = (XMLElement)xmlIter.next();
            String xmlType = xmlElement.getType().toLowerCase(Locale.getDefault());
            if (xmlTypeElementMap.containsKey(xmlType)) {
                elements = (List)xmlTypeElementMap.get(xmlType);
                elements.add(xmlElement);
                continue;
            }
            elements = new ArrayList();
            elements.add(xmlElement);
            xmlTypeElementMap.put(xmlType, elements);
        }
        return xmlTypeElementMap;
    }

    static {
        validationSchemas.put("SiteBasic", "SiteBasic");
        validationSchemas.put("SiteEquipment", "SiteEquipment");
        validationSchemas.put("RbsSiteInstallationFile", "SiteInstallation");
        validationSchemas.put("AutoIntegrationRbsSummaryFile", "SummaryFile");
        validationSchemas.put("NpcConfig", "NPC");
        validationSchemas.put("NlHandoverFile", "Nlh");
    }
}

