/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;

public class RbsConfigurationMmeHelper
extends AbstractRbsConfigurationHelper {
    private static final Class THIS_CLASS = RbsConfigurationMmeHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private boolean mmeReady = false;
    private boolean ossReady = false;
    private RbsConfigurationHelper helper;

    protected void init(GenericMaoContext aGenericMaoContext, RbsConfigurationMao aRbsConfiguration, RbsConfigurationContext aRbsConfigurationContext) {
        super.init(aGenericMaoContext, aRbsConfiguration, aRbsConfigurationContext);
        this.helper = (RbsConfigurationHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationHelper.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOssComplete() {
        logger.traceEnter(THIS_CLASS, "reportOssComplete()");
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.ossReady = true;
        }
        logger.traceReturn(THIS_CLASS, "reportOssComplete()");
    }

    public void waitForS1() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "waitForS1()");
        this.getCorrectStateOfOssReady();
        this.waitForOss();
        boolean existanceOfSectorEquipmentFunctionMos = this.checkForSectorEquipmentFunctionMos();
        boolean existanceOfEUtranCellMos = this.checkForEUtranCellMos();
        if (existanceOfSectorEquipmentFunctionMos && !existanceOfEUtranCellMos) {
            this.rbsConfiguration.storePersistently("modeForExecution", "XMU");
            this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_S1_NOT_NEEDED);
            logger.traceDebug(THIS_CLASS, "Setting XMU MODE");
        } else if (!existanceOfSectorEquipmentFunctionMos && !existanceOfEUtranCellMos) {
            this.rbsConfiguration.storePersistently("modeForExecution", "TMR");
            this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_S1_NOT_NEEDED);
            logger.traceDebug(THIS_CLASS, "Setting TMR MODE");
        } else {
            this.waitForEnabledTermPointToMme();
            this.rbsConfiguration.storePersistently("modeForExecution", "STANDARD");
            this.helper.setRbsConfigLevel(RbsConfigurationDefinitions.RBS_CL_S1_COMPLETE);
            logger.traceDebug(THIS_CLASS, "Setting Legacy/Standard MODE");
        }
        logger.traceReturn(THIS_CLASS, "waitForS1()");
    }

    public Integer waitForGeoCheck() {
        logger.traceEnter(THIS_CLASS, "waitForGeoCheck()");
        Integer returnValue = new Integer(0);
        boolean done = false;
        while (!done) {
            Integer rbsConfigLevel = this.helper.getRbsConfigLevel();
            if (RbsConfigurationDefinitions.RBS_CL_GPS_CHECK_POSITION.equals(rbsConfigLevel)) {
                returnValue = RbsConfigurationDefinitions.RBS_CL_GPS_CHECK_POSITION;
                done = true;
            } else {
                String cellsBooleanStr = (String)this.rbsConfiguration.retrievePersistently("unlockingOfCellsTriggered");
                if (Boolean.TRUE.toString().equalsIgnoreCase(cellsBooleanStr) || RbsConfigurationDefinitions.RBS_CL_INTEGRATION_COMPLETE.equals(rbsConfigLevel)) {
                    returnValue = RbsConfigurationDefinitions.RBS_CL_CELLS_UNLOCKED;
                    done = true;
                }
            }
            try {
                if (done) continue;
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                logger.traceDebug(THIS_CLASS, "Thread interrupted in unexpected state!");
            }
        }
        logger.traceReturn(THIS_CLASS, "waitForGeoCheck()");
        return returnValue;
    }

    private boolean checkForEUtranCellMos() {
        logger.traceEnter(THIS_CLASS, "checkForEUtranCellMos()");
        boolean eUtranCellMos = false;
        MoIterator moIteratorFDD = this.rbsConfigurationContext.getMoRepositoryWrapper().lookupType("EUtranCellFDD");
        MoIterator moIteratorTDD = this.rbsConfigurationContext.getMoRepositoryWrapper().lookupType("EUtranCellTDD");
        if (moIteratorFDD != null && moIteratorFDD.size() > 0 || moIteratorTDD != null && moIteratorTDD.size() > 0) {
            eUtranCellMos = true;
        }
        logger.traceReturn(THIS_CLASS, "checkForEUtranCellMos()=" + eUtranCellMos);
        return eUtranCellMos;
    }

    private boolean checkForSectorEquipmentFunctionMos() {
        logger.traceEnter(THIS_CLASS, "checkForSectorEquipmentFunctionMos()");
        boolean sectorEquipmentFunctionMos = false;
        MoIterator moIterator = this.rbsConfigurationContext.getMoRepositoryWrapper().lookupType("SectorEquipmentFunction");
        if (moIterator != null && moIterator.size() > 0) {
            sectorEquipmentFunctionMos = true;
        }
        logger.traceReturn(THIS_CLASS, "checkForSectorEquipmentFunctionMos()=" + sectorEquipmentFunctionMos);
        return sectorEquipmentFunctionMos;
    }

    private void getCorrectStateOfOssReady() {
        this.ossReady = RbsConfigurationDefinitions.RBS_CL_OSS_CONFIGURATION_SUCCESSFUL.equals(this.helper.getRbsConfigLevel());
    }

    private void waitForOss() {
        while (!this.ossReady) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                logger.traceDebug(THIS_CLASS, "Thread interrupted in unexpected state!");
            }
        }
    }

    private void waitForEnabledTermPointToMme() {
        boolean foundMme = false;
        while (!this.mmeReady) {
            MoIterator mmeIter = this.genericMaoContext.getMoRepositoryWrapper().lookupType("TermPointToMme");
            if (mmeIter != null && mmeIter.size() > 0) {
                if (!foundMme) {
                    ProgressReportHandler.getInstance().updateProgressReportInformation(2500, 3, "Establishing S1 connection", true);
                    foundMme = true;
                }
                this.searchForActiveTermPointToMme(mmeIter);
            }
            if (this.mmeReady) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.traceDebug(THIS_CLASS, "Thread interrupted in unexpected state!");
            }
        }
    }

    private void searchForActiveTermPointToMme(MoIterator termPointToMmeIter) {
        while (termPointToMmeIter.hasMoreElements() && !this.mmeReady) {
            try {
                ManagedObject termPointToMme = termPointToMmeIter.nextMo();
                Integer currentState = (Integer)termPointToMme.getAttribute("operationalState", null);
                if (!RbsConfigurationDefinitions.TERM_POINT_TO_MME_OPER_STATE_ENABLED.equals(currentState)) continue;
                ProgressReportHandler.getInstance().updateProgressReportInformation(2500, 5, "S1 connection successfuly established", true);
                this.mmeReady = true;
            }
            catch (MoAccessException mae) {
                logger.traceAbnormal(THIS_CLASS, "Could not read attribute operationalState from a TermPointToMme MO.");
            }
        }
    }

    public void resetMmeHelper() {
        this.mmeReady = false;
        this.ossReady = false;
    }

    protected boolean isMmeComplete() {
        return this.mmeReady;
    }

    protected boolean isOssComplete() {
        return this.ossReady;
    }

    public String getHelperName() {
        return this.getClass().getName();
    }
}

