/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RbsConfigurationSummaryFileParser {
    private static final Class THIS_CLASS = RbsConfigurationSummaryFileParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final int RAN_LTE = 1;
    public static final int RAN_WCDMA = 2;
    private int ran = 0;

    public Map parseSummaryFile(String summaryFilePath) throws IOException {
        return this.parseSummaryFile(summaryFilePath, false, null);
    }

    protected Map parseSummaryFile(String summaryFilePath, boolean validateXml, String schemaPath) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseSummaryFile() - summaryFilePath = " + summaryFilePath);
        HashMap configFiles = new HashMap();
        Parser parser = ParserHelper.createParser(summaryFilePath, validateXml, schemaPath);
        List xmlList = parser.getXMLelements();
        String revision = "";
        if (xmlList == null) {
            throw new IOException("Could not parse SummaryFile, invalid XML.");
        }
        Iterator xmlIter = xmlList.iterator();
        int ranCounter = 0;
        while (xmlIter.hasNext()) {
            XMLElement xmlElement = (XMLElement)xmlIter.next();
            String xmlChildType = xmlElement.getType();
            if ("Format".equals(xmlChildType)) {
                revision = xmlElement.getAttributes().getValue("revision");
                logger.traceDebug(THIS_CLASS, "parseSummaryFile() revision=" + revision);
            }
            if ("WcdmaConfigurationFiles".equals(xmlChildType)) {
                ++ranCounter;
                this.ran = 2;
                String oamAccessFilePath = this.putSmrsFile("oamAccessFilePath", xmlElement, configFiles);
                String siteEquipFilePathWcdma = this.putSmrsFile("siteEquipmentFilePath", xmlElement, configFiles);
                logger.traceDebug(THIS_CLASS, "parseSummaryFile() oamAccessFilePath=" + oamAccessFilePath + " siteEquipFilePathWcdma=" + siteEquipFilePathWcdma);
                if (oamAccessFilePath == null || siteEquipFilePathWcdma == null) {
                    throw new IOException("Invalid summaryfile: WCDMA required file(s) (OAM Access or Site Equipment) are  missing.");
                }
                this.putSmrsFile("cabinetEquipmentFilePath", xmlElement, configFiles);
                this.putSmrsFile("antennaSystemFilePath", xmlElement, configFiles);
                this.putSmrsFile("upgradePackageFilePath", xmlElement, configFiles);
                this.putSmrsFile("integrationBasicPackageFilePath", xmlElement, configFiles);
            }
            if (!"ConfigurationFiles".equals(xmlChildType)) continue;
            ++ranCounter;
            this.ran = 1;
            String siteBasicFilePath = this.putSmrsFile("siteBasicFilePath", xmlElement, configFiles);
            String ipForOamSettingFilePath = this.putSmrsFile("ipForOamSettingFilePath", xmlElement, configFiles);
            String siteEquipFilePathLte = this.putSmrsFile("siteEquipmentFilePath", xmlElement, configFiles);
            logger.traceDebug(THIS_CLASS, "parseSummaryFile() siteBasicFilePath=" + siteBasicFilePath + " ipForOamSettingFilePath=" + ipForOamSettingFilePath + " siteEquipFilePathLte=" + siteEquipFilePathLte);
            if (ipForOamSettingFilePath == null && siteBasicFilePath == null && siteEquipFilePathLte == null) {
                throw new IOException("Invalid summaryfile: LTE required file(s) are  missing.");
            }
            if (ipForOamSettingFilePath == null && (siteBasicFilePath == null || siteEquipFilePathLte == null)) {
                throw new IOException("Invalid summaryfile: Site Basic or Site Equipment is missing.");
            }
            if (ipForOamSettingFilePath != null && (siteBasicFilePath != null || siteEquipFilePathLte != null)) {
                throw new IOException("Invalid summaryfile: To many configuration files.");
            }
            this.putSmrsFile("integrationBasicPackageFilePath", xmlElement, configFiles);
            this.putSmrsFile("licensingKeyFilePath", xmlElement, configFiles);
            this.putSmrsFile("upgradePackageFilePath", xmlElement, configFiles);
            this.putSmrsFile("initialSecurityConfigurationFilePath", xmlElement, configFiles);
            this.putSmrsFile("initialSecurityConfigurationFileHash", xmlElement, configFiles);
            this.putSmrsFile("siteBasicFileHash", xmlElement, configFiles);
            this.putSmrsFile("ipForOamSettingFileHash", xmlElement, configFiles);
        }
        if (ranCounter != 1) {
            throw new IOException("Invalid summaryfile: None or more than one RAN detected.");
        }
        logger.traceReturn(THIS_CLASS, "parseSummaryFile()");
        return configFiles;
    }

    public int getRan() {
        return this.ran;
    }

    private String putSmrsFile(String inputPath, XMLElement xmlElement, Map smrsFiles) {
        String outPath = xmlElement.getAttributes().getValue(inputPath);
        if (outPath != null) {
            smrsFiles.put(inputPath, outPath);
        }
        return outPath;
    }
}

