/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.helper;

import java.io.File;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.CryptionHolder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.SensitiveDataStore;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.StringEncryptor;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SensitiveDataHelper
extends AbstractRbsConfigurationHelper {
    public static final String SMRS_USERNAME = "smrsUsername";
    public static final String SMRS_PASSWORD = "smrsPassword";
    public static final String SFTP_USERNAME = "sftpUsername";
    public static final String SFTP_PASSWORD = "sftpPassword";
    public static final String RBS_INTEGRATION_CODE = "rbsIntegrationCode";
    private static final Class THIS_CLASS = SensitiveDataHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String filePath = "";
    private SensitiveDataStore sensitiveDataStore = null;
    protected String smrsUserName = "";
    protected String smrsPassword = "";
    protected String rbsIntegrationCode = "";
    protected String sftpUserName = "";
    protected String sftpPassword = "";

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String inputFilePath) throws RbsConfigurationFailedException {
        this.filePath = inputFilePath;
        File inputFile = new File(this.filePath);
        File outputDir = inputFile.getParentFile();
        if (inputFile.exists()) {
            try {
                this.sensitiveDataStore = SensitiveDataStore.restoreFromDisc(inputFilePath);
                this.smrsUserName = this.retrieveSmrsUserName();
                this.smrsPassword = this.retrieveSmrsPassword();
                this.rbsIntegrationCode = this.retrieveRbsIntegrationCode();
                this.sftpUserName = this.retrieveSftpUserName();
                this.sftpPassword = this.retrieveSftpPassword();
            }
            catch (RbsConfigurationFailedException e) {
                logger.traceAbnormal(THIS_CLASS, "Error: /c/configuration/rbs_auto_integration_data.dat is faulty");
                this.sensitiveDataStore = new SensitiveDataStore();
            }
        } else {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new RbsConfigurationFailedException("Sensitive data storage failure", "Failed to create directory: " + outputDir);
            }
            this.sensitiveDataStore = new SensitiveDataStore();
        }
    }

    public void storeSmrsUserName(String inputSmrsUserName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSmrsUserName()");
        if (inputSmrsUserName == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified SMRS user name is null");
        }
        this.smrsUserName = inputSmrsUserName;
        this.storeSensitiveString(SMRS_USERNAME, inputSmrsUserName, coordinator);
        logger.traceReturn(THIS_CLASS, "storeSmrsUserName()");
    }

    public String retrieveSmrsUserName() {
        logger.traceEnter(THIS_CLASS, "retrieveSmrsUserName()");
        String result2 = this.smrsUserName == null || this.smrsUserName.equalsIgnoreCase("") ? this.retrieveSensitiveString(SMRS_USERNAME) : this.smrsUserName;
        logger.traceReturn(THIS_CLASS, "retrieveSmrsUserName()");
        return result2;
    }

    private String retrieveSensitiveString(String sensitiveStringName) {
        String result2;
        String rawDataBaseString = (String)this.rbsConfiguration.retrievePersistently(sensitiveStringName);
        if (rawDataBaseString == null || rawDataBaseString.equalsIgnoreCase("")) {
            result2 = "";
        } else {
            long[] dataBaseString = CryptionHolder.convertToArray(rawDataBaseString);
            String rawFileString = this.getStringFromSensitiveDataStore(sensitiveStringName);
            long[] fileString = CryptionHolder.convertToArray(rawFileString);
            CryptionHolder cryptionHolder = new CryptionHolder(fileString, dataBaseString);
            StringEncryptor stringEncryptor = new StringEncryptor();
            result2 = stringEncryptor.decrypt(cryptionHolder);
        }
        return result2;
    }

    private String getStringFromSensitiveDataStore(String sensitiveStringName) {
        String sensitiveString = null;
        if (sensitiveStringName.equals(RBS_INTEGRATION_CODE)) {
            sensitiveString = this.sensitiveDataStore.getRbsIntegrationCode();
        } else if (sensitiveStringName.equals(SMRS_USERNAME)) {
            sensitiveString = this.sensitiveDataStore.getSmrsUserName();
        } else if (sensitiveStringName.equals(SMRS_PASSWORD)) {
            sensitiveString = this.sensitiveDataStore.getSmrsPassword();
        } else if (sensitiveStringName.equals(SFTP_USERNAME)) {
            sensitiveString = this.sensitiveDataStore.getSftpUserName();
        } else if (sensitiveStringName.equals(SFTP_PASSWORD)) {
            sensitiveString = this.sensitiveDataStore.getSftpPassword();
        }
        return sensitiveString;
    }

    public void removeSmrsUserName(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeSmrsUserName()");
        this.smrsUserName = "";
        this.rbsConfiguration.removeAdditionalAttribute(SMRS_USERNAME, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSmrsUserName("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeSmrsUserName()");
    }

    public void storeSmrsPassword(String inputSmrsPassword, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSmrsPassword()");
        if (inputSmrsPassword == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified SMRS password is null");
        }
        this.smrsPassword = inputSmrsPassword;
        this.storeSensitiveString(SMRS_PASSWORD, inputSmrsPassword, coordinator);
        logger.traceReturn(THIS_CLASS, "storeSmrsPassword()");
    }

    private void storeSensitiveString(String sensitiveStringName, String sensitiveStringValue, Coordinator coordinator) throws MoAccessException, RbsConfigurationFailedException {
        StringEncryptor stringEncryptor = new StringEncryptor();
        CryptionHolder stringCryptionHolder = stringEncryptor.encrypt(sensitiveStringValue);
        String dataBaseString = CryptionHolder.convertToString(stringCryptionHolder.getDatabaseCryption());
        if (coordinator == null) {
            this.rbsConfiguration.storePersistently(sensitiveStringName, dataBaseString);
        } else {
            this.rbsConfiguration.storePersistently(sensitiveStringName, dataBaseString, coordinator);
        }
        String fileString = CryptionHolder.convertToString(stringCryptionHolder.getFileCryption());
        if (this.sensitiveDataStore != null) {
            this.updateSensitiveDataStore(sensitiveStringName, fileString);
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
    }

    private void updateSensitiveDataStore(String sensitiveStringName, String fileString) {
        if (sensitiveStringName.equals(RBS_INTEGRATION_CODE)) {
            this.sensitiveDataStore.setRbsIntegrationCode(fileString);
        } else if (sensitiveStringName.equals(SMRS_USERNAME)) {
            this.sensitiveDataStore.setSmrsUserName(fileString);
        } else if (sensitiveStringName.equals(SMRS_PASSWORD)) {
            this.sensitiveDataStore.setSmrsPassword(fileString);
        } else if (sensitiveStringName.equals(SFTP_USERNAME)) {
            this.sensitiveDataStore.setSftpUserName(fileString);
        } else if (sensitiveStringName.equals(SFTP_PASSWORD)) {
            this.sensitiveDataStore.setSftpPassword(fileString);
        }
    }

    public String retrieveSmrsPassword() {
        logger.traceEnter(THIS_CLASS, "retrieveSmrsPassword()");
        String result2 = this.smrsPassword == null || this.smrsPassword.equalsIgnoreCase("") ? this.retrieveSensitiveString(SMRS_PASSWORD) : this.smrsPassword;
        logger.traceReturn(THIS_CLASS, "retrieveSmrsPassword()");
        return result2;
    }

    public void removeSmrsPassword(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeSmrsPassword()");
        this.smrsPassword = "";
        this.rbsConfiguration.removeAdditionalAttribute(SMRS_PASSWORD, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSmrsPassword("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeSmrsPassword()");
    }

    public void storeRbsIntegrationCode(String inputRbsIntegrationCode, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeRbsIntegrationCode()");
        if (inputRbsIntegrationCode == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified RBS integration code is null");
        }
        this.rbsIntegrationCode = inputRbsIntegrationCode;
        this.storeSensitiveString(RBS_INTEGRATION_CODE, this.rbsIntegrationCode, coordinator);
        logger.traceReturn(THIS_CLASS, "storeRbsIntegrationCode()");
    }

    public String retrieveRbsIntegrationCode() {
        logger.traceEnter(THIS_CLASS, "retrieveRbsIntegrationCode()");
        String result2 = this.rbsIntegrationCode == null || this.rbsIntegrationCode.equalsIgnoreCase("") ? this.retrieveSensitiveString(RBS_INTEGRATION_CODE) : this.rbsIntegrationCode;
        logger.traceReturn(THIS_CLASS, "retrieveRbsIntegrationCode()");
        return result2;
    }

    public void removeRbsIntegrationCode(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeRbsIntegrationCode()");
        this.rbsIntegrationCode = "";
        this.rbsConfiguration.removeAdditionalAttribute(RBS_INTEGRATION_CODE, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setRbsIntegrationCode("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeRbsIntegrationCode()");
    }

    public String getHelperName() {
        return this.getClass().getName();
    }

    public void clearSensitiveData(Coordinator coordinator) throws MoAccessException {
        this.storeSmrsUserName("", coordinator);
        this.storeSmrsPassword("", coordinator);
        this.storeRbsIntegrationCode("", coordinator);
        this.storeSftpUserName("", coordinator);
        this.storeSftpPassword("", coordinator);
    }

    public void storeSftpPassword(String inputSftpPassword, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSftpPassword()");
        if (inputSftpPassword == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified SFTP password is null");
        }
        this.sftpPassword = inputSftpPassword;
        this.storeSensitiveString(SFTP_PASSWORD, inputSftpPassword, coordinator);
        logger.traceReturn(THIS_CLASS, "storeSftpPassword()");
    }

    public void storeSftpUserName(String inputSftpUserName, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "storeSftpUserName()");
        if (inputSftpUserName == null) {
            throw new RbsConfigurationFailedException("Sensitive data storage failure", "Specified SFTP user name is null");
        }
        this.sftpUserName = inputSftpUserName;
        this.storeSensitiveString(SFTP_USERNAME, inputSftpUserName, coordinator);
        logger.traceReturn(THIS_CLASS, "storeSftpUserName()");
    }

    public String retrieveSftpUserName() {
        logger.traceEnter(THIS_CLASS, "retrieveSftpUserName()");
        String result2 = this.sftpUserName == null || this.sftpUserName.equalsIgnoreCase("") ? this.retrieveSensitiveString(SFTP_USERNAME) : this.sftpUserName;
        logger.traceReturn(THIS_CLASS, "retrieveSftpUserName()");
        return result2;
    }

    public void removeSftpUserName(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeSftpUserName()");
        this.sftpUserName = "";
        this.rbsConfiguration.removeAdditionalAttribute(SFTP_USERNAME, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSftpUserName("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeSftpUserName()");
    }

    public String retrieveSftpPassword() {
        logger.traceEnter(THIS_CLASS, "retrieveSftpPassword()");
        String result2 = this.sftpPassword == null || this.sftpPassword.equalsIgnoreCase("") ? this.retrieveSensitiveString(SFTP_PASSWORD) : this.sftpPassword;
        logger.traceReturn(THIS_CLASS, "retrieveSftpPassword()");
        return result2;
    }

    public void removeSftpPassword(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeSftpPassword()");
        this.sftpPassword = "";
        this.rbsConfiguration.removeAdditionalAttribute(SFTP_PASSWORD, coordinator);
        if (this.sensitiveDataStore != null) {
            this.sensitiveDataStore.setSftpPassword("");
            this.sensitiveDataStore.storeToDisc(this.filePath);
        }
        logger.traceReturn(THIS_CLASS, "removeSftpPassword()");
    }
}

