/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.iptransport.AccessControlListMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpForOamSettingHelperImpl
implements IpForOamSettingHelper {
    private static final Class THIS_CLASS = IpForOamSettingHelperImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final Object INSTANCE_MUTEX = new Object();
    private static IpForOamSettingHelper instance;
    private List trafficMos = new ArrayList();
    private List referencedMos = new ArrayList();
    private Map ldnsWithMoType = new HashMap();
    private Map ipForOamSettingData = new HashMap();
    private IpData ipData;

    private IpForOamSettingHelperImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpForOamSettingHelper getInstance() {
        logger.traceEnter(THIS_CLASS, "getInstance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new IpForOamSettingHelperImpl();
            }
        }
        logger.traceReturn(THIS_CLASS, "getInstance()");
        return instance;
    }

    public List getReferencedMos() {
        return this.referencedMos;
    }

    public List getTrafficMos() {
        return this.trafficMos;
    }

    public Map getMoTypeToLdnMap() {
        return this.ldnsWithMoType;
    }

    public Map getIpForOamSettingData() {
        return this.ipForOamSettingData;
    }

    public IpData getIpData() {
        return this.ipData;
    }

    public void setIpData(IpData inIpData) {
        this.ipData = inIpData;
    }

    public String getId(String moType) {
        String ldn = (String)this.getMoTypeToLdnMap().get(moType);
        return LdnHelper.getRdnAttributeValue((String)ldn);
    }

    public void addAccessControlListAndVlanRef(String ipInterfaceLdn) throws MoAccessException {
        ManagedObject vlanRef;
        logger.traceEnter(THIS_CLASS, "addAccessControlListAndVlanRef(" + ipInterfaceLdn + ")");
        IpOamConfigurationService ipOamService = IpOamConfigurationServiceImpl.getInstance();
        AccessControlListMo accessControlListRef = (AccessControlListMo)ipOamService.getAttribute(ipInterfaceLdn, "accessControlListRef");
        if (accessControlListRef != null) {
            this.getTrafficMos().add(accessControlListRef.getLocalDistinguishedName());
        }
        if ((vlanRef = (ManagedObject)ipOamService.getAttribute(ipInterfaceLdn, "vlanRef")) != null) {
            this.getTrafficMos().add(vlanRef.getLocalDistinguishedName());
        }
        logger.traceReturn(THIS_CLASS, "addAccessControlListAndVlanRef(" + ipInterfaceLdn + ")");
    }

    public void clearData() {
        this.trafficMos.clear();
        this.referencedMos.clear();
        this.ldnsWithMoType.clear();
        this.ipForOamSettingData.clear();
        this.ipData = null;
    }
}

