/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStackImpl;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.security.cppsec.esa.CertInfo;
import se.ericsson.security.cppsec.esa.EsaMessageHandler;
import se.ericsson.security.cppsec.esa.IpSecInstallation;
import se.ericsson.security.cppsec.esa.IpSecInstallationException;
import se.ericsson.security.cppsec.esa.IpSecInstallationFactory;
import se.ericsson.security.cppsec.esa.IpSecInstallationInputException;
import se.ericsson.security.cppsec.esa.IpSecReturnVal;

public class IpSecCertificateInstaller
implements EsaMessageHandler {
    private static final Class THIS_CLASS = IpSecCertificateInstaller.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static String localIscfFilePath;
    private static String rbsIntegrationCode;
    private static String smrsUserId;
    private static final String slogan = "IP Sec certificate install failed.";
    private final IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();

    public IpSecCertificateInstaller(String inLocalIscfFilePath, String inRbsIntegrationCode, String inSmrsUserId) {
        localIscfFilePath = inLocalIscfFilePath;
        rbsIntegrationCode = inRbsIntegrationCode;
        smrsUserId = inSmrsUserId;
    }

    public String installCertificate() throws RbsConfigurationFailedException {
        Object oldAttributeValue;
        IpSecReturnVal ipSecReturnVal;
        String logicalName;
        IpSecMo ipSecMo;
        RbsConfigurationMao rbsConfigurationMao;
        logger.traceEnter(THIS_CLASS, "installCertificate()");
        try {
            rbsConfigurationMao = (RbsConfigurationMao)this.ipOamConfigurationService.getMo("ManagedElement=1,NodeManagementFunction=1,RbsConfiguration=1");
        }
        catch (MoNotFoundException e) {
            throw new RbsConfigurationFailedException(slogan, "RbsConfigurationMao not found", (Exception)((Object)e));
        }
        try {
            ipSecMo = (IpSecMo)this.ipOamConfigurationService.getMo("ManagedElement=1,IpSystem=1,IpSec=1");
        }
        catch (MoNotFoundException e) {
            throw new RbsConfigurationFailedException(slogan, "Could not find the IpSec MO on the node.", (Exception)((Object)e));
        }
        try {
            logicalName = (String)this.ipOamConfigurationService.getAttribute("ManagedElement=1", "logicalName");
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException(slogan, "Could not find the logicalName on the node.", (Exception)((Object)e));
        }
        if (logicalName == null || logicalName.length() == 0) {
            throw new RbsConfigurationFailedException(slogan, "The attribute logicalName in the ManagedElement MO is not set on the node.");
        }
        logger.traceGeneral(THIS_CLASS, "Invoking install on IpSec");
        IpSecInstallation ipSecInstallation = IpSecInstallationFactory.createIpSecInstallation((EsaMessageHandler)this);
        try {
            ipSecReturnVal = ipSecInstallation.install(localIscfFilePath, rbsIntegrationCode, smrsUserId, logicalName, ipSecMo.getLocalDistinguishedName());
        }
        catch (IpSecInstallationException e) {
            throw new RbsConfigurationFailedException(slogan, "IpSecInstallationException thrown while installing IP Sec certificate.", (Exception)((Object)e));
        }
        catch (IpSecInstallationInputException e) {
            throw new RbsConfigurationFailedException(slogan, "IpSecInstallationInputException thrown while installing IP Sec certificate.", (Exception)((Object)e));
        }
        logger.traceGeneral(THIS_CLASS, "Invoking install on IpSec install returned: " + ipSecReturnVal);
        if (ipSecReturnVal == null) {
            throw new RbsConfigurationFailedException(slogan, "Installation of IP Sec certificate failed!");
        }
        Integer wantedIpSecLevel = new Integer(ipSecReturnVal.getWantedIPSecLevel());
        logger.traceDebug(THIS_CLASS, "wantedIpSecLevel: " + wantedIpSecLevel);
        CertInfo[] ipSecCusCertInfo = ipSecReturnVal.getIPSecCUSCertInfo();
        String ipSecFingerPrint = ipSecCusCertInfo[0].getCertificateFingerprint();
        String ipSecSerialNumber = ipSecCusCertInfo[0].getSerialNumber();
        logger.traceDebug(THIS_CLASS, "ipSecFingerPrint = " + ipSecFingerPrint);
        logger.traceDebug(THIS_CLASS, "ipSecSerialNumber = " + ipSecSerialNumber);
        try {
            rbsConfigurationMao.storePersistently("wantedIpSecLevel", wantedIpSecLevel);
            rbsConfigurationMao.storePersistently("IpSecFingerPrint", ipSecFingerPrint);
            rbsConfigurationMao.storePersistently("IpSecSerialNumber", ipSecSerialNumber);
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException(slogan, "Could not access the RbsConfiguration MO on the node.", (Exception)((Object)e));
        }
        String ipSecLdn = "ManagedElement=1,IpSystem=1,IpSec=1";
        String attributeName = "featureState";
        try {
            oldAttributeValue = this.ipOamConfigurationService.getAttribute(ipSecLdn, attributeName);
            this.ipOamConfigurationService.setAttribute(ipSecLdn, attributeName, RbsConfigurationDefinitions.ACTIVATED);
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException(slogan, "Could not get/set the attribute " + attributeName + " for the IpSec MO.", (Exception)((Object)e));
        }
        IpRollbackStack ipRollbackStack = IpRollbackStackImpl.getInstance();
        ipRollbackStack.pushSet(ipSecLdn, new String[]{attributeName}, new Object[]{oldAttributeValue});
        logger.traceReturn(THIS_CLASS, "installCertificate()");
        return ipSecFingerPrint;
    }

    public void reportProgress(String progressMessage) {
        logger.traceGeneral(THIS_CLASS, "ESA returned progress: " + StringHelper.doubleQuote((String)progressMessage));
    }
}

