/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStackImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages.StaticRouteReader;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionHandler;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class NewConfigurationCreator {
    private IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
    private IpForOamSettingHelper ipForOamSettingHelper = IpForOamSettingHelperImpl.getInstance();
    private IpRollbackStack ipRollbackStack = IpRollbackStackImpl.getInstance();
    private Map ipForOamSettingData = this.ipForOamSettingHelper.getIpForOamSettingData();
    private Map moTypeToLdnMap = this.ipForOamSettingHelper.getMoTypeToLdnMap();
    private final RbsConfigurationHelper helper;
    private final AbstractLogger logger = LoggingService.getLogger((String)this.getClass().getName());
    private final String slogan = "Creation of new configuration failed!";
    private static final Class THIS_CLASS = NewConfigurationCreator.class;

    public NewConfigurationCreator() throws RbsConfigurationFailedException {
        this.helper = this.ipOamConfigurationService.getRbsConfigurationHelper();
    }

    public void createNewConfiguration() throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "createNewConfiguration()");
        String ipSecMoType = "IpSec";
        if (this.ipOamConfigurationService.getAllMosOfType("IpSec").isEmpty() && this.moTypeToLdnMap.containsKey("IpSec")) {
            this.createMoWithRollback("IpSec");
        }
        String[] moTypesToCreate = new String[]{"AccessControlList", "IpInterface", "IpAccessHostEt", "VpnInterface", "IkePeer", "IpSecTunnel"};
        for (int i = 0; i < moTypesToCreate.length; ++i) {
            if (!this.moTypeToLdnMap.containsKey(moTypesToCreate[i])) continue;
            this.createMoWithRollback(moTypesToCreate[i]);
        }
        if (!this.moTypeToLdnMap.containsKey("IpHostLink")) {
            String errMessage = "IpHostLink MO data is missing in the xml file.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
            throw new RbsConfigurationFailedException("Creation of new configuration failed!", "There is no IpHostLink MO data in the xml file!");
        }
        ManagedObject ipHostLinkMo = this.createMoWithRollback("IpHostLink");
        String ipHostLinkLdn = ipHostLinkMo.getLocalDistinguishedName();
        this.setDnsServerAddresses();
        if (this.addingStaticRouteRequired()) {
            this.addRoutesInRoutingTable(ipHostLinkLdn);
        }
        this.changeNodeInterfaceName(ipHostLinkLdn);
        this.logger.traceReturn(THIS_CLASS, "createNewConfiguration()");
    }

    private void addRoutesInRoutingTable(String ipHostLinkLdn) throws RbsConfigurationFailedException {
        String nextHopIpAddress;
        block6: {
            try {
                ManagedObject ipInterfaceMoRef = (ManagedObject)this.ipOamConfigurationService.getAttribute(ipHostLinkLdn, "ipInterfaceMoRef");
                if (ipInterfaceMoRef instanceof VpnInterfaceMo) {
                    String[] ipv4Addresses = (String[])this.ipOamConfigurationService.getAttribute(ipHostLinkLdn, "ipv4Addresses");
                    if (ipv4Addresses.length == 0) {
                        throw new RbsConfigurationFailedException("Creation of new configuration failed!", "There are no configured IPv4 addresses on the IpHostLink MO.");
                    }
                    nextHopIpAddress = ipv4Addresses[0];
                    break block6;
                }
                if (ipInterfaceMoRef instanceof IpInterfaceMo) {
                    nextHopIpAddress = (String)this.ipOamConfigurationService.getAttribute(ipInterfaceMoRef.getLocalDistinguishedName(), "defaultRouter0");
                    break block6;
                }
                String errMessage = "New configuration contains an unsupported IP configuration";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_OAM_CONFIG_FILE_FAULT, "Creation of new configuration failed!", errMessage);
                throw new RbsConfigurationFailedException("Creation of new configuration failed!", "Unsupported configuration found!");
            }
            catch (MoAccessException e) {
                String errMessage = "MoAccessException thrown while creating the new configuration";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
                throw new RbsConfigurationFailedException("Creation of new configuration failed!", "MoAccessException thrown!", (Exception)((Object)e));
            }
        }
        StaticRouteReader staticRouteReader = new StaticRouteReader();
        TransactionHandler.run(staticRouteReader);
        if (staticRouteReader.getStaticRoute(nextHopIpAddress) == null) {
            this.ipOamConfigurationService.performActionAddStaticRoute("0.0.0.0", "0.0.0.0", nextHopIpAddress, new Integer(64), false);
            this.ipRollbackStack.pushAction("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1", "actionDeleteStaticRoute", new String[]{"ipAddress", "nextHopIpAddr"}, new String[]{"0.0.0.0", nextHopIpAddress});
        }
    }

    private void setDnsServerAddresses() throws RbsConfigurationFailedException {
        String[] dnsServerAddresses;
        this.logger.traceEnter(THIS_CLASS, "setDnsServerAddresses()");
        AttrList ipAttrList = (AttrList)this.ipForOamSettingData.get("ManagedElement=1,IpOam=1,Ip=1");
        if (ipAttrList == null) {
            String errMessage = "Attribute list could not be fetched from: ManagedElement=1,IpOam=1,Ip=1 MO.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
            throw new RbsConfigurationFailedException(THIS_CLASS.getName(), "Creation of new configuration failed!\nNo IP data was found!");
        }
        String dnsServerAddress1 = null;
        String dnsServerAddress2 = null;
        String dnsServerAddress3 = null;
        try {
            if (ipAttrList.contains(new String[]{"dnsServer1"})) {
                dnsServerAddress1 = (String)ipAttrList.getValue(ipAttrList.indexOf("dnsServer1"));
            }
            if (ipAttrList.contains(new String[]{"dnsServer2"})) {
                dnsServerAddress2 = (String)ipAttrList.getValue(ipAttrList.indexOf("dnsServer2"));
            }
            if (ipAttrList.contains(new String[]{"dnsServer3"})) {
                dnsServerAddress3 = (String)ipAttrList.getValue(ipAttrList.indexOf("dnsServer3"));
            }
        }
        catch (MoAccessException e) {
            String errMessage = "Exception thrown while retrieving DNS server addresses from configuration data for the Ip MO.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
            throw new RbsConfigurationFailedException("Creation of new configuration failed!", "Can not retrieve DNS server addresses", (Exception)((Object)e));
        }
        ArrayList<String> dnsServers = new ArrayList<String>();
        if (dnsServerAddress1 != null && dnsServerAddress1.length() != 0) {
            dnsServers.add(dnsServerAddress1);
        }
        if (dnsServerAddress2 != null && dnsServerAddress2.length() != 0) {
            dnsServers.add(dnsServerAddress2);
        }
        if (dnsServerAddress3 != null && dnsServerAddress3.length() != 0) {
            dnsServers.add(dnsServerAddress3);
        }
        if ((dnsServerAddresses = dnsServers.toArray(new String[0])).length > 0) {
            try {
                this.ipOamConfigurationService.setAttribute("ManagedElement=1,IpOam=1,Ip=1", "dnsServerAddresses", dnsServerAddresses);
            }
            catch (MoNotFoundException e) {
                String errMessage = "MO ManagedElement=1,IpOam=1,Ip=1 Not found";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
                throw new RbsConfigurationFailedException("Creation of new configuration failed!", "Could not find the Ip MO.", (Exception)((Object)e));
            }
            catch (NoSuchAttributeException e) {
                String errMessage = "Attribute dnsServerAddressescould not be fetched from ManagedElement=1,IpOam=1,Ip=1";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
                throw new RbsConfigurationFailedException("Creation of new configuration failed!", "Could not find the attribute dnsServerAddresses", (Exception)((Object)e));
            }
            catch (MoAccessException e) {
                String errMessage = "MO ManagedElement=1,IpOam=1,Ip=1 not accessible.";
                this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
                throw new RbsConfigurationFailedException("Creation of new configuration failed!", "Could not access the Ip MO", (Exception)((Object)e));
            }
        }
        this.logger.traceReturn(THIS_CLASS, "setDnsServerAddresses()");
    }

    private void changeNodeInterfaceName(String ipHostLinkLdn) throws RbsConfigurationFailedException {
        try {
            String newNodeInterfaceName = (String)this.ipOamConfigurationService.getAttribute(ipHostLinkLdn, "interfaceName");
            this.ipOamConfigurationService.changeNodeInterfaceNameWithRollback(newNodeInterfaceName);
        }
        catch (MoAccessException e) {
            String errMessage = "Changing node interface name failed.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
            throw new RbsConfigurationFailedException("Creation of new configuration failed!", "Change of nodeInterfaceName failed", (Exception)((Object)e));
        }
    }

    private ManagedObject createMoWithRollback(String moType) throws RbsConfigurationFailedException {
        this.logger.traceEnter(THIS_CLASS, "createMoWithRollback(" + moType + ")");
        String errMessage = "";
        String ldn = (String)this.moTypeToLdnMap.get(moType);
        AttrList attrList = (AttrList)this.ipForOamSettingData.get(ldn);
        try {
            this.ipOamConfigurationService.convertBackMoReferencesInAttrList(attrList);
        }
        catch (MoNotFoundException e) {
            errMessage = "Creation of new MO " + ldn + " failed.";
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "Creation of new configuration failed!", errMessage);
            throw new RbsConfigurationFailedException("Creation of new configuration failed!", errMessage, (Exception)((Object)e));
        }
        ManagedObject createdMo = this.ipOamConfigurationService.createMo(ldn, attrList);
        this.ipRollbackStack.pushDelete(createdMo.getLocalDistinguishedName());
        this.logger.traceReturn(THIS_CLASS, "createMoWithRollback(" + moType + ")");
        return createdMo;
    }

    private boolean addingStaticRouteRequired() {
        this.logger.traceEnter(THIS_CLASS, "addingStaticRouteRequired()");
        boolean result2 = false;
        result2 = !this.moTypeToLdnMap.containsKey("VpnInterface");
        this.logger.traceReturn(THIS_CLASS, "addingStaticRouteRequired( ) " + result2);
        return result2;
    }
}

