/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class AccessControlListDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public AccessControlListDataConsistencyChecker() {
        THIS_CLASS = AccessControlListDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "checkConsistency()");
        if (this.accessControlListDataLdn == null) {
            logger.info(THIS_CLASS, "No AccessControlList data found in the XML-file. Skipping consistency check for this MO.");
            logger.traceReturn(THIS_CLASS, "checkConsistency()");
            return;
        }
        String accessControlListLdn = this.ipOamService.findTrafficMoWithMoType("AccessControlList");
        if (accessControlListLdn != null) {
            String accessControlListIdOnNode;
            try {
                accessControlListIdOnNode = (String)this.ipOamService.getAttribute(accessControlListLdn, "AccessControlListId");
            }
            catch (MoAccessException e) {
                this.faultMsg = "Could not access the MO " + accessControlListLdn + ".";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
            }
            if (accessControlListIdOnNode.equals(this.ipOamHelper.getId("AccessControlList"))) {
                this.faultMsg = "The AccessControlList MO has the same ID as another AccessControlList MO.";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
        }
        logger.info(THIS_CLASS, "checkConsistency() passed");
        logger.traceReturn(THIS_CLASS, "checkConsistency()");
    }
}

