/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import java.util.List;
import java.util.Map;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpForOamSettingHelperImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;

public abstract class ConsistencyChecker {
    protected IpForOamSettingHelper ipOamHelper = IpForOamSettingHelperImpl.getInstance();
    protected IpOamConfigurationService ipOamService = IpOamConfigurationServiceImpl.getInstance();
    protected Map moTypeToLdnMap = IpForOamSettingHelperImpl.getInstance().getMoTypeToLdnMap();
    protected String slogan = "Consistency check fails.";
    protected List referencedMos = this.ipOamHelper.getReferencedMos();
    protected String ipAccessHostEtDataLdn = (String)this.moTypeToLdnMap.get("IpAccessHostEt");
    protected String ipInterfaceDataLdn = (String)this.moTypeToLdnMap.get("IpInterface");
    protected String ipHostLinkDataLdn = (String)this.moTypeToLdnMap.get("IpHostLink");
    protected String ikePeerDataLdn = (String)this.moTypeToLdnMap.get("IkePeer");
    protected String vpnInterfaceDataLdn = (String)this.moTypeToLdnMap.get("VpnInterface");
    protected String ipSecTunnelDataLdn = (String)this.moTypeToLdnMap.get("IpSecTunnel");
    protected String accessControlListDataLdn = (String)this.moTypeToLdnMap.get("AccessControlList");

    public abstract void checkConsistency() throws RbsConfigurationFailedException;

    protected boolean isMoIdUnique(String ldnOnNode, String idAttrName, String moType) throws RbsConfigurationFailedException {
        String idOnNode;
        try {
            idOnNode = (String)this.ipOamService.getAttribute(ldnOnNode, idAttrName);
        }
        catch (MoAccessException e) {
            String faultMsg = "Could not access the MO " + ldnOnNode + ".";
            throw new RbsConfigurationFailedException(this.slogan, faultMsg, (Exception)((Object)e));
        }
        return !idOnNode.equals(this.ipOamHelper.getId(moType));
    }

    protected String getIpAccessHostEtsIpInterfaceMoRef(String ipAccessHostEtLdn) throws RbsConfigurationFailedException {
        ManagedObject ipInterfaceMo;
        try {
            ipInterfaceMo = (ManagedObject)this.ipOamService.getAttribute(ipAccessHostEtLdn, "ipInterfaceMoRef");
        }
        catch (MoAccessException e) {
            String faultMsg = "Could not fetch ipInterfaceMoRef attribute of MO " + ipAccessHostEtLdn;
            throw new RbsConfigurationFailedException(this.slogan, faultMsg, (Exception)((Object)e));
        }
        if (ipInterfaceMo == null) {
            String faultMsg = "The attribute ipInterfaceMoRef is null for MO " + ipAccessHostEtLdn;
            throw new RbsConfigurationFailedException(this.slogan, faultMsg);
        }
        return ipInterfaceMo.getLocalDistinguishedName();
    }

    protected StringReplacingManagedObject getOamOuterIpAccessHostEt(String vpnInterfaceLdn) throws RbsConfigurationFailedException {
        StringReplacingManagedObject oamIpAccessHostEtLdn = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(vpnInterfaceLdn, "ipAccessHostEtRef");
        return oamIpAccessHostEtLdn;
    }
}

