/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpInterfaceDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public IpInterfaceDataConsistencyChecker() {
        THIS_CLASS = IpInterfaceDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        StringReplacingManagedObject accessControlListRef;
        logger.traceEnter(THIS_CLASS, "checkConsistency()");
        if (this.ipInterfaceDataLdn == null) {
            logger.info(THIS_CLASS, "No IpInterface data found in the XML-file. Consistency Check will be skipped for this MO.");
            logger.traceReturn(THIS_CLASS, "checkConsistency()");
            return;
        }
        String ipInterfaceLdn = this.ipOamService.findTrafficMoWithMoType("IpInterface");
        if (ipInterfaceLdn != null) {
            Integer vidOnNode;
            if (!this.isMoIdUnique(ipInterfaceLdn, "IpInterfaceId", "IpInterface")) {
                this.faultMsg = "The IpInterface MO has the same ID as another IpInterface MO.";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
            try {
                vidOnNode = (Integer)this.ipOamService.getAttribute(ipInterfaceLdn, "vid");
            }
            catch (MoAccessException e) {
                this.faultMsg = "Could not access the MO " + ipInterfaceLdn + ".";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
            }
            if (vidOnNode.equals((Integer)this.ipOamService.getAttributeFromConfigurationData(this.ipInterfaceDataLdn, "vid"))) {
                this.faultMsg = "The IpInterface MO has the same VID as another IpInterface MO (for CP/UP).";
                throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
            }
        }
        if ((accessControlListRef = (StringReplacingManagedObject)this.ipOamService.getAttributeFromConfigurationData(this.ipInterfaceDataLdn, "accessControlListRef")) != null && accessControlListRef.getLdn() != null) {
            if (this.accessControlListDataLdn != null) {
                if (!accessControlListRef.getLdn().equals(this.accessControlListDataLdn)) {
                    this.faultMsg = "The attribute accessControlListRef in MO " + this.ipInterfaceDataLdn + " is inconsistent! Does not reference the AccessControlList MO in the XML-file.";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg);
                }
            } else {
                try {
                    ManagedObject accessControlListMo = this.ipOamService.getMo(accessControlListRef.getLdn());
                    this.referencedMos.add(accessControlListMo.getLocalDistinguishedName());
                    logger.traceDebug(THIS_CLASS, "The IpInterface MO references the existing AccessControlList MO " + accessControlListRef.getLdn());
                }
                catch (MoNotFoundException e) {
                    this.faultMsg = "The referenced MO " + accessControlListRef.getLdn() + " was not found!";
                    throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
                }
            }
        } else {
            logger.info(THIS_CLASS, "The attribute accessControlListRef in " + this.ipInterfaceDataLdn + " is empty so the consistency check for this attribute will be skipped!");
        }
        logger.info(THIS_CLASS, "checkConsistency() passed");
        logger.traceReturn(THIS_CLASS, "checkConsistency()");
    }
}

