/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.consistencycheckers.ConsistencyChecker;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpSecDataConsistencyChecker
extends ConsistencyChecker {
    private static Class THIS_CLASS;
    private static AbstractLogger logger;
    private String faultMsg;

    public IpSecDataConsistencyChecker() {
        THIS_CLASS = IpSecDataConsistencyChecker.class;
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    public void checkConsistency() throws RbsConfigurationFailedException {
        int featureState;
        logger.traceEnter(THIS_CLASS, "checkConsistency()");
        AttrList attrList = (AttrList)this.ipOamHelper.getIpForOamSettingData().get("ManagedElement=1,IpSystem=1,IpSec=1");
        if (attrList == null) {
            logger.info(THIS_CLASS, "No IpSec data found in the XML-file. Skipping consistency check for this MO.");
            logger.traceReturn(THIS_CLASS, "checkConsistency()");
            return;
        }
        int index = attrList.indexOf("featureState");
        if (index == -1) {
            logger.traceDebug(THIS_CLASS, "There is no feature state information for the IpSec MO in the XML file. Skipping consistency check for this MO.");
            logger.traceReturn(THIS_CLASS, "checkConsistency()");
            return;
        }
        try {
            featureState = (Integer)attrList.getValue(index);
        }
        catch (NotHandledAttributeTypeException e) {
            this.faultMsg = "Could not fetch the attribute featureState in the IpSec=1 MO.";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
        catch (MoNotFoundException e) {
            this.faultMsg = "Could not find the IpSec MO.";
            throw new RbsConfigurationFailedException(this.slogan, this.faultMsg, (Exception)((Object)e));
        }
        if (featureState == 0) {
            logger.traceDebug(THIS_CLASS, "IpSec feature is to be deactivated. Verifying that this is consistent with the wanted configuration.");
            if (this.vpnInterfaceDataLdn != null) {
                throw new RbsConfigurationFailedException(this.slogan, "IpSec feature state is not consistent with the wanted configuration.");
            }
            if (this.ipOamService.findTrafficMoWithMoType("VpnInterface") != null) {
                throw new RbsConfigurationFailedException(this.slogan, "IpSec feature state is not consistent with the current CP/UP IP configuration.");
            }
        }
        logger.traceReturn(THIS_CLASS, "checkConsistency()");
    }
}

