/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import java.util.ArrayList;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = IpParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final IpData ipData;

    public IpParameterConverter(IpData inIpData) {
        this.ipData = inIpData;
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convert()");
        logger.traceDebug(THIS_CLASS, "convert(),\nipData.dnsServer1=" + this.ipData.getDnsServer1() + "\nipData.dnsServer2=" + this.ipData.getDnsServer2() + "\nipData.dnsServer3=" + this.ipData.getDnsServer3() + "\nipData.dscp=" + this.ipData.getDscp() + "\nipData.oaMAlternativeAccess=" + this.ipData.getOaMAlternativeAccess() + "\nipData.oaMAlternativeAccessSourceData=" + this.ipData.getOaMAlternativeAccessSourceData());
        AttrListImpl attrList = new AttrListImpl();
        this.addElementCheckNull("dnsServer1", this.ipData.getDnsServer1(), attrList);
        this.addElementCheckNull("dnsServer2", this.ipData.getDnsServer2(), attrList);
        this.addElementCheckNull("dnsServer3", this.ipData.getDnsServer3(), attrList);
        ArrayList<String> dnsServers = new ArrayList<String>();
        if (this.ipData.getDnsServer1() != null && this.ipData.getDnsServer1().length() != 0) {
            dnsServers.add(this.ipData.getDnsServer1());
        }
        if (this.ipData.getDnsServer2() != null && this.ipData.getDnsServer2().length() != 0) {
            dnsServers.add(this.ipData.getDnsServer2());
        }
        if (this.ipData.getDnsServer3() != null && this.ipData.getDnsServer3().length() != 0) {
            dnsServers.add(this.ipData.getDnsServer3());
        }
        String[] dnsArray = dnsServers.toArray(new String[dnsServers.size()]);
        this.addElementCheckNull("dnsServerAddresses", dnsArray, attrList);
        this.addElementCheckNull("dscp", this.ipData.getDscp(), attrList);
        this.addElementCheckNull("oaMAlternativeAccess", this.ipData.getOaMAlternativeAccess(), attrList);
        this.addElementCheckNull("oaMAlternativeAccessSource", this.ipData.getOaMAlternativeAccessSourceData(), attrList);
        logger.traceReturn(THIS_CLASS, "convert()");
        return attrList;
    }

    public String getLdn() {
        String currentLdn = "ManagedElement=1,IpOam=1,Ip=1";
        return currentLdn;
    }

    public String getMoType() {
        return "Ip";
    }
}

