/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import java.util.List;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public abstract class MoParameterConverterBase {
    private static final Class THIS_CLASS = MoParameterConverterBase.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String DU_1 = "du-1";
    protected static final String DU_2 = "du-2";
    protected static final String VPN = "vpn";
    protected static final String IPV6 = "ipv6";
    protected ManagedObject gigabitEthernet;
    protected String gigabitEthernetLdn;
    protected ManagedObject ipSec;
    protected String ipSecLdn;
    protected IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();

    public abstract AttrList convert() throws RbsConfigurationFailedException;

    public abstract String getLdn() throws RbsConfigurationFailedException;

    public abstract String getMoType();

    protected void addElementCheckNull(String valueString, Object valueObject, AttrListImpl attrList) {
        if (valueObject != null) {
            attrList.addElement(valueString, valueObject);
        }
    }

    public String attrListToString(AttrList attr) throws NotHandledAttributeTypeException, MoNotFoundException {
        String str = "\n";
        Object aValue = null;
        String aName = null;
        for (int i = 0; i < attr.size(); ++i) {
            aName = attr.getName(i);
            aValue = attr.getValue(i);
            aValue = aValue instanceof Struct ? this.printStructAsString((Struct)aValue) : aValue.toString();
            str = str + "Attribute: " + aName + '=' + aValue + '\n';
        }
        return str;
    }

    public Object getValue(String name, AttrList attr) throws NotHandledAttributeTypeException, MoNotFoundException {
        Object value = null;
        for (int i = 0; i < attr.size(); ++i) {
            if (!attr.getName(i).equals(name)) continue;
            value = attr.getValue(i);
            break;
        }
        return value;
    }

    public String printStructAsString(Struct entry) throws NotHandledAttributeTypeException, MoNotFoundException {
        StringBuffer logEntry = new StringBuffer(32);
        String[] attributes = entry.getNames();
        String aName = null;
        Object aValue = null;
        for (int index = 0; index < attributes.length; ++index) {
            aName = attributes[index];
            try {
                aValue = entry.getValue(aName);
                aValue = aValue != null ? aValue.toString() : "null";
            }
            catch (NoSuchFieldException e) {
                aValue = "NoSuchValueInStruct";
            }
            logEntry.append(aName);
            logEntry.append("=");
            logEntry.append(aValue);
            logEntry.append("  ");
        }
        return logEntry.toString();
    }

    protected String correctIpInterfaceMoRef(String originalLdn) throws RbsConfigurationFailedException {
        if (originalLdn.indexOf("IpInterface") > -1) {
            return this.getGigabitEthernetLdn() + "," + LdnHelper.getRdnElement((String)originalLdn);
        }
        return originalLdn;
    }

    public ManagedObject getGigabitEthernetMo() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getGigabitEthernetMo()");
        if (this.gigabitEthernet == null) {
            this.gigabitEthernet = this.getUniqueMo("GigaBitEthernet");
            this.gigabitEthernetLdn = this.gigabitEthernet.getLocalDistinguishedName();
        }
        logger.traceReturn(THIS_CLASS, "getGigabitEthernetMo()");
        return this.gigabitEthernet;
    }

    public String getGigabitEthernetLdn() throws RbsConfigurationFailedException {
        this.getGigabitEthernetMo();
        return this.gigabitEthernetLdn;
    }

    private ManagedObject getUniqueMo(String moType) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "getUniqueMo(" + moType + ")");
        List foundMos = this.ipOamConfigurationService.getAllMosOfType(moType);
        if (foundMos.isEmpty()) {
            throw new RbsConfigurationFailedException("MO not found", "Could not find the " + moType + " MO");
        }
        if (foundMos.size() > 1) {
            throw new RbsConfigurationFailedException("Too many MOs found", "Found " + foundMos.size() + " " + moType + " MOs. Only one is allowed.");
        }
        logger.traceReturn(THIS_CLASS, "getUniqueMo(" + moType + ")");
        return (ManagedObject)foundMos.get(0);
    }
}

