/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.parameterconverters.MoParameterConverterBase;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.VpnInterfaceData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class VpnInterfaceParameterConverter
extends MoParameterConverterBase {
    private static final Class THIS_CLASS = VpnInterfaceParameterConverter.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final VpnInterfaceData vpnInterfaceData;

    public VpnInterfaceParameterConverter(VpnInterfaceData inVpnInterfaceData) {
        this.vpnInterfaceData = inVpnInterfaceData;
    }

    public AttrList convert() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "convert()");
        AttrListImpl attrList = new AttrListImpl();
        this.addElementCheckNull("networkPrefixLength", this.vpnInterfaceData.getNetworkPrefixLength(), attrList);
        this.addElementCheckNull("userLabel", this.vpnInterfaceData.getUserLabel(), attrList);
        this.addElementCheckNull("subnet", this.vpnInterfaceData.getSubnet(), attrList);
        StringReplacingManagedObject ldnManagedObject = new StringReplacingManagedObject(this.vpnInterfaceData.getIpAccessHostEtRefLdn());
        attrList.addElement("ipAccessHostEtRef", (Object)ldnManagedObject);
        logger.traceReturn(THIS_CLASS, "convert()");
        return attrList;
    }

    public String getLdn() {
        String parentLdn = "ManagedElement=1,IpSystem=1";
        String currentRdn = this.getMoType() + "=" + this.vpnInterfaceData.getVpnInterfaceId();
        String currentLdn = parentLdn + "," + currentRdn;
        return currentLdn;
    }

    public String getMoType() {
        return "VpnInterface";
    }
}

