/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.AbstractIpRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class CreateIpRollbackStackItem
extends AbstractIpRollbackStackItem {
    private static final Class THIS_CLASS = CreateIpRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final AttrList attributeList;

    public CreateIpRollbackStackItem(String ldn, AttrList inAttributeList) {
        super(ldn);
        this.attributeList = inAttributeList;
    }

    public boolean doRollback() {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        String ldn = this.getLdn();
        try {
            this.getConfigurationService().convertBackMoReferencesInAttrList(this.attributeList);
        }
        catch (MoNotFoundException e) {
            this.logErrorMessage(ldn, e.getLocalizedMessage());
            return false;
        }
        try {
            this.getConfigurationService().createMo(ldn, this.attributeList);
        }
        catch (RbsConfigurationFailedException e) {
            this.logErrorMessage(ldn, e.getLocalizedMessage());
            return false;
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
        return true;
    }

    private void logErrorMessage(String ldn, String reason) {
        String errorMsg = "Could not create MO " + ldn + " in rollback. " + reason;
        logger.traceAbnormal(THIS_CLASS, errorMsg);
    }

    public String toString() {
        return "Create of MO " + this.getLdn() + " with attributes:\n" + CreateIpRollbackStackItem.getAttributesAsString(this.attributeList);
    }
}

