/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.AbstractIpRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.DeleteRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class DeleteIpRollbackStackItem
extends AbstractIpRollbackStackItem {
    private static final Class THIS_CLASS = DeleteRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public DeleteIpRollbackStackItem(String inLdn) {
        super(inLdn);
    }

    public boolean doRollback() {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        IpOamConfigurationService ipOamConfigurationService = this.getConfigurationService();
        String ldn = this.getLdn();
        try {
            if (ldn.indexOf("IpAccessHostEt") > -1) {
                ipOamConfigurationService.lockMo(ldn);
            }
            ipOamConfigurationService.deleteMo(this.getLdn());
        }
        catch (MoAccessException e) {
            this.logErrorMessage(this.getLdn(), e.getLocalizedMessage());
            return false;
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
        return true;
    }

    private void logErrorMessage(String ldn, String reason) {
        String errorMsg = "Could not delete MO " + ldn + " in rollback. " + reason;
        logger.traceAbnormal(THIS_CLASS, errorMsg);
    }

    public String toString() {
        return "Delete of MO " + this.getLdn();
    }
}

