/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback;

import java.util.LinkedList;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.AbstractIpRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.ActionIpRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.CreateIpRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.DeleteIpRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.IpRollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.SetIpRollbackStackItem;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IpRollbackStackImpl
implements IpRollbackStack {
    private static final Class THIS_CLASS = IpRollbackStackImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final LinkedList theRollbackStack;
    private static IpRollbackStackImpl instance;

    private IpRollbackStackImpl() {
        logger.traceEnter(THIS_CLASS, "IpRollbackStackImpl()");
        this.theRollbackStack = new LinkedList();
        logger.traceReturn(THIS_CLASS, "IpRollbackStackImpl()");
    }

    public static IpRollbackStack getInstance() {
        if (instance == null) {
            instance = new IpRollbackStackImpl();
        }
        return instance;
    }

    public void pushCreate(String ldn, AttrList attributeList) {
        this.theRollbackStack.add(new CreateIpRollbackStackItem(ldn, attributeList));
    }

    public void pushSet(String ldn, String[] attributeNames, Object[] attributeValues) {
        this.theRollbackStack.add(new SetIpRollbackStackItem(ldn, attributeNames, attributeValues));
    }

    public void pushAction(String ldn, String actionName, String[] attributeNames, Object[] attributeValues) {
        this.theRollbackStack.add(new ActionIpRollbackStackItem(ldn, actionName, attributeNames, attributeValues));
    }

    public void pushDelete(String ldn) {
        this.theRollbackStack.add(new DeleteIpRollbackStackItem(ldn));
    }

    public void doRollback() {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        if (!this.isEmpty()) {
            while (!this.isEmpty()) {
                AbstractIpRollbackStackItem item = this.popNextRollbackItem();
                boolean rollbackSuccess = item.doRollback();
                if (rollbackSuccess) continue;
                logger.traceError(THIS_CLASS, "Rollback failed for " + item.toString());
            }
        } else {
            logger.traceDebug(THIS_CLASS, "The rollback stack is empty and the rollback could not be performed.");
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
    }

    public AbstractIpRollbackStackItem popNextRollbackItem() {
        if (this.isEmpty()) {
            return null;
        }
        return (AbstractIpRollbackStackItem)this.theRollbackStack.removeLast();
    }

    public void clearStack() {
        this.theRollbackStack.clear();
    }

    public boolean isEmpty() {
        return this.theRollbackStack.isEmpty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("The IpRollbackStack contains elements:\n");
        for (int i = 0; i < this.theRollbackStack.size(); ++i) {
            AbstractIpRollbackStackItem item = (AbstractIpRollbackStackItem)this.theRollbackStack.get(i);
            sb.append(item.toString() + "\n");
        }
        return sb.toString();
    }
}

