/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.AbstractIpRollbackStackItem;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.rollback.StringReplacingManagedObject;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class SetIpRollbackStackItem
extends AbstractIpRollbackStackItem {
    private static final Class THIS_CLASS = SetIpRollbackStackItem.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] attributeNames;
    private final Object[] attributeValues;

    public SetIpRollbackStackItem(String inLdn, String[] inAttributeNames, Object[] inAttributeValues) {
        super(inLdn);
        this.attributeNames = inAttributeNames;
        this.attributeValues = inAttributeValues;
    }

    public boolean doRollback() {
        logger.traceEnter(THIS_CLASS, "doRollback()");
        String ldn = this.getLdn();
        if (this.attributeNames.length == this.attributeValues.length) {
            for (int i = 0; i < this.attributeNames.length; ++i) {
                String attributeName = this.attributeNames[i];
                Object attributeValue = this.attributeValues[i];
                if (attributeValue instanceof StringReplacingManagedObject) {
                    try {
                        attributeValue = this.getConfigurationService().convertBackMoReference((StringReplacingManagedObject)attributeValue);
                    }
                    catch (MoNotFoundException e) {
                        this.logErrorMessage(ldn, e.getLocalizedMessage());
                        return false;
                    }
                }
                try {
                    this.getConfigurationService().setAttribute(ldn, attributeName, attributeValue);
                    continue;
                }
                catch (MoNotFoundException e) {
                    this.logErrorMessage(ldn, "Cannot find MO " + ldn + ".");
                    return false;
                }
                catch (NoSuchAttributeException e) {
                    this.logErrorMessage(ldn, "The attribute " + attributeName + " cannot be found for MO " + ldn + ".");
                    return false;
                }
                catch (MoAccessException e) {
                    this.logErrorMessage(ldn, "Cannot access MO " + ldn + ".");
                    return false;
                }
            }
        } else {
            this.logErrorMessage(ldn, "attributeNames and attributeValues are not of equal length.");
            return false;
        }
        logger.traceReturn(THIS_CLASS, "doRollback()");
        return true;
    }

    private void logErrorMessage(String ldn, String reason) {
        String errorMsg = "Could not set attributes on MO " + ldn + " in rollback. " + reason;
        logger.traceAbnormal(THIS_CLASS, errorMsg);
    }

    public String toString() {
        return "Set on MO " + this.getLdn() + " of attributes:\n" + SetIpRollbackStackItem.getAttributesAsString(this.attributeNames, this.attributeValues);
    }
}

