/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;

public class MoCreator
implements TransactionPackage {
    private final String ldn;
    private final AttrList attrList;
    private final MoFactoryMgrWrapper moFactoryMgrWrapper;
    private final IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
    private static final Class THIS_CLASS = MoCreator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public MoCreator(MoFactoryMgrWrapper inMoFactoryMgrWrapper, String inLdn, AttrList inAttrList) {
        this.ldn = inLdn;
        this.attrList = inAttrList;
        this.moFactoryMgrWrapper = inMoFactoryMgrWrapper;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        String parentLdn = this.getParentLdn(this.ldn);
        ManagedObject parentMo = this.ipOamConfigurationService.getMo(parentLdn);
        MoFactory moFactory = this.moFactoryMgrWrapper.lookup(this.ipOamConfigurationService.getMoTypeFromLdn(this.ldn));
        moFactory.createMo(parentMo, this.attrList, LdnHelper.getRdnAttributeValue((String)this.ldn), null, coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed!", "Could not create the MO " + this.ldn, exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed!", "Could not create the MO " + this.ldn, exception);
    }

    private String getParentLdn(String childLdn) {
        String extractedLdn = childLdn.substring(0, childLdn.lastIndexOf(","));
        return extractedLdn;
    }
}

