/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.transactionpackages;

import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationService;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ipforoamsetting.IpOamConfigurationServiceImpl;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.StaticRoutesData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class StaticRouteReader
implements TransactionPackage {
    private static final Class THIS_CLASS = StaticRouteReader.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String STATIC_ROUTE_READER_FAULT = "Fault in StaticRouteReader";
    private StaticRoutesData[] staticRoutesData;

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        IpOamConfigurationService ipOamConfigurationService = IpOamConfigurationServiceImpl.getInstance();
        IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)ipOamConfigurationService.getMo("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
        Struct[] staticRoutes = ipRoutingTableMo.getStaticRoutes(coordinator);
        Struct aStaticRoute = null;
        int n = staticRoutes.length;
        this.staticRoutesData = new StaticRoutesData[n];
        for (int i = 0; i < n; ++i) {
            aStaticRoute = staticRoutes[i];
            this.staticRoutesData[i] = this.makeStaticRoutesData(aStaticRoute);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private StaticRoutesData makeStaticRoutesData(Struct staticRoute) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "makeStaticRoutesData()");
        StaticRoutesData aStaticRoutesData = null;
        try {
            String indexOfStaticRoute = staticRoute.getValue("indexOfStaticRoute").toString();
            String ipAddress = (String)staticRoute.getValue("ipAddress");
            String networkMask = (String)staticRoute.getValue("networkMask");
            String nextHopIpAddr = (String)staticRoute.getValue("nextHopIpAddr");
            String redistribute = staticRoute.getValue("redistribute").toString();
            String routeMetric = staticRoute.getValue("routeMetric").toString();
            aStaticRoutesData = new StaticRoutesData(indexOfStaticRoute, ipAddress, networkMask, nextHopIpAddr, redistribute, routeMetric);
        }
        catch (Exception e) {
            String reason = "Incorrect values in the retrieved data, unable to convert attributes to StaticRouteData";
            throw new RbsConfigurationFailedException(STATIC_ROUTE_READER_FAULT, reason, e);
        }
        logger.traceReturn(THIS_CLASS, "makeStaticRoutesData()");
        return aStaticRoutesData;
    }

    public void handleExecutionException(Exception e) throws RbsConfigurationFailedException {
        String reason = "ExecutionException. Unable to read static routes of the MO: ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1";
        logger.traceError(THIS_CLASS, reason);
        throw new RbsConfigurationFailedException(STATIC_ROUTE_READER_FAULT, reason, e);
    }

    public void handleTransactionException(Exception e) throws RbsConfigurationFailedException {
        String reason = "TransactionException. Unable to read static routes of the MO: ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1";
        logger.traceError(THIS_CLASS, reason);
        throw new RbsConfigurationFailedException(STATIC_ROUTE_READER_FAULT, reason, e);
    }

    public StaticRoutesData[] getStaticRoutesData() {
        return this.staticRoutesData;
    }

    public StaticRoutesData getStaticRoute(String inHopIpAddress) {
        for (int i = 0; i < this.staticRoutesData.length; ++i) {
            if (!this.staticRoutesData[i].getNextHopIpAddr().equals(inHopIpAddress)) continue;
            return this.staticRoutesData[i];
        }
        return null;
    }
}

