/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.isi;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.isi.RbsConfigurationIsiHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IsiHandler {
    private static final Class THIS_CLASS = IsiHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private RbsConfigurationIsiHelper isiHelper;
    private final RbsConfigurationMao rbsConfiguration;
    private final RbsConfigurationContext rbsConfigurationContext;
    private String rootDirectoryPrefix = "";

    public IsiHandler(RbsConfigurationMao inRbsConfiguration) {
        this.rbsConfiguration = inRbsConfiguration;
        this.rbsConfigurationContext = this.rbsConfiguration.getRbsConfigurationContext();
    }

    public void execute() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "execute()");
        String diskParentPath = "";
        String cvName = "";
        this.setFirstRollbackCv("basic_cv");
        diskParentPath = this.installIntegrationBasicPackage();
        try {
            if (RbsConfigurationHelper.existsAndNotEmpty(FileParameters.instance(this.rbsConfiguration).getOamAccessFilePath()) || RbsConfigurationHelper.existsAndNotEmpty(FileParameters.instance(this.rbsConfiguration).getSiteBasicFilePath())) {
                cvName = this.setStartableCv(diskParentPath);
                this.generateNlhFile(cvName);
            }
        }
        catch (IOException e) {
            String msg = "Fail to set Startable CV: ";
            throw new RbsConfigurationFailedException(msg + e.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    protected void setFirstRollbackCv(String cvName) {
        logger.traceEnter(THIS_CLASS, "setFirstRollbackCv() : " + cvName);
        FileHelper.writeToFile((String)(this.rootDirectoryPrefix + RbsConfigurationDefinitions.CV_ROLLBACK_LIST), (String)cvName, (boolean)false);
        logger.traceReturn(THIS_CLASS, "setFirstRollbackCv() : " + cvName);
    }

    protected String setStartableCv(String parentPathIn) throws IOException {
        logger.traceEnter(THIS_CLASS, "setStartableCv()");
        String cvName = "";
        logger.traceDebug(THIS_CLASS, "Integration BP disks are located in: " + parentPathIn);
        File currentSource = new File(parentPathIn + File.separator + RbsConfigurationDefinitions.CV_POINTER);
        logger.traceDebug(THIS_CLASS, currentSource.getPath());
        File currentDestination = new File(this.rootDirectoryPrefix + RbsConfigurationDefinitions.CV_POINTER);
        logger.traceDebug(THIS_CLASS, currentDestination.getPath());
        if (!currentDestination.canWrite() && !currentDestination.delete()) {
            String errMsg = "Permission denied: " + currentDestination.getPath();
            throw new IOException(errMsg);
        }
        FileHelper.copyFile((File)currentSource, (File)currentDestination);
        logger.traceDebug(THIS_CLASS, "startable CV found");
        long size = FileHelper.getFileSize((File)currentDestination);
        cvName = FileHelper.getInitialFileContents((File)currentSource, (long)size);
        logger.traceReturn(THIS_CLASS, "setStartableCv(): " + cvName.trim());
        return cvName.trim();
    }

    private String searchFileDirectory(File rootDirectoryIn, String targetDirectoryIn) throws FileHelper.FileException {
        logger.traceEnter(THIS_CLASS, "searchFileDirectory()");
        String path = "";
        File targetDirectory = new File(targetDirectoryIn);
        if (!rootDirectoryIn.exists() || !rootDirectoryIn.isDirectory()) {
            throw new FileHelper.FileException(rootDirectoryIn.getName() + "does not exist.");
        }
        List<File> fileList = Arrays.asList(rootDirectoryIn.listFiles());
        for (int i = 0; i < fileList.size(); ++i) {
            File currentDirectory = fileList.get(i);
            if (currentDirectory.isDirectory() && !currentDirectory.getName().equalsIgnoreCase(targetDirectory.getName())) {
                path = this.searchFileDirectory(currentDirectory, targetDirectoryIn);
                if (path.equalsIgnoreCase("")) continue;
                break;
            }
            if (!currentDirectory.isDirectory() || !currentDirectory.getName().equalsIgnoreCase(targetDirectory.getName())) continue;
            path = rootDirectoryIn.getPath();
            break;
        }
        logger.traceReturn(THIS_CLASS, "searchFileDirectory() search in: " + rootDirectoryIn + "; find: " + path);
        return path;
    }

    protected String installIntegrationBasicPackage() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "installIntegrationBasicPackage()");
        String[] disks = new String[]{RbsConfigurationDefinitions.HARD_DISK_C, RbsConfigurationDefinitions.HARD_DISK_D};
        String[] ihbpDisks = new String[]{RbsConfigurationDefinitions.HARD_DISK_C2, RbsConfigurationDefinitions.HARD_DISK_D};
        String unzip_dir = FileParameters.instance(this.rbsConfiguration).getIntegrationBasicPackageFileExtractPath();
        if (!unzip_dir.endsWith(File.separator)) {
            unzip_dir = unzip_dir + File.separator;
        }
        String diskParentPath = "";
        try {
            diskParentPath = this.searchFileDirectory(new File(unzip_dir), RbsConfigurationDefinitions.HARD_DISK_C2);
            if (diskParentPath.length() == 0) {
                String msg = "Fail to find: " + RbsConfigurationDefinitions.HARD_DISK_C2 + " in: " + unzip_dir;
                throw new FileHelper.FileException(msg);
            }
        }
        catch (FileHelper.FileException e) {
            String msg = "Fail to find: " + RbsConfigurationDefinitions.HARD_DISK_C2 + " in: " + unzip_dir;
            logger.info(THIS_CLASS, msg);
            throw new RbsConfigurationFailedException("install Integration Basic Package failed.");
        }
        File[] fileList = new File(unzip_dir).listFiles();
        this.isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationIsiHelper.class);
        for (int m = 0; m < disks.length; ++m) {
            File currentDisk = new File(this.rootDirectoryPrefix + disks[m]);
            fileList = currentDisk.listFiles();
            logger.info(THIS_CLASS, "start Integration Basic Package Installation in " + currentDisk.getName());
            boolean useMove = currentDisk.getAbsolutePath().equals(this.rootDirectoryPrefix + RbsConfigurationDefinitions.HARD_DISK_C);
            if (fileList == null) continue;
            for (int n = 0; n < fileList.length; ++n) {
                if (this.ifNotInstallationDirectory(fileList[n])) {
                    logger.info(this.getClass(), "keep current " + fileList[n].getName());
                    continue;
                }
                if (!fileList[n].isDirectory()) continue;
                StringBuffer rollbackListBuffer = new StringBuffer();
                try {
                    File currentSource = new File(diskParentPath + File.separator + ihbpDisks[m] + File.separator + fileList[n].getName());
                    if (!currentSource.exists() || !currentSource.isDirectory()) continue;
                    this.isiHelper.mergeDirectoryTree(currentSource, fileList[n], rollbackListBuffer, useMove);
                    FileHelper.writeToFile((String)(this.rootDirectoryPrefix + RbsConfigurationDefinitions.ISI_ROLL_BACK_FILE), (String)rollbackListBuffer.toString(), (boolean)true);
                    continue;
                }
                catch (FileHelper.FileException exp) {
                    String msg = "Fail to install: " + ihbpDisks[m] + " in: " + unzip_dir + exp.getMessage();
                    logger.info(THIS_CLASS, msg);
                    FileHelper.writeToFile((String)(this.rootDirectoryPrefix + RbsConfigurationDefinitions.ISI_ROLL_BACK_FILE), (String)rollbackListBuffer.toString(), (boolean)true);
                    throw new RbsConfigurationFailedException("install Integration Basic Package failed.");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "installIntegrationBasicPackage(): " + diskParentPath);
        return diskParentPath;
    }

    protected void generateNlhFile(String ranSWCvIn) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "generateNlhFile() RanSwCv: " + ranSWCvIn);
        this.isiHelper = (RbsConfigurationIsiHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationIsiHelper.class);
        try {
            if (!new File(this.rootDirectoryPrefix + "/c/systemfiles/lte/autointegration/").isDirectory()) {
                logger.traceDebug(THIS_CLASS, "generateNlhFile(): /c/systemfiles/lte/autointegration/ is not directory");
                throw new Exception("/c/systemfiles/lte/autointegration/ is not directory");
            }
            this.isiHelper.generateNlhFile(this.rootDirectoryPrefix + "/c/systemfiles/lte/autointegration/Nlh.xml", ranSWCvIn);
        }
        catch (Exception e) {
            String errorMsg = "Exception received when generating NLH File.";
            throw new RbsConfigurationFailedException("Exception received when generating NLH File.");
        }
        logger.traceReturn(THIS_CLASS, "generateNlhFile()");
    }

    private boolean ifNotInstallationDirectory(File directoryIn) {
        boolean result2 = directoryIn.getName().equalsIgnoreCase("backup_isi") || directoryIn.getName().equalsIgnoreCase("systemfiles") || directoryIn.getName().equalsIgnoreCase("logfiles");
        return result2;
    }

    protected void setRootDirectoryPrefix(String rootDirectoryPrefixIn) {
        this.rootDirectoryPrefix = rootDirectoryPrefixIn;
    }

    protected String getRootDirectoryPrefix() {
        return this.rootDirectoryPrefix;
    }
}

