/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.isi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.AbstractRbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ConfigurationServiceListener;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.ScenarioParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.SecurityParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.pbootparam.PbootParamProxyFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.security.FileEncryptor;
import se.ericsson.crbs.common.FileHelper;
import se.ericsson.crbs.common.StringHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RbsConfigurationIsiHelper
extends AbstractRbsConfigurationHelper {
    private static final Class THIS_CLASS = RbsConfigurationIsiHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private FileParameters fileParameters;
    private UpgradeParameters upgradeParameters;
    private SecurityParameters securityParameters;
    private ScenarioParameters scenarioParameters;
    private final String NLH_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final String NLH_ROOT_XML_TAG = "<NlHandoverFile xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Nlh.xsd\" >";
    private final String NLH_END_XML_TAG = "</NlHandoverFile>";

    protected void init(GenericMaoContext aGenericMaoContext, RbsConfigurationMao rbsConfigurationMao, RbsConfigurationContext aRbsConfigurationContext) {
        super.init(aGenericMaoContext, rbsConfigurationMao, aRbsConfigurationContext);
        this.fileParameters = FileParameters.instance(this.rbsConfiguration);
        this.upgradeParameters = UpgradeParameters.instance(this.rbsConfiguration);
        this.securityParameters = SecurityParameters.instance(this.rbsConfiguration);
        this.scenarioParameters = ScenarioParameters.instance(rbsConfigurationMao);
    }

    protected Map parseNlhFile(String nlhFilePath) throws IOException, GeneralSecurityException {
        FileEncryptor encryptor = new FileEncryptor();
        encryptor.decryptFile(nlhFilePath, this.getXmlEncryptionKey());
        File tmpFile = new File(nlhFilePath + "_decrypted");
        Map map = this.parseNlhFile(tmpFile.getPath(), false, null);
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        return map;
    }

    protected Map parseNlhFile(String nlhFilePath, boolean validateXml, String schemaPath) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNlhFile() - nlhFilePath = " + nlhFilePath);
        HashMap nlhFile = new HashMap();
        Parser parser = ParserHelper.createParser(nlhFilePath, validateXml, schemaPath);
        List xmlList = parser.getXMLelements();
        String revision = "";
        if (xmlList == null) {
            throw new IOException("Could not parse NlhFile, invalid XML.");
        }
        Iterator xmlIter = xmlList.iterator();
        while (xmlIter.hasNext()) {
            XMLElement xmlElement = (XMLElement)xmlIter.next();
            String xmlChildType = xmlElement.getType();
            if ("Format".equals(xmlChildType) && revision.equals("")) {
                revision = xmlElement.getAttributes().getValue("revision");
                logger.traceDebug(THIS_CLASS, "parseNlhFile() revision=" + revision);
            }
            if ("NlRollBackCv".equals(xmlChildType)) {
                String nlRollbackCv = this.putNlhFile("NlRollBackCv", "name", xmlElement, nlhFile);
                logger.traceDebug(THIS_CLASS, "parseNlhFile() NlRollBackCV=" + nlRollbackCv);
                if (nlRollbackCv == null) {
                    throw new IOException("Invalid NLH file: Required Element NlRollBackCV is missing.");
                }
            }
            if ("RanSwCv".equals(xmlChildType)) {
                String ranSwCv = this.putNlhFile("RanSwCv", "name", xmlElement, nlhFile);
                logger.traceDebug(THIS_CLASS, "parseNlhFile() RanSwCv=" + ranSwCv);
                if (ranSwCv == null) {
                    throw new IOException("Invalid NLH file: Required Element ranSwCv is missing.");
                }
            }
            if ("NlhStatus".equals(xmlChildType)) {
                String nlhStatus = this.putNlhFile("NlhStatus", "status", xmlElement, nlhFile);
                logger.traceDebug(THIS_CLASS, "parseNlhFile() NlhStatus=" + nlhStatus);
                if (nlhStatus == null) {
                    throw new IOException("Invalid NLH file: Required Element ranSwCv is missing.");
                }
            }
            if ("SiteInstallationFile".equals(xmlChildType)) {
                String commonSif = this.putNlhFile("SiteInstallationFile", "filePath", xmlElement, nlhFile);
                logger.traceDebug(THIS_CLASS, "parseNlhFile() CommonSiteInstallationFile=" + commonSif);
                if (commonSif == null) {
                    throw new IOException("Invalid NLH file: Required Element ranSwCv is missing.");
                }
            }
            if ("SftpData".equals(xmlChildType)) {
                String sftpAddress = this.putNlhFile("address", xmlElement, nlhFile);
                String sftpUser = this.putNlhFile("userName", xmlElement, nlhFile);
                this.putNlhFile("password", xmlElement, nlhFile);
                String sftpUpPath = this.putNlhFile("upgradeFilePath", xmlElement, nlhFile);
                logger.traceDebug(THIS_CLASS, "parseNlhFile() SftpData Adress= " + sftpAddress + " User = " + sftpUser + " upFilePath = " + sftpUpPath);
            }
            if (!"AutoIntegrationRbsSummaryFile".equals(xmlChildType) || !xmlElement.hasChildren()) continue;
            List childList = xmlElement.getChildren();
            for (int i = 0; i < childList.size(); ++i) {
                XMLElement subElement = (XMLElement)childList.get(i);
                String subElementType = subElement.getType();
                if ("WcdmaConfigurationFiles".equals(subElementType)) {
                    String oamAccessFilePath = this.putNlhFile("oamAccessFilePath", subElement, nlhFile);
                    String siteEquipFilePathWcdma = this.putNlhFile("siteEquipmentFilePath", subElement, nlhFile);
                    logger.traceDebug(THIS_CLASS, "parseNlhFile() oamAccessFilePath=" + oamAccessFilePath + " siteEquipFilePathWcdma=" + siteEquipFilePathWcdma);
                    if (oamAccessFilePath == null || siteEquipFilePathWcdma == null) {
                        throw new IOException("Invalid NLH file: WCDMA required file(s) (OAM Access or Site Equipment) are  missing.");
                    }
                    this.putNlhFile("cabinetEquipmentFilePath", subElement, nlhFile);
                    this.putNlhFile("antennaSystemFilePath", subElement, nlhFile);
                    this.putNlhFile("upgradePackageFilePath", subElement, nlhFile);
                    this.putNlhFile("integrationBasicPackageFilePath", subElement, nlhFile);
                }
                if (!"ConfigurationFiles".equals(subElementType)) continue;
                String siteBasicFilePath = this.putNlhFile("siteBasicFilePath", subElement, nlhFile);
                String siteEquipFilePathLte = this.putNlhFile("siteEquipmentFilePath", subElement, nlhFile);
                logger.traceDebug(THIS_CLASS, "parseNlhFile() siteBasicFilePath=" + siteBasicFilePath + " siteEquipFilePathLte=" + siteEquipFilePathLte);
                this.putNlhFile("integrationBasicPackageFilePath", subElement, nlhFile);
                this.putNlhFile("licensingKeyFilePath", subElement, nlhFile);
                this.putNlhFile("upgradePackageFilePath", subElement, nlhFile);
                this.putNlhFile("initialSecurityConfigurationFilePath", subElement, nlhFile);
                this.putNlhFile("initialSecurityConfigurationFileHash", subElement, nlhFile);
                this.putNlhFile("siteBasicFileHash", subElement, nlhFile);
                this.putNlhFile("ipForOamSettingFileHash", subElement, nlhFile);
            }
        }
        logger.traceReturn(THIS_CLASS, "parseNlhFile()");
        return nlhFile;
    }

    protected Map parseSftpDataFromNlhFile(String nlhFilePath) throws IOException, GeneralSecurityException {
        logger.traceEnter(THIS_CLASS, "parseSftpDataFromNlhFile() - nlhFilePath = " + nlhFilePath);
        FileEncryptor encryptor = new FileEncryptor();
        encryptor.decryptFile(nlhFilePath, this.getXmlEncryptionKey());
        File tmpFile = new File(nlhFilePath + "_decrypted");
        HashMap sftpDataMap = new HashMap();
        Parser parser = ParserHelper.createParser(tmpFile.getPath(), false, null);
        List xmlList = parser.getXMLelements();
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        if (xmlList == null) {
            throw new IOException("Could not parse NlhFile, invalid XML.");
        }
        Iterator xmlIter = xmlList.iterator();
        while (xmlIter.hasNext()) {
            XMLElement xmlElement = (XMLElement)xmlIter.next();
            String xmlChildType = xmlElement.getType();
            if (!"SftpData".equals(xmlChildType)) continue;
            String sftpAddress = this.putNlhFile("address", xmlElement, sftpDataMap);
            String sftpUser = this.putNlhFile("userName", xmlElement, sftpDataMap);
            this.putNlhFile("password", xmlElement, sftpDataMap);
            String sftpUpPath = this.putNlhFile("upgradeFilePath", xmlElement, sftpDataMap);
            logger.traceDebug(THIS_CLASS, "parseNlhFile() SftpData Adress= " + sftpAddress + " User = " + sftpUser + " upFilePath = " + sftpUpPath);
        }
        logger.traceReturn(THIS_CLASS, "parseSftpDataFromNlhFile()");
        return sftpDataMap;
    }

    private String putNlhFile(String inputPath, XMLElement xmlElement, Map nlhFiles) {
        String outPath = xmlElement.getAttributes().getValue(inputPath);
        if (outPath != null) {
            nlhFiles.put(inputPath, outPath);
        }
        return outPath;
    }

    private String putNlhFile(String inputElement, String inputAttribute, XMLElement xmlElement, Map nlhFiles) {
        String outPath = xmlElement.getAttributes().getValue(inputAttribute);
        if (outPath != null) {
            nlhFiles.put(inputElement, outPath);
        }
        return outPath;
    }

    private boolean existAndNotEmpty(String stringObject) {
        logger.traceEnter(THIS_CLASS, "existAndNotEmpty() checking: " + stringObject);
        boolean result2 = false;
        if (stringObject != null && stringObject.length() > 0) {
            result2 = true;
        }
        logger.traceReturn(THIS_CLASS, "existAndNotEmpty() result = " + result2);
        return result2;
    }

    public void generateNlhFile(String nlhFilePath, String ranSwCvIn) throws Exception {
        logger.traceEnter(THIS_CLASS, "generateNlhFile() - " + nlhFilePath);
        ArrayList<String> xmlList = new ArrayList<String>();
        this.fileParameters = FileParameters.instance();
        this.upgradeParameters = UpgradeParameters.instance();
        this.securityParameters = SecurityParameters.instance();
        this.scenarioParameters = ScenarioParameters.instance();
        xmlList.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlList.add("<NlHandoverFile xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Nlh.xsd\" >");
        String formatElement = "<Format revision=\"A\"/>";
        xmlList.add(formatElement);
        String nlRollBackCVElement = "<NlRollBackCv name=\"basic_cv\" />";
        xmlList.add(nlRollBackCVElement);
        String ranSwCvElement = "<RanSwCv name=\"" + ranSwCvIn + "\" />";
        xmlList.add(ranSwCvElement);
        String nlhStatusElement = "<NlhStatus status=\"FilesDownloadedSuccessfully\" />";
        xmlList.add(nlhStatusElement);
        if (this.existAndNotEmpty(this.fileParameters.getSiteBasicFilePath())) {
            String commonSiteInstallationFileElement = "<SiteInstallationFile filePath=\"/c/systemfiles/lte/autointegration/SiteInstallation.xml\"  />";
            xmlList.add(commonSiteInstallationFileElement);
        }
        if (this.isLteSemiUseCase()) {
            String sftpDataElement = "<SftpData address=\"" + this.fileParameters.getSftpAddress() + "\"" + " " + "userName" + "=\"" + this.fileParameters.getSftpUserName() + "\"" + " " + "password" + "=\"" + this.fileParameters.getSftpPassword() + "\"" + " " + "upgradeFilePath" + "=\"" + this.upgradeParameters.getUpgradePackageRemotePath() + "\"" + "  />";
            xmlList.add(sftpDataElement);
        }
        String summaryFileElement = "<AutoIntegrationRbsSummaryFile>";
        xmlList.add(summaryFileElement);
        String summaryFileRevisionElement = "<Format revision=\"G\"/>";
        xmlList.add(summaryFileRevisionElement);
        logger.traceDebug(THIS_CLASS, "SiteBasicFilePath = " + this.fileParameters.getSiteBasicFilePath());
        if (this.existAndNotEmpty(this.fileParameters.getSiteBasicFilePath())) {
            String attrIscf;
            String configurationFileElement = "<ConfigurationFiles";
            xmlList.add(configurationFileElement);
            String attrSiteBasic = " siteBasicFilePath=\"" + this.fileParameters.getSiteBasicFilePath() + "\"";
            xmlList.add(attrSiteBasic);
            String attrSiteEquip = " siteEquipmentFilePath=\"" + this.fileParameters.getSiteEquipmentFilePath() + "\"";
            xmlList.add(attrSiteEquip);
            if (this.existAndNotEmpty(this.fileParameters.getLicenseKeyFilePath())) {
                String attrLkf = " licensingKeyFilePath=\"" + this.fileParameters.getLicenseKeyFilePath() + "\"";
                xmlList.add(attrLkf);
            }
            if (this.existAndNotEmpty(this.upgradeParameters.getUpgradePackageFilePath())) {
                String attrUp = " upgradePackageFilePath=\"" + this.upgradeParameters.getUpgradePackageFilePath() + "\"";
                xmlList.add(attrUp);
            }
            if (this.existAndNotEmpty(this.securityParameters.getLocalInitialSecurityConfigurationFile())) {
                attrIscf = " initialSecurityConfigurationFilePath=\"" + this.securityParameters.getLocalInitialSecurityConfigurationFile() + "\"";
                xmlList.add(attrIscf);
            }
            if (this.existAndNotEmpty(this.fileParameters.getIntegrationBasicPackageFilePath())) {
                attrIscf = " integrationBasicPackageFilePath=\"" + this.fileParameters.getIntegrationBasicPackageFilePath() + "\"";
                xmlList.add(attrIscf);
            }
            String configurationFileElementEnd = " />";
            xmlList.add(configurationFileElementEnd);
        }
        logger.traceDebug(THIS_CLASS, "OamAccessFilePath = " + this.fileParameters.getOamAccessFilePath());
        if (this.existAndNotEmpty(this.fileParameters.getOamAccessFilePath())) {
            String configurationFileWcdmaElement = "<WcdmaConfigurationFiles";
            xmlList.add(configurationFileWcdmaElement);
            if (this.existAndNotEmpty(this.fileParameters.getCabinetEquipmentFilePath())) {
                String attrCabinetEquip = " cabinetEquipmentFilePath=\"" + this.fileParameters.getCabinetEquipmentFilePath() + "\"";
                xmlList.add(attrCabinetEquip);
            }
            String attrOamAccess = " oamAccessFilePath=\"" + this.fileParameters.getOamAccessFilePath() + "\"";
            xmlList.add(attrOamAccess);
            String attrSiteEuiqpWcdma = " siteEquipmentFilePath=\"" + this.fileParameters.getSiteEquipmentFilePath() + "\"";
            xmlList.add(attrSiteEuiqpWcdma);
            if (this.existAndNotEmpty(this.fileParameters.getAntennaSystemFilePath())) {
                String attrAntennaSystem = " antennaSystemFilePath=\"" + this.fileParameters.getAntennaSystemFilePath() + "\"";
                xmlList.add(attrAntennaSystem);
            }
            if (this.existAndNotEmpty(this.upgradeParameters.getUpgradePackageFilePath())) {
                String attrUpWcdma = " upgradePackageFilePath=\"" + this.upgradeParameters.getUpgradePackageFilePath() + "\"";
                xmlList.add(attrUpWcdma);
            }
            if (this.existAndNotEmpty(this.fileParameters.getIntegrationBasicPackageFilePath())) {
                String attrIbpWcdma = " integrationBasicPackageFilePath=\"" + this.fileParameters.getIntegrationBasicPackageFilePath() + "\"";
                xmlList.add(attrIbpWcdma);
            }
            String configurationFileWcdmaElementEnd = " />";
            xmlList.add(configurationFileWcdmaElementEnd);
        }
        String summaryFileElementEnd = "</AutoIntegrationRbsSummaryFile>";
        xmlList.add(summaryFileElementEnd);
        xmlList.add("</NlHandoverFile>");
        String[] xmls = new String[xmlList.size()];
        xmlList.toArray(xmls);
        File nlhFile = new File(nlhFilePath);
        if (nlhFile.exists()) {
            nlhFile.delete();
        }
        for (int i = 0; i < xmls.length; ++i) {
            FileHelper.writeToFile((String)nlhFilePath, (String)(xmls[i] + "\n"), (boolean)true);
        }
        FileEncryptor encryptor = new FileEncryptor();
        encryptor.encryptFile(nlhFilePath, this.getXmlEncryptionKey());
        logger.traceReturn(THIS_CLASS, "generateNlhFile() - " + nlhFilePath);
    }

    private boolean isLteSemiUseCase() {
        return this.scenarioParameters.getWithGuiScenario() == 3;
    }

    public void restoreAutoIntegrationParameters(String nlhFilePath) throws IOException, GeneralSecurityException {
        String initialSecurityConfigurationFilePath;
        String upgradePackageFilePath;
        String licensingKeyFilePath;
        String siteBasicFilePath;
        String siteEquipmentFilePath;
        logger.traceEnter(THIS_CLASS, "restoreAutoIntegrationParameters()");
        Map nlhFile = this.parseNlhFile(nlhFilePath);
        HashMap nlhElement = new HashMap();
        nlhElement.putAll(nlhFile);
        this.fileParameters = FileParameters.instance();
        this.upgradeParameters = UpgradeParameters.instance();
        this.securityParameters = SecurityParameters.instance();
        String integrationBasicPackageFilePath = (String)nlhElement.get("integrationBasicPackageFilePath");
        if (this.existAndNotEmpty(integrationBasicPackageFilePath)) {
            this.fileParameters.setIntegrationBasicPackageFilePath(integrationBasicPackageFilePath);
            logger.traceDebug(THIS_CLASS, "set IntegrationBasicPackageFilePath to: " + integrationBasicPackageFilePath);
        }
        if (this.existAndNotEmpty(siteEquipmentFilePath = (String)nlhElement.get("siteEquipmentFilePath"))) {
            this.fileParameters.setSiteEquipmentFilePath(siteEquipmentFilePath);
            logger.traceDebug(THIS_CLASS, "set SiteEquipmentFilePath to: " + siteEquipmentFilePath);
        }
        if (this.existAndNotEmpty(siteBasicFilePath = (String)nlhElement.get("siteBasicFilePath"))) {
            this.fileParameters.setSiteBasicFilePath(siteBasicFilePath);
            logger.traceDebug(THIS_CLASS, "set SiteBasicFilePath to: " + siteBasicFilePath);
        }
        if (this.existAndNotEmpty(licensingKeyFilePath = (String)nlhElement.get("licensingKeyFilePath"))) {
            this.fileParameters.setLicenseKeyFilePath(licensingKeyFilePath);
            logger.traceDebug(THIS_CLASS, "set LicenseKeyFilePath to: " + licensingKeyFilePath);
        }
        if (this.existAndNotEmpty(upgradePackageFilePath = (String)nlhElement.get("upgradePackageFilePath"))) {
            this.upgradeParameters.setUpgradePackageFilePath(upgradePackageFilePath);
            logger.traceDebug(THIS_CLASS, "set UpgradePackageFilePath to: " + upgradePackageFilePath);
        }
        if (this.existAndNotEmpty(initialSecurityConfigurationFilePath = (String)nlhElement.get("initialSecurityConfigurationFilePath"))) {
            this.securityParameters.setLocalInitialSecurityConfigurationFile(initialSecurityConfigurationFilePath);
            logger.traceDebug(THIS_CLASS, "set LocalInitialSecurityConfigurationFile to: " + initialSecurityConfigurationFilePath);
        }
        logger.traceReturn(THIS_CLASS, "restoreAutoIntegrationParameters()");
    }

    public String getNlRollBackCv(String nlhFilePath) throws IOException, GeneralSecurityException {
        logger.traceEnter(THIS_CLASS, "getNlRollBackCv()");
        Map nlhFile = this.parseNlhFile(nlhFilePath);
        HashMap nlhElement = new HashMap();
        nlhElement.putAll(nlhFile);
        String cvName = (String)nlhElement.get("NlRollBackCv");
        logger.traceReturn(THIS_CLASS, "getNlRollBackCv(): " + cvName);
        return cvName;
    }

    public String getRanSwCv(String nlhFilePath) throws IOException, GeneralSecurityException {
        logger.traceEnter(THIS_CLASS, "getRanSwCv()");
        Map nlhFile = this.parseNlhFile(nlhFilePath);
        HashMap nlhElement = new HashMap();
        nlhElement.putAll(nlhFile);
        String cvName = (String)nlhElement.get("RanSwCv");
        logger.traceReturn(THIS_CLASS, "getRanSwCv(): " + cvName);
        return cvName;
    }

    public String getNlhStatus(String nlhFilePath) throws IOException, GeneralSecurityException {
        logger.traceEnter(this.getClass(), "getNlhStatus()");
        Map nlhFile = this.parseNlhFile(nlhFilePath);
        HashMap nlhElement = new HashMap();
        nlhElement.putAll(nlhFile);
        String isiStatus = (String)nlhElement.get("NlhStatus");
        logger.traceReturn(THIS_CLASS, "getNlhStatus(): " + isiStatus);
        return isiStatus;
    }

    public String getSiteInstallationFile(String nlhFilePath) throws IOException, GeneralSecurityException {
        logger.traceEnter(THIS_CLASS, "getSiteInstallationFile()");
        Map nlhFile = this.parseNlhFile(nlhFilePath);
        HashMap nlhElement = new HashMap();
        nlhElement.putAll(nlhFile);
        String sifPath = (String)nlhElement.get("SiteInstallationFile");
        logger.traceReturn(THIS_CLASS, "getSiteInstallationFile(): " + sifPath);
        return sifPath;
    }

    public Map getSftpData(String nlhFilePath) throws IOException, GeneralSecurityException {
        logger.traceEnter(THIS_CLASS, "getSftpData()");
        Map sftpDataMap = this.parseSftpDataFromNlhFile(nlhFilePath);
        HashMap<String, String> sftpData = null;
        String add = (String)sftpDataMap.get("address");
        String userName = (String)sftpDataMap.get("userName");
        String pwd = (String)sftpDataMap.get("password");
        String path = (String)sftpDataMap.get("upgradeFilePath");
        if (this.existAndNotEmpty(add) && this.existAndNotEmpty(userName) && this.existAndNotEmpty(pwd) && this.existAndNotEmpty(path)) {
            sftpData = new HashMap<String, String>();
            sftpData.put("address", add);
            sftpData.put("userName", userName);
            sftpData.put("password", pwd);
            sftpData.put("upgradeFilePath", path);
        }
        logger.traceReturn(THIS_CLASS, "getSftpData() Address = " + add + " User = " + userName + " upPath = " + path);
        return sftpData;
    }

    public void mergeDirectoryTree(File sourceFile, File destinationFile, StringBuffer backupListBuffer, boolean useMove) throws FileHelper.FileException {
        if (!sourceFile.exists() || !sourceFile.isDirectory()) {
            throw new FileHelper.FileException(sourceFile.getName() + "does not exist.");
        }
        if (!destinationFile.exists() || !destinationFile.isDirectory()) {
            throw new FileHelper.FileException(destinationFile.getName() + "does not exist.");
        }
        List<File> sourceFileList = Arrays.asList(sourceFile.listFiles());
        for (int i = 0; i < sourceFileList.size(); ++i) {
            File currentSourceFile = sourceFileList.get(i);
            File currentDestinationFile = new File(destinationFile.getPath() + File.separator + currentSourceFile.getName());
            if (currentSourceFile.isDirectory()) {
                if (!currentDestinationFile.exists() && !currentDestinationFile.mkdir()) {
                    throw new FileHelper.FileException("Could not make directory: " + StringHelper.doubleQuote((String)currentDestinationFile.getPath()));
                }
                this.mergeDirectoryTree(currentSourceFile, currentDestinationFile, backupListBuffer, useMove);
                continue;
            }
            if (!currentSourceFile.isFile() || currentDestinationFile.exists()) continue;
            if (!useMove) {
                try {
                    FileHelper.copyFile((File)currentSourceFile, (File)currentDestinationFile);
                }
                catch (IOException e) {
                    throw new FileHelper.FileException("Failed to copy file from " + currentSourceFile + " to " + currentDestinationFile);
                }
            } else if (!currentSourceFile.renameTo(currentDestinationFile)) {
                throw new FileHelper.FileException("Failed to move file from " + currentSourceFile + " to " + currentDestinationFile);
            }
            backupListBuffer.append(currentDestinationFile.getPath() + File.pathSeparator);
        }
    }

    public void removeMergedIbpLoadModules(String rootDirIn, RbsConfigurationMao rbsConfigurationIn) throws MoAccessException, FileHelper.FileException {
        logger.traceEnter(THIS_CLASS, "removeMergedIbpLoadModules()");
        boolean successful = false;
        ConfigurationVersionMo currentCV = this.getCvMo(rbsConfigurationIn);
        String cvName = currentCV.getExecutingCv(null);
        String strLine = "";
        String rollBackFilePath = rootDirIn + RbsConfigurationDefinitions.ISI_ROLL_BACK_FILE;
        File nlhFile = new File(rootDirIn + "/c/systemfiles/lte/autointegration/Nlh.xml");
        logger.traceDebug(THIS_CLASS, "Node is running on ConfigurationVersion:" + cvName);
        logger.traceDebug(THIS_CLASS, "NLH file exists: " + nlhFile.exists());
        String rollbackCv = "basic_cv";
        if (cvName.equalsIgnoreCase(rollbackCv) && !nlhFile.exists()) {
            try {
                FileInputStream fstream = new FileInputStream(rollBackFilePath);
                BufferedReader bufferReader = new BufferedReader(new InputStreamReader(fstream));
                while ((strLine = bufferReader.readLine()) != null && strLine.trim().endsWith(File.pathSeparator)) {
                    strLine = strLine.substring(0, strLine.length() - 1);
                    new File(strLine).delete();
                }
                bufferReader.close();
                successful = true;
            }
            catch (FileNotFoundException e) {
                logger.traceDebug(THIS_CLASS, "Rollback File does not exist: " + rollBackFilePath + " due to: " + e.getMessage());
            }
            catch (IOException ioe) {
                logger.traceDebug(THIS_CLASS, "Fail to read: " + rollBackFilePath + " due to: " + ioe.getMessage());
            }
        } else {
            logger.traceDebug(THIS_CLASS, "Integration Basic Package Load Modules will not be deleted.");
        }
        if (successful) {
            File backupFolder = new File(rootDirIn + RbsConfigurationDefinitions.ISI_BACKUP_C);
            FileHelper.deleteDirectoryTree((File)backupFolder);
        }
        logger.traceReturn(THIS_CLASS, "removeMergedIbpLoadModules(): success = " + successful);
    }

    public void cleanConfigurationFilesAndIsiTempFiles(String rootDirIn) throws FileHelper.FileException {
        logger.traceEnter(THIS_CLASS, "cleanConfigurationFilesAndIsiTempFiles()");
        FileHelper.deleteDirectoryTree((File)new File(rootDirIn + "/c/systemfiles/lte/autointegration/"));
        logger.traceDebug(THIS_CLASS, "Directory has been deleted: /c/systemfiles/lte/autointegration/");
        FileHelper.deleteDirectoryTree((File)new File(rootDirIn + RbsConfigurationDefinitions.ISI_TEMP_PATH));
        logger.traceDebug(THIS_CLASS, "Directory has been deleted: " + RbsConfigurationDefinitions.ISI_TEMP_PATH);
        logger.traceReturn(THIS_CLASS, "cleanConfigurationFilesAndIsiTempFiles()");
    }

    public void cleanEncryptedFilesAndRollbackFile(String rootDirIn) {
        logger.traceEnter(THIS_CLASS, "cleanEncryptedFilesAndRollbackFile()");
        File aFile = new File(rootDirIn + "/c/systemfiles/lte/autointegration/Nlh.xml");
        if (aFile.isFile()) {
            aFile.delete();
        }
        if ((aFile = new File(rootDirIn + "/c/systemfiles/lte/autointegration/SiteInstallation.xml")).isFile()) {
            aFile.delete();
        }
        if ((aFile = new File(rootDirIn + RbsConfigurationDefinitions.ISI_ROLL_BACK_FILE)).isFile()) {
            aFile.delete();
        }
        logger.traceReturn(THIS_CLASS, "cleanEncryptedFilesAndRollbackFile()");
    }

    public ConfigurationVersionMo getCvMo(RbsConfigurationMao rbsConfigurationIn) {
        logger.traceEnter(THIS_CLASS, "getCvMo()");
        ConfigurationVersionMo cvMo = (ConfigurationVersionMo)rbsConfigurationIn.getRbsConfigurationContext().getMoRepositoryWrapper().lookup("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
        if (cvMo == null) {
            String msg = "Could not find the ConfigurationVersion Mo";
            logger.traceError(THIS_CLASS, "getCvMo(): Could not find the ConfigurationVersion Mo");
        }
        logger.traceReturn(THIS_CLASS, "getCvMo()");
        return cvMo;
    }

    public String getXmlEncryptionKey() {
        return this.getSerialNumber() + this.getMacAddress();
    }

    private String getSerialNumber() {
        SlotMo slotMo = (SlotMo)this.genericMaoContext.getMoRepositoryWrapper().lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1");
        String serialNumber = PbootParamProxyFactory.getPbootParamProxy().getPbootParameter("fru_serialnumber");
        if (serialNumber == null) {
            logger.traceDebug(THIS_CLASS, "fru_serialnumber not found in PBOOT parameters, trying to find serialnumber");
            serialNumber = PbootParamProxyFactory.getPbootParamProxy().getPbootParameter("serialnumber");
            if (serialNumber == null) {
                logger.traceError(THIS_CLASS, "serialnumber not found in PBOOT parameters");
            }
        }
        if (serialNumber == null && slotMo != null && this.isOamServiceReady()) {
            try {
                serialNumber = (String)slotMo.getProductData(null).getValue("serialNumber");
            }
            catch (Exception e) {
                logger.traceDebug(THIS_CLASS, "Serial Number could not be retrieved from: ManagedElement=1,Equipment=1,Subrack=1,Slot=1due to: " + e.getMessage());
            }
        }
        return serialNumber == null ? "" : serialNumber;
    }

    private String getMacAddress() {
        MoRepositoryWrapper moRepository = this.genericMaoContext.getMoRepositoryWrapper();
        EthernetLinkMo ethernetLinkMo = (EthernetLinkMo)moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,EthernetLink=1");
        String macAdress = PbootParamProxyFactory.getPbootParamProxy().getPbootParameter("ethernetid0");
        if (macAdress == null) {
            logger.traceError(THIS_CLASS, "Ethernet MAC_address not found in PBOOT parameters");
        } else {
            macAdress = this.formatMacAdress(macAdress);
        }
        if (macAdress == null && ethernetLinkMo != null && this.isOamServiceReady()) {
            try {
                macAdress = ethernetLinkMo.getMacAddress(null);
            }
            catch (Exception exp) {
                logger.traceDebug(THIS_CLASS, "Ethernet MAC_address could not be retrieved from: ManagedElement=1,IpOam=1,Ip=1,EthernetLink=1due to: " + exp.getMessage());
            }
        }
        return macAdress == null ? "" : macAdress;
    }

    private String formatMacAdress(String macAddress) {
        String hexConvenion = "0x";
        if (macAddress.startsWith(hexConvenion)) {
            int macLength = macAddress.length();
            StringBuffer sBuffer = new StringBuffer();
            int index = 2;
            int colonPos = 0;
            while (index < macLength) {
                if (colonPos == 2) {
                    sBuffer.append(':');
                    colonPos = 0;
                }
                sBuffer.append(macAddress.charAt(index));
                ++index;
                ++colonPos;
            }
            macAddress = sBuffer.toString();
        }
        return macAddress.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOamServiceReady() {
        ConfigurationServiceListener csListener = new ConfigurationServiceListener();
        if (!csListener.isOamServiceReady()) {
            ConfigurationServiceListener configurationServiceListener = csListener;
            synchronized (configurationServiceListener) {
                csListener.register();
                try {
                    logger.traceDebug(THIS_CLASS, "Waiting for that CPP OAM Service is ready...");
                    csListener.wait(75000L);
                }
                catch (InterruptedException ie) {
                    logger.traceDebug(THIS_CLASS, "Interrupted while waiting for that OAM Service is ready. " + ie);
                }
                finally {
                    csListener.deregister();
                }
            }
        }
        logger.traceDebug(THIS_CLASS, "CPP Configuration Service ready: " + csListener.isOamServiceReady());
        return csListener.isOamServiceReady();
    }

    public String getHelperName() {
        return this.getClass().getName();
    }
}

