/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.swmanagement.UpgradeTraceMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.common.FileHelper;
import se.ericsson.crbs.cat.mao.interfaces.LogCollector;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.UpgradePackageHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class LogHandler {
    private static final String AUTO_INTEGRATION_REPORT_FILE_PREFIX = "Autointegration_report";
    protected static final String ZIP_FILE_PATH_PROPERTY = "zip.file.path";
    protected static final String AUTOINTEGRATION_CONFIGURATION_REPORT_LOG_FILE_PROPERTY = "loghandler.auto.integration.report.file.path";
    protected static final String UPGRADE_MO_FILE_PATH_PROPERTY = "upgrade.mo.tmp.file.path";
    protected static final String AUTO_INTEGRATION_PATH_PROPERTY = "loghandler.auto.integration.path";
    protected static final String PMD_PATH_PROPERTY = "loghandler.pmd.path";
    protected static final String JDUMPTHREADS_FILE_PATH_PROPERTY = "loghandler.jdumpthreads.file.path";
    protected static final String PS_OUTPUT_FILE_PATH_PROPERTY = "loghandler.ps_output.file.path";
    protected static final String LLOG_FILE_PATH_PROPERTY = "loghandler.llog.file.path";
    protected static final String AVAILABILITY_FILE_PATH_PROPERTY = "loghandler.availability.file.path";
    protected static final String AUDIT_TRAIL_FILE_PATH_PROPERTY = "loghandler.audit_trail.file.path";
    private static final String UPGRADE_MO_FILE_PATH = "/c/logfiles";
    protected static final String UPGRADE_PACKAGE_MO_TMP_FILE_NAME = "upgrade_package_mo_info.log";
    private static final String ZIP_DIR = "/c/logfiles/autointegration";
    private static final String PMD_PATH = "/c/pmd";
    private static final String AUTOINTEGRATION_CONFIGURATION_REPORT_LOG_FILE = "/c/logfiles/autointegration/configurationReport.log";
    private static final String AUDIT_TRAIL_PATH = "/c/logfiles/audit_trail";
    private static final String AVAILABILITY_PATH = "/c/logfiles/availability";
    private static final Class THIS_CLASS = LogHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private LogHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeZipFileOfLogFiles(String logicalName, ConfigurationVersion configurationVersion, RbsConfigurationMao rbsConfigurationMao, Coordinator coordinator) throws IOException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "makeZipFileOfLogFiles()");
        ZipOutputStream zipOutputStream = null;
        String zipFilePath = System.getProperty(ZIP_FILE_PATH_PROPERTY, ZIP_DIR);
        if (!zipFilePath.endsWith(File.separator)) {
            zipFilePath = zipFilePath + File.separator;
        }
        String theLogicalName = logicalName == null || logicalName.equals("") ? "unknown" : logicalName;
        String zipFileName = zipFilePath + "autointegration_logs_" + theLogicalName + ".zip";
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFileName));
            File zipFile = new File(zipFileName);
            zipFile.createNewFile();
            String auditTrailPath = System.getProperty(AUDIT_TRAIL_FILE_PATH_PROPERTY, AUDIT_TRAIL_PATH);
            LogHandler.addFilesInDirectoryToZipFile(zipOutputStream, new File(auditTrailPath));
            String availabilityPath = System.getProperty(AVAILABILITY_FILE_PATH_PROPERTY, AVAILABILITY_PATH);
            LogHandler.addFilesInDirectoryToZipFile(zipOutputStream, new File(availabilityPath));
            LogHandler.addLogFromUpgradeTraceMoToZip(zipFile, zipOutputStream, rbsConfigurationMao, coordinator);
            LogHandler.addAutoIntegrationFileToZip(zipOutputStream);
            try {
                ((LogCollector)rbsConfigurationMao.getRbsConfigurationContext().getMoRepositoryWrapper().lookup("ManagedElement=1,NodeManagementFunction=1")).actionCollectAutIntLogs(coordinator);
                String lLogPath = System.getProperty(LLOG_FILE_PATH_PROPERTY, "/c/logfiles/autointegration/llog_output.log");
                LogHandler.addFileToZipFile(zipOutputStream, new File(lLogPath));
                String psOutputPath = System.getProperty(PS_OUTPUT_FILE_PATH_PROPERTY, "/c/logfiles/autointegration/ps_output.log");
                LogHandler.addFileToZipFile(zipOutputStream, new File(psOutputPath));
                String jDumpThreadPath = System.getProperty(JDUMPTHREADS_FILE_PATH_PROPERTY, "/c/logfiles/autointegration/jdumpthreads.log");
                LogHandler.addFileToZipFile(zipOutputStream, new File(jDumpThreadPath));
            }
            catch (Exception e) {
                logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to execute action to collect log files based on NCLI commands", (Throwable)e));
            }
            LogHandler.addUpgradeMoInfoToZipFile(zipOutputStream, configurationVersion, coordinator);
            String clientUtcTimeStr = (String)rbsConfigurationMao.retrievePersistently("autoIntegrationStartTime");
            long clientUtcTime = 0L;
            if (clientUtcTimeStr != null) {
                try {
                    clientUtcTime = Long.parseLong(clientUtcTimeStr);
                }
                catch (NumberFormatException nfe) {
                    logger.traceAbnormal(THIS_CLASS, "Failed to parse auto integration start time: " + clientUtcTimeStr);
                }
            }
            LogHandler.addPmdFilesToZip(zipOutputStream, clientUtcTime);
            String autoIntegrationReportFile = System.getProperty(AUTOINTEGRATION_CONFIGURATION_REPORT_LOG_FILE_PROPERTY, AUTOINTEGRATION_CONFIGURATION_REPORT_LOG_FILE);
            LogHandler.addFileToZipFile(zipOutputStream, new File(autoIntegrationReportFile));
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (IOException ioe) {
                logger.traceDebug(THIS_CLASS, "Unable to close outputstream for zip file of logs. " + ioe);
            }
        }
        logger.traceReturn(THIS_CLASS, "makeZipFileOfLogFiles()");
        return zipFileName;
    }

    private static void addFilesInDirectoryToZipFile(ZipOutputStream zipOutputStream, File directory) throws IOException {
        List filesInDirList = FileHelper.getDirectoryContents((File)directory);
        for (int i = 0; i < filesInDirList.size(); ++i) {
            File file = (File)filesInDirList.get(i);
            LogHandler.addFileToZipFile(zipOutputStream, file);
        }
    }

    private static void addUpgradeMoInfoToZipFile(ZipOutputStream zipOutputStream, ConfigurationVersion configurationVersion, Coordinator coordinator) throws MoAccessException, IOException {
        UpgradePackageMo upgradePackageMo = (UpgradePackageMo)configurationVersion.getCurrentUpgradePackage(coordinator);
        String dirPath = System.getProperty(UPGRADE_MO_FILE_PATH_PROPERTY, UPGRADE_MO_FILE_PATH);
        String filePath = dirPath.endsWith(File.separator) ? dirPath + UPGRADE_PACKAGE_MO_TMP_FILE_NAME : dirPath + File.separator + UPGRADE_PACKAGE_MO_TMP_FILE_NAME;
        FileHelper.writeToFile((String)filePath, (String)UpgradePackageHelper.getUpgradePackageInfo(upgradePackageMo, coordinator), (boolean)false);
        File theFile = new File(filePath);
        LogHandler.addFileToZipFile(zipOutputStream, theFile);
        theFile.delete();
    }

    private static void addPmdFilesToZip(ZipOutputStream zipOutputStream, long startIntegrationUtcTime) throws IOException {
        String pmdPath = System.getProperty(PMD_PATH_PROPERTY, PMD_PATH);
        File dir = new File(pmdPath);
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].lastModified() <= startIntegrationUtcTime) continue;
            LogHandler.addFileToZipFile(zipOutputStream, children[i]);
        }
    }

    private static void addAutoIntegrationFileToZip(ZipOutputStream zipOutputStream) throws IOException {
        String autoIntegrationPath = System.getProperty(AUTO_INTEGRATION_PATH_PROPERTY, ZIP_DIR);
        File dir = new File(autoIntegrationPath);
        File[] children = dir.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].getName().startsWith(AUTO_INTEGRATION_REPORT_FILE_PREFIX)) continue;
                LogHandler.addFileToZipFile(zipOutputStream, children[i]);
                break;
            }
        }
    }

    private static void addLogFromUpgradeTraceMoToZip(File zipFile, ZipOutputStream zipOutputStream, RbsConfigurationMao rbsConfigurationMao, Coordinator coordinator) throws MoAccessException, IOException {
        String upgradeTraceFilePath = "";
        MoRepositoryWrapper moRepository = rbsConfigurationMao.getRbsConfigurationContext().getGenericMaoContext().getMoRepositoryWrapper();
        UpgradeTraceMo upgradeTraceMo = (UpgradeTraceMo)moRepository.lookup("ManagedElement=1,SwManagement=1,UpgradeTrace=1");
        if (upgradeTraceMo == null) {
            logger.traceAbnormal(THIS_CLASS, "UpgradeTraceMo not found! Not possible to add log files from UpgradeTrace MO to " + zipFile);
        } else {
            String upgradeTraceDirPath = (String)upgradeTraceMo.getAttribute("traceDirectoryPath", coordinator);
            if (!upgradeTraceDirPath.endsWith(File.separator)) {
                upgradeTraceDirPath = upgradeTraceDirPath + File.separator;
            }
            String upgradeTraceFileName = (String)upgradeTraceMo.getAttribute("fileName", coordinator);
            upgradeTraceFilePath = upgradeTraceDirPath + upgradeTraceFileName;
            logger.traceGeneral(THIS_CLASS, "traceDirectoryPathfileName read from attribute: " + upgradeTraceFilePath);
            LogHandler.addFileToZipFile(zipOutputStream, new File(upgradeTraceFilePath));
        }
    }

    private static void addFileToZipFile(ZipOutputStream zipOutputStream, File fileToBeAdded) throws IOException {
        if (fileToBeAdded.exists()) {
            if (!fileToBeAdded.isDirectory()) {
                byte[] buf = new byte[1024];
                String fullPath = fileToBeAdded.getAbsolutePath();
                String parentPath = fileToBeAdded.getParentFile().getAbsolutePath();
                int index = parentPath.length() + 1;
                try {
                    String filePathToBeAdded = fullPath.substring(index);
                    zipOutputStream.putNextEntry(new ZipEntry(filePathToBeAdded));
                    FileInputStream in = new FileInputStream(fileToBeAdded);
                    int length = in.read(buf);
                    while (length >= 0) {
                        zipOutputStream.write(buf, 0, length);
                        length = in.read(buf);
                    }
                    zipOutputStream.closeEntry();
                    in.close();
                }
                catch (Exception e) {
                    throw new IOException("Could not add \"" + fileToBeAdded + "\": Reason: " + e.getMessage());
                }
                zipOutputStream.closeEntry();
            }
        } else {
            logger.traceAbnormal(THIS_CLASS, "File does not exist: " + fileToBeAdded);
        }
    }
}

