/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationMoFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.TransportNetworkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLogger;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public abstract class AbstractTransportNetworkHelper {
    private static final Class THIS_CLASS = AbstractTransportNetworkHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String transportNetworkFailureSlogan = "Transport Network configuration failure!";
    protected static final String moCreateFailed = " - MO create failed!";
    protected static final String factoryNotFoundFail = " - MO create failed! Could not find MO factory";
    protected static final String updateAttributeFail = " - Failed to update attributes on MO";
    protected final transient MoRepositoryWrapper aMoRepository;
    protected final transient MoFactoryMgrWrapper aFactoryMgr;
    protected final transient RbsConfigurationMoFinder moFinder;
    protected final transient ConfigurationReportLogger configReportLogger = ConfigurationReportLoggerFactory.getLogger();

    public AbstractTransportNetworkHelper(GenericMaoContext aGenericMaoContext) {
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = aGenericMaoContext.getMoFactoryMgrWrapper();
        this.moFinder = new RbsConfigurationMoFinder(aGenericMaoContext);
    }

    public abstract void configureTransportNetwork(TransportNetworkData var1, Coordinator var2) throws RbsConfigurationFailedException;

    protected void configureENodeBFunction(TransportNetworkData tnData, Coordinator coordinator) throws RbsConfigurationFailedException {
        if (tnData.eNBId != null || tnData.eNBPlmnId != null) {
            ManagedObject eNodeBFunction = this.aMoRepository.lookup("ManagedElement=1,ENodeBFunction=1");
            if (eNodeBFunction == null) {
                String slogan = "MO not found";
                String faultMsg = "Could not find the system created MO: ENodeBFunction.";
                throw new RbsConfigurationFailedException("MO not found", "Could not find the system created MO: ENodeBFunction.");
            }
            if (tnData.eNBId != null) {
                String[] attrNames = new String[]{"eNBId"};
                Object[] attrValues = new Object[]{new Integer(tnData.eNBId)};
                this.setAttributes(eNodeBFunction, attrNames, attrValues, coordinator);
            }
            if (tnData.eNBPlmnId != null) {
                String[] names = new String[]{"mcc", "mnc", "mncLength"};
                Object[] values = new Integer[]{new Integer(tnData.eNBPlmnId.substring(0, 3)), new Integer(tnData.eNBPlmnId.substring(3)), new Integer(tnData.eNBPlmnId.length() - 3)};
                StructImpl plmnId = new StructImpl(names, values);
                String[] attrNames = new String[]{"eNodeBPlmnId"};
                Object[] attrValues = new Object[]{plmnId};
                this.setAttributes(eNodeBFunction, attrNames, attrValues, coordinator);
            }
        }
    }

    protected void setSctpRefInENodeB(ManagedObject eNodeBFunction, ManagedObject sctp, Coordinator coordinator) throws RbsConfigurationFailedException {
        String[] attrNames = new String[]{"sctpRef"};
        Object[] attrValues = new Object[]{sctp};
        this.setAttributes(eNodeBFunction, attrNames, attrValues, coordinator);
    }

    protected ManagedObject createMo(String type, ManagedObject parent, AttrListImpl attrList, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createMo");
        MoFactory theMoFactory = this.findAndCheckFactory(type);
        try {
            ManagedObject theMo = theMoFactory.createMo(parent, (AttrList)attrList, "1", null, coordinator);
            RbsConfigurationUnlockHelper.getInstance().registerCreatedMo(theMo, coordinator);
            this.logCreate(theMo, attrList);
            logger.traceReturn(THIS_CLASS, "createMo");
            return theMo;
        }
        catch (MoAccessException mae) {
            String msg = type + moCreateFailed;
            throw new RbsConfigurationFailedException(transportNetworkFailureSlogan, msg, (Exception)((Object)mae));
        }
        catch (InactiveTransactionException ite) {
            String msg = type + moCreateFailed;
            throw new RbsConfigurationFailedException(transportNetworkFailureSlogan, msg, (Exception)((Object)ite));
        }
    }

    protected MoFactory findAndCheckFactory(String moType) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "findAndCheckFactory() moType: " + moType);
        MoFactory aMoFactory = this.aFactoryMgr.lookup(moType);
        if (aMoFactory == null) {
            String faultMsg = "Could not find MO factory for " + moType + ".";
            throw new RbsConfigurationFailedException(factoryNotFoundFail, faultMsg);
        }
        logger.traceReturn(THIS_CLASS, "findAndCheckFactory()");
        return aMoFactory;
    }

    protected ManagedObject findAndCheckParentMo(String parentType, String parentLdn) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "findAndCheckParentMo");
        ManagedObject parent = null;
        try {
            parent = this.moFinder.lookup(parentType, parentLdn, transportNetworkFailureSlogan);
        }
        catch (RbsConfigurationFailedException rcfe) {
            String slogan = "Parent MO not found";
            throw new RbsConfigurationFailedException("Parent MO not found", rcfe.getFormattedMessages());
        }
        logger.traceReturn(THIS_CLASS, "findAndCheckParentMo");
        return parent;
    }

    protected void logCreate(ManagedObject anMo, AttrListImpl attrList) {
        String[] names = new String[attrList.size() + 1];
        Object[] values = new Object[attrList.size() + 1];
        for (int index = 0; index < attrList.size() + 1; ++index) {
            if (index == 0) {
                names[index] = "LDN";
                values[index] = anMo.getLocalDistinguishedName();
                continue;
            }
            names[index] = attrList.getName(index - 1);
            values[index] = attrList.getValue(index - 1);
        }
        this.configReportLogger.logAction(anMo.getType(), "create", names, values);
    }

    protected void setAttributes(ManagedObject theMo, String[] attributeNames, Object[] attributeValues, Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            theMo.setAttributes(attributeNames, attributeValues, coordinator);
            this.configReportLogger.logAttributes(theMo.getType(), attributeNames, attributeValues);
        }
        catch (MoAccessException mae) {
            String msg = theMo.getType() + updateAttributeFail;
            throw new RbsConfigurationFailedException(transportNetworkFailureSlogan, msg, (Exception)((Object)mae));
        }
    }
}

