/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationMoFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationUnlockHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.CellDataFdd;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.CellDataTdd;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.GenericCellData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.logger.ConfigurationReportLogger;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CellHelper {
    private static final Class THIS_CLASS = CellHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient MoRepositoryWrapper aMoRepository;
    private final transient MoFactoryMgrWrapper aFactoryMgr;
    protected final transient ConfigurationReportLogger configReportLogger;
    private static final String configurationFailure = " configuration failure";
    private final transient RbsConfigurationMoFinder moFinder;

    public CellHelper(GenericMaoContext aGenericMaoContext) {
        logger.traceEnter(THIS_CLASS, "CellHelper()");
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.aFactoryMgr = aGenericMaoContext.getMoFactoryMgrWrapper();
        this.configReportLogger = ConfigurationReportLoggerFactory.getLogger();
        this.moFinder = new RbsConfigurationMoFinder(aGenericMaoContext);
        logger.traceReturn(THIS_CLASS, "CellHelper()");
    }

    public ManagedObject createCell(GenericCellData cellData, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "createCell()");
        String eutranCellType = "EUtranCellTDD";
        String eutranCellLdn = "ManagedElement=1,ENodeBFunction=1,EUtranCellTDD=" + cellData.cellId.toString();
        if (this.isCellDataOffFddType(cellData)) {
            eutranCellType = "EUtranCellFDD";
            eutranCellLdn = "ManagedElement=1,ENodeBFunction=1,EUtranCellFDD=" + cellData.cellId.toString();
        }
        String cellFailureSlogan = eutranCellType + configurationFailure;
        ManagedObject eutranCellMo = this.aMoRepository.lookup(eutranCellLdn);
        if (eutranCellMo == null) {
            eutranCellMo = this.createEUtranCell(cellData, eutranCellType, eutranCellLdn, cellFailureSlogan, coordinator);
        } else {
            this.updateEUtranCellAttributes(cellData, eutranCellType, eutranCellLdn, eutranCellMo, cellFailureSlogan, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "createCell()");
        return eutranCellMo;
    }

    public boolean isCellDataOffFddType(GenericCellData cellData) {
        return cellData instanceof CellDataFdd;
    }

    private ManagedObject createEUtranCell(GenericCellData cellData, String eutranCellType, String eutranCellLdn, String cellFailureSlogan, Coordinator coordinator) throws RbsConfigurationFailedException {
        ManagedObject eutranCellMo;
        logger.traceEnter(THIS_CLASS, "createEUtranCell()");
        MoFactory eutranCellMoFactory = this.aFactoryMgr.lookup(eutranCellType);
        if (eutranCellMoFactory == null) {
            String msg = "Could not find the MO factory for " + eutranCellType + ".";
            throw new RbsConfigurationFailedException(cellFailureSlogan, msg);
        }
        ManagedObject enodebFunctionMo = this.moFinder.lookup(eutranCellType, "ManagedElement=1,ENodeBFunction=1", cellFailureSlogan);
        try {
            AttrListImpl attributeList = this.getAttributeList(cellData, eutranCellType, cellFailureSlogan, coordinator);
            eutranCellMo = eutranCellMoFactory.createMo(enodebFunctionMo, (AttrList)attributeList, cellData.cellId.toString(), null, coordinator);
            if (cellData.keepLocked != null && !"".equals(cellData.keepLocked) && "no".equalsIgnoreCase(cellData.keepLocked)) {
                RbsConfigurationUnlockHelper.getInstance().registerCreatedMo(eutranCellMo, coordinator);
            }
            this.configReportLogger.logAction(eutranCellLdn, "create", "cellId", cellData.cellId.toString());
        }
        catch (MoAccessException mae) {
            String msg = "Failed to create MO \"" + eutranCellLdn + "\".";
            throw new RbsConfigurationFailedException(cellFailureSlogan, msg, (Exception)((Object)mae));
        }
        catch (InactiveTransactionException ite) {
            String msg = "Failed to create MO \"" + eutranCellLdn + "\".";
            throw new RbsConfigurationFailedException(cellFailureSlogan, msg, (Exception)((Object)ite));
        }
        logger.traceReturn(THIS_CLASS, "createEUtranCell()");
        return eutranCellMo;
    }

    private void updateEUtranCellAttributes(GenericCellData cellData, String eutranCellType, String eutranCellLdn, ManagedObject eutranCellMo, String cellFailureSlogan, Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "updateEUtranCellAttributes()");
        String[] attributeNames = cellData.getAttributeNames();
        Object[] attributeValues = cellData.getAttributeValues();
        try {
            eutranCellMo.setAttributes(attributeNames, attributeValues, coordinator);
        }
        catch (MoAccessException mae) {
            String msg = "Failed to update attributes on MO \"" + eutranCellLdn + "\".";
            throw new RbsConfigurationFailedException(cellFailureSlogan, msg, (Exception)((Object)mae));
        }
        this.configReportLogger.logAttributes(eutranCellType, attributeNames, attributeValues);
        logger.traceReturn(THIS_CLASS, "updateEUtranCellAttributes()");
    }

    private AttrListImpl getAttributeList(GenericCellData cellData, String eutranCellType, String cellFailureSlogan, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributeList()");
        AttrListImpl attributeList = new AttrListImpl();
        ManagedObject sectorFunctionRefMo = this.moFinder.lookup(eutranCellType, "ManagedElement=1,SectorEquipmentFunction=" + cellData.sectorEquipmentFunctionId, cellFailureSlogan);
        if (sectorFunctionRefMo != null) {
            logger.traceDebug(THIS_CLASS, "sectorFunctionRefMo = " + sectorFunctionRefMo.getLocalDistinguishedName());
        }
        MoIterator moIter = this.aMoRepository.lookupType("SectorCarrier");
        ManagedObject sectorCarrierFound = null;
        if (moIter != null && moIter.hasMoreElements()) {
            while (moIter.hasMoreElements()) {
                ManagedObject sectorCarrierMo = moIter.nextMo();
                ManagedObject ref = null;
                try {
                    ref = (ManagedObject)sectorCarrierMo.getAttribute("sectorCarrierRef", null);
                }
                catch (NoSuchAttributeException e) {
                    logger.traceError(THIS_CLASS, "Failed to get attribute sectorCarrierRef");
                }
                catch (MoAccessException e) {
                    logger.traceError(THIS_CLASS, "Failed to get attribute sectorCarrierRef");
                }
                if (ref == null || !ref.equals(sectorFunctionRefMo)) continue;
                logger.traceDebug(THIS_CLASS, "Found SectorFunctionRef " + ref.toString());
                sectorCarrierFound = sectorCarrierMo;
                break;
            }
        }
        if (sectorCarrierFound == null) {
            sectorCarrierFound = this.createSectorCarrier(cellData, eutranCellType, coordinator, sectorFunctionRefMo);
        }
        this.setGenericCellDataAttributes(cellData, sectorCarrierFound, attributeList);
        if (this.isCellDataOffFddType(cellData)) {
            this.setCellDataFddAttributes(cellData, attributeList);
        } else {
            this.setCellDataTddAttributes(cellData, attributeList);
        }
        logger.traceReturn(THIS_CLASS, "getAttributeList()");
        return attributeList;
    }

    private ManagedObject createSectorCarrier(GenericCellData cellData, String eutranCellType, Coordinator coordinator, ManagedObject sectorFunctionRefMo) throws RbsConfigurationFailedException, ProcessingFailureException, MoAccessException {
        AttrListImpl sCattributeList = new AttrListImpl();
        sCattributeList.addElement("sectorFunctionRef", (Object)sectorFunctionRefMo);
        ManagedObject eNodeBFunctionMo = this.moFinder.lookup(eutranCellType, "ManagedElement=1,ENodeBFunction=1", "Failed to find EnodeBFunction");
        if (eNodeBFunctionMo == null) {
            logger.traceDebug(THIS_CLASS, "No eNodeBFunctionMo found");
            throw new ProcessingFailureException("No eNodeBFunctionMo found");
        }
        logger.traceDebug(THIS_CLASS, "eNodeBFunctionMo = " + eNodeBFunctionMo.getLocalDistinguishedName());
        MoFactory sectorCarrierMoFactory = this.aFactoryMgr.lookup("SectorCarrier");
        ManagedObject sectorCarrierFound = sectorCarrierMoFactory.createMo(eNodeBFunctionMo, (AttrList)sCattributeList, cellData.cellId.toString(), null, coordinator);
        logger.traceDebug(THIS_CLASS, "Created new SectorCarrier");
        return sectorCarrierFound;
    }

    private void setGenericCellDataAttributes(GenericCellData cellData, ManagedObject sectorCarrier, AttrListImpl attributeList) {
        attributeList.addElement("cellId", (Object)cellData.cellId);
        attributeList.addElement("physicalLayerCellIdGroup", (Object)cellData.physicalLayerCellIdGroup);
        attributeList.addElement("physicalLayerSubCellId", (Object)cellData.physicalLayerSubCellId);
        attributeList.addElement("tac", (Object)cellData.tac);
        ManagedObject[] sectorCarrierRef = new ManagedObject[]{sectorCarrier};
        attributeList.addElement("sectorCarrierRef", (Object)sectorCarrierRef);
    }

    private void setCellDataFddAttributes(GenericCellData cellData, AttrListImpl attributeList) {
        attributeList.addElement("earfcndl", (Object)((CellDataFdd)cellData).earfcndl);
        attributeList.addElement("earfcnul", (Object)((CellDataFdd)cellData).earfcnul);
        attributeList.addElement("dlChannelBandwidth", (Object)((CellDataFdd)cellData).dlChannelBandwidth);
        attributeList.addElement("ulChannelBandwidth", (Object)((CellDataFdd)cellData).ulChannelBandwidth);
    }

    private void setCellDataTddAttributes(GenericCellData cellData, AttrListImpl attributeList) {
        attributeList.addElement("earfcn", (Object)((CellDataTdd)cellData).earfcn);
        attributeList.addElement("channelBandwidth", (Object)((CellDataTdd)cellData).channelBandwidth);
        attributeList.addElement("frameStartOffset", (Object)((CellDataTdd)cellData).frameStartOffset);
        attributeList.addElement("subframeAssignment", (Object)((CellDataTdd)cellData).subframeAssignment);
        attributeList.addElement("specialSubframePattern", (Object)((CellDataTdd)cellData).specialSubframePattern);
    }
}

