/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.npc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.helpers.AttributesImpl;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.ParserHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.CellDataFdd;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.CellDataTdd;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.CellRelationData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.GenericCellData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.NpcConfigData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.npc.datastructure.TransportNetworkData;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.xml.Parser;
import se.ericsson.crbs.omf.mao.xml.XMLElement;

public class RbsConfigurationNpcParser {
    private static final Class THIS_CLASS = RbsConfigurationNpcParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected String schemaPath = "rbsManagerMetaData/rbsConfiguration/";
    private static final String[] frame_start_offset_names = new String[]{"subFrameOffset", "timeOffset"};
    private final Map xmlTagsMap = new HashMap();

    public NpcConfigData parseNpcProductionConfigFile(String filePath, boolean validateXml) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNpcProductionConfigFile() - filePath = " + filePath + ", validate = " + validateXml);
        Parser parser = ParserHelper.createParser(filePath, validateXml, this.schemaPath);
        TransportNetworkData transportNetworkData = null;
        List<GenericCellData> cellDataList = new ArrayList();
        ArrayList<CellRelationData> cellRelationDataList = new ArrayList<CellRelationData>();
        List xmlList = parser.getXMLelements();
        if (xmlList == null) {
            throw new IOException("Could not parse Npc Production Config file, invalid XML.");
        }
        Iterator xmlIter = xmlList.iterator();
        while (xmlIter.hasNext()) {
            XMLElement xmlChild = (XMLElement)xmlIter.next();
            String xmlNpcConfigChildType = xmlChild.getType();
            if ("TransportNetwork".equalsIgnoreCase(xmlNpcConfigChildType)) {
                transportNetworkData = this.parseNpcTransportNetwork(xmlChild);
                continue;
            }
            if ("Cells".equalsIgnoreCase(xmlNpcConfigChildType)) {
                cellDataList = this.parseNpcCells(xmlChild.getChildren());
                continue;
            }
            if ("CellData".equalsIgnoreCase(xmlNpcConfigChildType)) {
                GenericCellData cellData = this.parseNpcCellDataFdd(xmlChild);
                cellDataList.add(cellData);
                continue;
            }
            if (!"CellRelation".equalsIgnoreCase(xmlNpcConfigChildType)) continue;
            CellRelationData cellRelationData = this.parseNpcCellRelation(xmlChild);
            cellRelationDataList.add(cellRelationData);
        }
        GenericCellData[] cellDataArr = this.checkCellDataAndTransportNetworkData(cellDataList, transportNetworkData);
        boolean fddType = false;
        CellRelationData[] cellRelationDataArr = null;
        if (cellDataArr != null && cellDataArr.length > 0) {
            fddType = cellDataArr[0] instanceof CellDataFdd;
            cellRelationDataArr = this.checkCellRelationData(cellRelationDataList);
        }
        logger.traceReturn(THIS_CLASS, "parseNpcProductionConfigFile()");
        return new NpcConfigData(transportNetworkData, cellDataArr, cellRelationDataArr, fddType);
    }

    private CellRelationData[] checkCellRelationData(List cellRelationDataList) {
        CellRelationData[] cellRelationDataArr = null;
        if (!cellRelationDataList.isEmpty()) {
            cellRelationDataArr = new CellRelationData[cellRelationDataList.size()];
            cellRelationDataList.toArray(cellRelationDataArr);
        }
        return cellRelationDataArr;
    }

    private GenericCellData[] checkCellDataAndTransportNetworkData(List cellDataList, TransportNetworkData transportNetworkData) throws IOException {
        if (transportNetworkData == null && !cellDataList.isEmpty()) {
            throw new IOException("Invalid NPC Configuration file: TransportNetwork is missing.");
        }
        if (cellDataList.isEmpty() && transportNetworkData != null) {
            throw new IOException("Invalid NPC Configuration file: CellDataFDD or CellDataTDD is missing.");
        }
        GenericCellData[] cellDataArr = null;
        if (!cellDataList.isEmpty()) {
            cellDataArr = new GenericCellData[cellDataList.size()];
            cellDataList.toArray(cellDataArr);
        }
        return cellDataArr;
    }

    private TransportNetworkData parseNpcTransportNetwork(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNpcTransportNetwork");
        this.putAttributesInXmlTagsMap(xmlElement);
        String ipAddress = this.getXmlTagString("ipAddress");
        String defaultRouter = this.getXmlTagString("defaultRouter");
        String subnetworkMask = this.getXmlTagString("subnetworkMask");
        String eNBId = this.getXmlTagString("eNBId");
        String eNBPlmnId = this.getXmlTagString("eNBPlmnId");
        String mmeIpAddress = this.getXmlTagString("mmeIpAddress");
        String domainName = this.getXmlTagString("domainName");
        logger.traceReturn(THIS_CLASS, "parseNpcTransportNetwork");
        return new TransportNetworkData(ipAddress, defaultRouter, subnetworkMask, eNBId, eNBPlmnId, mmeIpAddress, domainName);
    }

    private List parseNpcCells(List xmlElements) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNpcCells");
        ArrayList<GenericCellData> cellDataList = new ArrayList<GenericCellData>();
        if (xmlElements == null) {
            throw new IOException("Could not parse Npc Production Config file, invalid XML.");
        }
        Iterator xmlIter = xmlElements.iterator();
        while (xmlIter.hasNext()) {
            GenericCellData cellData;
            XMLElement xmlChild = (XMLElement)xmlIter.next();
            String xmlNpcConfigChildType = xmlChild.getType();
            if ("CellDataFDD".equalsIgnoreCase(xmlNpcConfigChildType)) {
                cellData = this.parseNpcCellDataFdd(xmlChild);
                cellDataList.add(cellData);
                continue;
            }
            if (!"CellDataTDD".equalsIgnoreCase(xmlNpcConfigChildType)) continue;
            cellData = this.parseNpcCellDataTdd(xmlChild);
            cellDataList.add(cellData);
        }
        logger.traceReturn(THIS_CLASS, "parseNpcCells");
        return cellDataList;
    }

    private GenericCellData parseNpcGenericCellData(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNpcGenericCellData");
        this.putAttributesInXmlTagsMap(xmlElement);
        String cellId = this.getXmlTagString("cellId");
        String physicalLayerCellIdGroup = this.getXmlTagString("physicalLayerCellIdGroup");
        String physicalLayerSubCellId = this.getXmlTagString("physicalLayerSubCellId");
        String sectorEquipmentFunctionId = this.getXmlTagString("sectorEquipmentFunctionId");
        String tac = this.getXmlTagString("tac");
        String keepLocked = this.getXmlTagString("keepLocked");
        ParserHelper.checkMandatoryAttribute((String)"cellId", (String)cellId);
        ParserHelper.checkMandatoryAttribute((String)"physicalLayerCellIdGroup", (String)physicalLayerCellIdGroup);
        ParserHelper.checkMandatoryAttribute((String)"physicalLayerSubCellId", (String)physicalLayerSubCellId);
        ParserHelper.checkMandatoryAttribute((String)"sectorEquipmentFunctionId", (String)sectorEquipmentFunctionId);
        ParserHelper.checkMandatoryAttribute((String)"tac", (String)tac);
        logger.traceReturn(THIS_CLASS, "parseNpcGenericCellData");
        return new GenericCellData(new Integer(cellId), new Integer(physicalLayerCellIdGroup), new Integer(physicalLayerSubCellId), sectorEquipmentFunctionId, new Integer(tac), keepLocked);
    }

    private GenericCellData parseNpcCellDataFdd(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNpcCellDataFdd");
        GenericCellData genericCellData = this.parseNpcGenericCellData(xmlElement);
        this.putAttributesInXmlTagsMap(xmlElement);
        String earfCnDl = this.getXmlTagString("earfcndl");
        String earfCnUl = this.getXmlTagString("earfcnul");
        String dlChannelBandwidth = this.getXmlTagString("dlChannelBandwidth");
        String ulChannelBandwidth = this.getXmlTagString("ulChannelBandwidth");
        ParserHelper.checkMandatoryAttribute((String)"earfcndl", (String)earfCnDl);
        ParserHelper.checkMandatoryAttribute((String)"earfcnul", (String)earfCnUl);
        logger.traceReturn(THIS_CLASS, "parseNpcCellDataFdd");
        return new CellDataFdd(genericCellData.cellId, genericCellData.physicalLayerCellIdGroup, genericCellData.physicalLayerSubCellId, genericCellData.sectorEquipmentFunctionId, genericCellData.tac, genericCellData.keepLocked, new Integer(earfCnDl), new Integer(earfCnUl), new Integer(dlChannelBandwidth), new Integer(ulChannelBandwidth));
    }

    private GenericCellData parseNpcCellDataTdd(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNpcCellDataTdd");
        GenericCellData genericCellData = this.parseNpcGenericCellData(xmlElement);
        StructImpl frameStartOffset = null;
        this.putAttributesInXmlTagsMap(xmlElement);
        String earfcn = this.getXmlTagString("earfcn");
        String channelBandwidth = this.getXmlTagString("channelBandwidth");
        String frameStartOffsetString = this.getXmlTagString("frameStartOffset");
        String subframeAssignment = this.getXmlTagString("subframeAssignment");
        String specialSubframePattern = this.getXmlTagString("specialSubframePattern");
        ParserHelper.checkMandatoryAttribute((String)"earfcn", (String)earfcn);
        ParserHelper.checkMandatoryAttribute((String)"frameStartOffset", (String)frameStartOffsetString);
        ParserHelper.checkMandatoryAttribute((String)"subframeAssignment", (String)subframeAssignment);
        if (frameStartOffsetString.length() < 2) {
            throw new IOException("Invalid NPC Configuration file: frameStartOffset must contain at least two digits.");
        }
        try {
            Object[] values = new Integer[]{new Integer(frameStartOffsetString.substring(0, 1)), new Integer(frameStartOffsetString.substring(1))};
            frameStartOffset = new StructImpl(frame_start_offset_names, values);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Invalid NPC Configuration file: frameStartOffset is not a number.");
        }
        logger.traceReturn(THIS_CLASS, "parseNpcCellDataTdd");
        return new CellDataTdd(genericCellData.cellId, genericCellData.physicalLayerCellIdGroup, genericCellData.physicalLayerSubCellId, genericCellData.sectorEquipmentFunctionId, genericCellData.tac, genericCellData.keepLocked, new Integer(earfcn), new Integer(channelBandwidth), (Struct)frameStartOffset, new Integer(subframeAssignment), new Integer(specialSubframePattern));
    }

    private CellRelationData parseNpcCellRelation(XMLElement xmlElement) throws IOException {
        logger.traceEnter(THIS_CLASS, "parseNpcCellRelation");
        this.putAttributesInXmlTagsMap(xmlElement);
        String fromCellId = this.getXmlTagString("fromCellId");
        String toCellId = this.getXmlTagString("toCellId");
        if (fromCellId == null) {
            throw new IOException("Invalid NPC Configuration file: fromCellId is missing.");
        }
        if (toCellId == null) {
            throw new IOException("Invalid NPC Configuration file: toCellId is missing.");
        }
        logger.traceReturn(THIS_CLASS, "parseNpcCellRelation");
        return new CellRelationData(fromCellId, toCellId);
    }

    private void putAttributesInXmlTagsMap(XMLElement xmlElement) {
        AttributesImpl attributes = xmlElement.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            String qualifiedName = attributes.getQName(index);
            String valueStr = attributes.getValue(index);
            this.xmlTagsMap.put(qualifiedName, valueStr);
        }
    }

    private String getXmlTagString(String tagName) {
        String xmlString = null;
        if (this.xmlTagsMap.containsKey(tagName)) {
            xmlString = StringHelper.emptyStringToNull((String)this.xmlTagsMap.get(tagName).toString());
        }
        return xmlString;
    }
}

