/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.oss;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.security.SecurityMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.SingleInstanceFinder;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class OssInformerHelper {
    private static final Class THIS_CLASS = OssInformerHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationHelper helper;
    private final MoRepositoryWrapper moRepository;
    private final boolean ipv6;

    public OssInformerHelper(RbsConfigurationHelper helperIn, MoRepositoryWrapper moRepositoryIn, boolean isIpv6) {
        this.helper = helperIn;
        this.moRepository = moRepositoryIn;
        this.ipv6 = isIpv6;
    }

    public String getOssAddress() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getOssAddress()");
        RbsConfigurationMao rbsConfiguration = SingleInstanceFinder.getRbsConfigurationInstance(this.moRepository);
        String address = (String)rbsConfiguration.getAttribute("ossCorbaNameServiceAddress");
        logger.traceReturn(THIS_CLASS, "getOssAddress() - " + address);
        return address;
    }

    public String getOssNodeDiscoveryServiceName() {
        logger.traceEnter(THIS_CLASS, "getOssNodeDiscoveryServiceName()");
        String name = "com/ericsson/nms/umts/ranos/WmaNodeDiscoveryUnsecure";
        if (this.isCorbaSecure()) {
            name = "com/ericsson/nms/umts/ranos/WmaNodeDiscovery";
        }
        logger.traceReturn(THIS_CLASS, "getOssNodeDiscoveryServiceName() - " + name);
        return name;
    }

    public String getOssNodeIpAddressChangeServiceName() {
        logger.traceEnter(THIS_CLASS, "getOssNodeIpAddressChangeServiceName()");
        String name = "com/ericsson/nms/umts/ranos/WmaNodeIpChangeUnsecure";
        if (this.isCorbaSecure()) {
            name = "com/ericsson/nms/umts/ranos/WmaNodeIpChange";
        }
        logger.traceReturn(THIS_CLASS, "getOssNodeIpAddressChangeServiceName() - " + name);
        return name;
    }

    public String getOssNodeSecurityIntegrationServiceName(String ipAddress) {
        logger.traceEnter(THIS_CLASS, "getOssNodeSecurityIntegrationServiceName(): ipAddress=" + ipAddress);
        String name = "com/ericsson/nms/umts/ranos/WmaNodeSecurity";
        if (!this.isCorbaSecure()) {
            name = "com/ericsson/nms/umts/ranos/WmaNodeSecurityUnsecure";
        }
        try {
            InetAddress[] ipAddresses = InetAddress.getAllByName(ipAddress);
            for (int j = 0; j < ipAddresses.length; ++j) {
                if (!this.ipv6 || !(ipAddresses[j] instanceof Inet6Address)) continue;
                name = name + "V6";
                break;
            }
        }
        catch (UnknownHostException e) {
            logger.traceError(THIS_CLASS, "Illegal ip address: " + ipAddress);
        }
        logger.traceReturn(THIS_CLASS, "getOssNodeSecurityIntegrationServiceName() - " + name);
        return name;
    }

    public boolean isCorbaSecure() {
        boolean securityActive = false;
        try {
            SecurityMo securityMo = (SecurityMo)this.moRepository.lookup("ManagedElement=1,SystemFunctions=1,Security=1");
            securityActive = securityMo != null && securityMo.getCorbaSecurityActive(null);
        }
        catch (MoAccessException mae) {
            this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "MO Operation failure", "Failed to retrieve the current security on the Corba Interface.");
        }
        return securityActive;
    }
}

