/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange;

import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChange;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.NodeIpAddressChangeHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.OssNodeIpAddressChangedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.ipaddresschange.OssNodeIpAddressChangedResolver;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.OrbCreatorFactory;

public class OssNodeIpAddressChangedResolverImpl
implements OssNodeIpAddressChangedResolver {
    private static final Class THIS_CLASS = OssNodeIpAddressChangedResolverImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected final transient String currentNodeIpAddressChangedServiceName;
    protected final transient String currentNameServerAddress;
    protected final transient int currentNameServicePort;

    public OssNodeIpAddressChangedResolverImpl(String nameServerAddress, int nameServicePort, String nodeIpAddressChangedServiceName) {
        this.currentNameServerAddress = nameServerAddress;
        this.currentNameServicePort = nameServicePort;
        this.currentNodeIpAddressChangedServiceName = nodeIpAddressChangedServiceName;
    }

    public NodeIpAddressChange resolveNodeIpAddressChange() throws OssNodeIpAddressChangedException {
        String nameServiceLocation = "";
        NodeIpAddressChange nodeIpAddressChange = null;
        try {
            ORB cppOrb = OssNodeIpAddressChangedResolverImpl.getOrb();
            nameServiceLocation = "corbaloc::" + this.currentNameServerAddress + ":" + this.currentNameServicePort + "/NameService";
            Object nsObj = this.getNodeServiceObject(cppOrb, nameServiceLocation);
            nodeIpAddressChange = NodeIpAddressChangeHelper.narrow(nsObj);
            logger.traceDebug(THIS_CLASS, "Successfully narrowed the interface to: " + nodeIpAddressChange);
        }
        catch (OssNodeIpAddressChangedException onde) {
            throw onde;
        }
        catch (Exception e) {
            String errorMsg = "Could not resolve interface " + this.currentNodeIpAddressChangedServiceName + ", from name service, " + this.currentNameServerAddress + ":" + this.currentNameServicePort;
            if (!nameServiceLocation.equals("")) {
                errorMsg = errorMsg + ": " + nameServiceLocation;
            }
            throw new OssNodeIpAddressChangedException(errorMsg, e);
        }
        return nodeIpAddressChange;
    }

    public static ORB getOrb() throws OssNodeIpAddressChangedException {
        boolean orbUp = false;
        ORB cppOrb = null;
        while (!orbUp) {
            cppOrb = OrbCreatorFactory.getInstance().getOrbCreator().getOrb();
            if (cppOrb == null) {
                String errorMsg = "Could not get reference to CppOrb";
                logger.traceError(THIS_CLASS, "getOrb(): Could not get reference to CppOrb");
                throw new OssNodeIpAddressChangedException("Could not get reference to CppOrb");
            }
            try {
                cppOrb.work_pending();
                orbUp = true;
            }
            catch (BAD_INV_ORDER orbDownException) {
                logger.traceDebug(THIS_CLASS, "The CPP Orb is currently down, waiting for restart.");
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interrupted) {
                    logger.traceDebug(THIS_CLASS, "Interrupted while waiting for CPP Orb to come alive.");
                }
            }
        }
        return cppOrb;
    }

    private Object getNodeServiceObject(ORB cppOrb, String nameServiceLocation) throws OssNodeIpAddressChangedException, NotFound, CannotProceed, InvalidName {
        NamingContextExt rootNc;
        NamingContextExt rootNcExt;
        try {
            Object nsRootContext = cppOrb.string_to_object(nameServiceLocation);
            rootNc = rootNcExt = NamingContextExtHelper.narrow((Object)nsRootContext);
        }
        catch (Exception exc) {
            String errorMsg = "Could not connect to name service, " + this.currentNameServerAddress + ":" + this.currentNameServicePort;
            if (!nameServiceLocation.equals("")) {
                errorMsg = errorMsg + ": " + nameServiceLocation;
            }
            throw new OssNodeIpAddressChangedException(errorMsg, exc);
        }
        return rootNc.resolve(rootNcExt.to_name(this.currentNodeIpAddressChangedServiceName));
    }
}

