/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeDiscovery;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeDiscoveryHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeSecurityIntegration;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.NodeSecurityIntegrationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.oss.nodediscover.OssNodeDiscoveryResolver;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.OrbCreatorFactory;

public class OssNodeDiscoveryResolverImpl
implements OssNodeDiscoveryResolver {
    private static final Class THIS_CLASS = OssNodeDiscoveryResolverImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected final transient String currentNodeDiscoveryServiceName;
    protected final transient String currentNameServerAddress;
    protected final transient int currentNameServicePort;
    protected final transient boolean ipv6;

    public OssNodeDiscoveryResolverImpl(String nameServerAddress, int nameServicePort, String nodeDiscoveryServiceName, boolean isIpv6) {
        this.currentNameServerAddress = nameServerAddress;
        this.currentNameServicePort = nameServicePort;
        this.currentNodeDiscoveryServiceName = nodeDiscoveryServiceName;
        this.ipv6 = isIpv6;
    }

    public NodeDiscovery resolveNodeDiscovery() throws OssNodeDiscoveryException {
        logger.traceEnter(THIS_CLASS, "resolveNodeDiscovery()");
        String nameServiceLocation = this.getNameServiceLocation();
        NodeDiscovery nodeDiscovery = null;
        try {
            Object nsObj = this.getNodeServiceObject(nameServiceLocation);
            nodeDiscovery = NodeDiscoveryHelper.narrow(nsObj);
        }
        catch (OssNodeDiscoveryException onde) {
            throw onde;
        }
        catch (Exception e) {
            String errorMsg = "Could not resolve interface " + this.currentNodeDiscoveryServiceName + ", from name service, " + this.currentNameServerAddress + ":" + this.currentNameServicePort + ": " + nameServiceLocation;
            throw new OssNodeDiscoveryException(errorMsg, e);
        }
        logger.traceReturn(THIS_CLASS, "resolveNodeDiscovery()");
        return nodeDiscovery;
    }

    public void verifyOssConnectivity() throws NotFound, CannotProceed, InvalidName, OssNodeDiscoveryException {
        this.getNodeServiceObject(this.getNameServiceLocation());
    }

    public NodeSecurityIntegration resolveNodeSecurityIntegration() throws OssNodeDiscoveryException {
        logger.traceEnter(THIS_CLASS, "resolveNodeSecurityIntegration()");
        String nameServiceLocation = this.getNameServiceLocation();
        NodeSecurityIntegration nodeSecurityIntegration = null;
        try {
            Object nsObj = this.getNodeServiceObject(nameServiceLocation);
            nodeSecurityIntegration = NodeSecurityIntegrationHelper.narrow(nsObj);
        }
        catch (OssNodeDiscoveryException onde) {
            throw onde;
        }
        catch (Exception e) {
            String errorMsg = "Could not resolve interface " + this.currentNodeDiscoveryServiceName + ", from name service, " + this.currentNameServerAddress + ":" + this.currentNameServicePort + ": " + nameServiceLocation;
            throw new OssNodeDiscoveryException(errorMsg, e);
        }
        logger.traceReturn(THIS_CLASS, "resolveNodeSecurityIntegration()");
        return nodeSecurityIntegration;
    }

    private String getNameServiceLocation() throws OssNodeDiscoveryException {
        logger.traceEnter(THIS_CLASS, "getNameServiceLocation()");
        String currentNameServiceLocation = "";
        try {
            InetAddress[] inetArray = InetAddress.getAllByName(this.currentNameServerAddress);
            InetAddress inet = null;
            InetAddress firstResolvedAddress = inetArray.length > 0 ? inetArray[0] : null;
            for (int i = 0; i < inetArray.length; ++i) {
                if (this.ipv6 && inetArray[i] instanceof Inet6Address) {
                    inet = inetArray[i];
                    break;
                }
                if (this.ipv6 || !(inetArray[i] instanceof Inet4Address)) continue;
                inet = inetArray[i];
                break;
            }
            currentNameServiceLocation = inet instanceof Inet6Address ? "corbaloc:iiop:1.2@[" + inet.getHostAddress() + "]:" + this.currentNameServicePort + "/NameService" : (inet instanceof Inet4Address ? "corbaloc::" + inet.getHostAddress() + ":" + this.currentNameServicePort + "/NameService" : (firstResolvedAddress instanceof Inet6Address ? "corbaloc:iiop:1.2@[" + this.currentNameServerAddress + "]:" + this.currentNameServicePort + "/NameService" : "corbaloc::" + this.currentNameServerAddress + ":" + this.currentNameServicePort + "/NameService"));
        }
        catch (UnknownHostException e) {
            String errorMsg = "Failure! Could not resolve Name Server Address:" + this.currentNameServerAddress;
            throw new OssNodeDiscoveryException(errorMsg, e);
        }
        logger.traceReturn(THIS_CLASS, "getNameServiceLocation()");
        return currentNameServiceLocation;
    }

    public String getNSLocation() throws OssNodeDiscoveryException {
        return this.getNameServiceLocation();
    }

    private ORB getOrb() throws OssNodeDiscoveryException {
        boolean orbUp = false;
        ORB cppOrb = null;
        while (!orbUp) {
            cppOrb = OrbCreatorFactory.getInstance().getOrbCreator().getOrb();
            if (cppOrb == null) {
                String errorMsg = "Could not get reference to CppOrb";
                logger.traceError(THIS_CLASS, "getOrb(): Could not get reference to CppOrb");
                throw new OssNodeDiscoveryException("Could not get reference to CppOrb");
            }
            try {
                cppOrb.work_pending();
                orbUp = true;
            }
            catch (BAD_INV_ORDER orbDownException) {
                logger.traceDebug(THIS_CLASS, "The CPP Orb is currently down, waiting for restart.");
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interrupted) {
                    logger.traceDebug(THIS_CLASS, "Interrupted while waiting for CPP Orb to come alive.");
                }
            }
        }
        return cppOrb;
    }

    private Object getNodeServiceObject(String nameServiceLocation) throws OssNodeDiscoveryException, NotFound, CannotProceed, InvalidName {
        NamingContextExt rootNcExt;
        logger.traceEnter(THIS_CLASS, "getNodeServiceObject()");
        ORB cppOrb = this.getOrb();
        Object nsRootContext = cppOrb.string_to_object(nameServiceLocation);
        NamingContextExt rootNc = rootNcExt = NamingContextExtHelper.narrow((Object)nsRootContext);
        logger.traceReturn(THIS_CLASS, "getNodeServiceObject()");
        return rootNc.resolve(rootNcExt.to_name(this.currentNodeDiscoveryServiceName));
    }
}

