/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class InnerIpConfigurationData
extends AbstractParameters {
    private static final Class THIS_CLASS = InnerIpConfigurationData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    static final String INNER_DNS_SERVER = "InnerDnsServer";
    static final String INNER_IP_ADDRESS = "ipAddress";
    private static final String[] parameters = new String[]{"InnerDnsServer", "ipAddress"};
    private static final Object INSTANCE_MUTEX = new Object();
    private static InnerIpConfigurationData instance;

    protected InnerIpConfigurationData(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized InnerIpConfigurationData instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new InnerIpConfigurationData(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static InnerIpConfigurationData instance() {
        return instance;
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            instance = null;
        }
    }

    public String getInnerDnsServer() {
        return this.getParameter(INNER_DNS_SERVER);
    }

    public void setInnerDnsServer(String internalDnsServer) {
        this.setParameter(INNER_DNS_SERVER, internalDnsServer);
    }

    public String getInnerIpAddress() {
        return this.getParameter(INNER_IP_ADDRESS);
    }

    public void setInnerIpAddress(String innerIPAddress) {
        this.setParameter(INNER_IP_ADDRESS, innerIPAddress);
    }
}

