/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class NodeParameters
extends AbstractParameters {
    private static final Class THIS_CLASS = NodeParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String DHCP_CLIENT_IDENTIFIER = "DhcpClientIdentifier";
    protected static final String DHCP_CLIENT_IDENTIFIER_STARTING_WITH_LOWER_CASE = "dhcpClientIdentifier";
    protected static final String LOGICAL_NAME = "LogicalName";
    protected static final String LOGICAL_NAME_STARTING_WITH_LOWER_CASE = "logicalName";
    protected static final String UNIQUE_LOGICAL_NAME = "UniqueLogicalName";
    protected static final String CLIENT_UTC_TIME = "ClientUtcTime";
    private static final String[] parameters = new String[]{"DhcpClientIdentifier", "LogicalName", "UniqueLogicalName", "ClientUtcTime"};
    private static final Object INSTANCE_MUTEX = new Object();
    private static NodeParameters instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized NodeParameters instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new NodeParameters(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static NodeParameters instance() {
        return instance;
    }

    private NodeParameters(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            instance = null;
        }
    }

    public String getDhcpClientIdentifier() {
        return this.getParameter(DHCP_CLIENT_IDENTIFIER);
    }

    public void setDhcpClientIdentifier(String dhcpClientIdentifier) {
        this.setParameter(DHCP_CLIENT_IDENTIFIER, dhcpClientIdentifier);
    }

    public String correctParameterNames(Coordinator coordinator) {
        String params = this.correctParameterName(LOGICAL_NAME, new String[]{LOGICAL_NAME_STARTING_WITH_LOWER_CASE}, coordinator);
        params = "," + this.correctParameterName(DHCP_CLIENT_IDENTIFIER, new String[]{DHCP_CLIENT_IDENTIFIER_STARTING_WITH_LOWER_CASE}, coordinator);
        return params;
    }

    public String getLogicalName() {
        return this.getParameter(LOGICAL_NAME);
    }

    public void setLogicalName(String logicalName) {
        this.setParameter(LOGICAL_NAME, logicalName);
    }

    public String getUniqueLogicalName() {
        return this.getParameter(UNIQUE_LOGICAL_NAME);
    }

    public void setUniqueLogicalName(String uniqueLogicalName) {
        this.setParameter(UNIQUE_LOGICAL_NAME, uniqueLogicalName);
    }

    public String getClientUtcTime() {
        return this.getParameter(CLIENT_UTC_TIME);
    }

    public void setClientUtcTime(String clientUtcTime) {
        this.setParameter(CLIENT_UTC_TIME, clientUtcTime);
    }
}

