/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class OuterIpConfigurationData
extends AbstractParameters {
    private static final Class THIS_CLASS = OuterIpConfigurationData.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    static final String OUTER_DNS_SERVER = "outerDnsServer";
    static final String INITIAL_SECGW_IP_ADD = "SecGwIpAdd";
    static final String INITIAL_SECGW_FQDN = "SecGwFqdn";
    static final String OUTER_IP_ADDRESS = "outerIpAddress";
    static final String OUTER_SUBNET_MASK = "outerSubnetMask";
    static final String OUTER_DEFAULT_ROUTER_ZERO = "outerDefaultRouter0";
    private static final String[] parameters = new String[]{"outerDnsServer", "SecGwIpAdd", "SecGwFqdn", "outerIpAddress", "outerSubnetMask", "outerDefaultRouter0"};
    private static final Object INSTANCE_MUTEX = new Object();
    private static OuterIpConfigurationData instance;

    protected OuterIpConfigurationData(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OuterIpConfigurationData instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new OuterIpConfigurationData(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static OuterIpConfigurationData instance() {
        return instance;
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            instance = null;
        }
    }

    public String getOuterDnsServer() {
        return this.getParameter(OUTER_DNS_SERVER);
    }

    public void setOuterDnsServer(String dnsServer) {
        this.setParameter(OUTER_DNS_SERVER, dnsServer);
    }

    public String getInitialSecGwIpAdd() {
        return this.getParameter(INITIAL_SECGW_IP_ADD);
    }

    public void setInitialSecGwIpAdd(String initialIpAdd) {
        this.setParameter(INITIAL_SECGW_IP_ADD, initialIpAdd);
    }

    public String getInitialSecGwFqdn() {
        return this.getParameter(INITIAL_SECGW_FQDN);
    }

    public void setInitialSecGwFqdn(String initialFqdn) {
        this.setParameter(INITIAL_SECGW_FQDN, initialFqdn);
    }

    public String getOuterIpAddress() {
        return this.getParameter(OUTER_IP_ADDRESS);
    }

    public boolean isOuterEmpty() {
        return OuterIpConfigurationData.isEmpty(this.getParameter(OUTER_IP_ADDRESS)) || OuterIpConfigurationData.isEmpty(this.getParameter(OUTER_SUBNET_MASK)) || OuterIpConfigurationData.isEmpty(this.getParameter(OUTER_DEFAULT_ROUTER_ZERO));
    }

    public void setOuterIpAddress(String ipAddress) {
        this.setParameter(OUTER_IP_ADDRESS, ipAddress);
    }

    public String getOuterSubnetMask() {
        return this.getParameter(OUTER_SUBNET_MASK);
    }

    public void setOuterSubnetMask(String subnetMask) {
        this.setParameter(OUTER_SUBNET_MASK, subnetMask);
    }

    public String getOuterDefaultRouterZero() {
        return this.getParameter(OUTER_DEFAULT_ROUTER_ZERO);
    }

    public void setOuterDefaultRouterZero(String defaultRouterZero) {
        this.setParameter(OUTER_DEFAULT_ROUTER_ZERO, defaultRouterZero);
    }
}

