/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ScenarioParameters
extends AbstractParameters {
    private static final Class THIS_CLASS = ScenarioParameters.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String WITH_GUI_SCENARIO = "withGuiScenario";
    private static final String[] parameters = new String[]{"withGuiScenario"};
    private static final Object INSTANCE_MUTEX = new Object();
    private static ScenarioParameters instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ScenarioParameters instance(RbsConfigurationMao rbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new ScenarioParameters(rbsConfigurationMao);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static ScenarioParameters instance() {
        return instance;
    }

    private ScenarioParameters(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, parameters);
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            instance = null;
        }
    }

    public int getWithGuiScenario() {
        String scenario = this.getParameter(WITH_GUI_SCENARIO);
        if (RbsConfigurationHelper.existsAndNotEmpty(scenario)) {
            return Integer.parseInt(scenario);
        }
        return 0;
    }

    public void setWithGuiScenario(int scenario) {
        this.setParameter(WITH_GUI_SCENARIO, String.valueOf(scenario));
    }

    public void setWithGuiScenario(int scenario, Coordinator coordinator) {
        this.setParameter(WITH_GUI_SCENARIO, String.valueOf(scenario), coordinator);
    }
}

