/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.parameters;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.FqdnOrIpAddress;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.AbstractParameters;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class WebServerAddresses
extends AbstractParameters {
    private static final Class THIS_CLASS = WebServerAddresses.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String WEB_SERVER_ADDRESSES = "WebServerAddresses";
    private final String NEXT_ADDRESS_DELIMETER = "#";
    private static final Object INSTANCE_MUTEX = new Object();
    private static WebServerAddresses instance;
    private final Object MUTEX = new Object();
    private FqdnOrIpAddress[] webServerAddresses;
    private int nextWebServerAddress = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized WebServerAddresses instance(RbsConfigurationMao rbsConfigurationMaoIn) {
        logger.traceEnter(THIS_CLASS, "instance()");
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            if (instance == null) {
                instance = new WebServerAddresses(rbsConfigurationMaoIn);
            }
        }
        logger.traceReturn(THIS_CLASS, "instance()");
        return instance;
    }

    public static WebServerAddresses instance() {
        return instance;
    }

    private WebServerAddresses(RbsConfigurationMao rbsConfigurationMaoIn) {
        super(rbsConfigurationMaoIn, new String[0]);
        this.retrievePersistently();
    }

    public void delete() {
        this.delete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Coordinator coordinator) {
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            super.delete(coordinator);
            this.setWebServerAddresses(new FqdnOrIpAddress[0]);
            instance = null;
        }
    }

    public String toString() {
        return "WebServerAddresses=" + this.toStringInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebServerAddresses(FqdnOrIpAddress[] webServerAddressesIn) {
        logger.traceEnter(THIS_CLASS, "setWebServerAddresses(FqdnOrIpAddress[])");
        Object object = this.MUTEX;
        synchronized (object) {
            this.webServerAddresses = webServerAddressesIn == null ? new FqdnOrIpAddress[]{} : webServerAddressesIn;
            this.nextWebServerAddress = 0;
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "setWebServerAddresses(FqdnOrIpAddress[])");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebServerAddresses(int[] addresses) {
        logger.traceEnter(THIS_CLASS, "setWebServerAddresses()");
        int nbrOfAddresses = addresses.length / 4;
        Object object = this.MUTEX;
        synchronized (object) {
            this.webServerAddresses = new FqdnOrIpAddress[nbrOfAddresses];
            for (int a = 0; a < nbrOfAddresses; ++a) {
                StringBuffer ab = new StringBuffer();
                for (int b = 0; b < 4; ++b) {
                    ab.append((b == 0 ? "" : ".") + addresses[a * 4 + b]);
                }
                this.webServerAddresses[a] = new FqdnOrIpAddress(0, ab.toString());
            }
            this.nextWebServerAddress = 0;
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "setWebServerAddresses()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setParameter(String paramName, String paramValue) {
        logger.traceEnter(THIS_CLASS, "setParameter() " + paramName + "=\"" + paramValue + "\"");
        boolean result2 = false;
        Object object = this.MUTEX;
        synchronized (object) {
            if (WEB_SERVER_ADDRESSES.equals(paramName)) {
                this.setWebServerAddresses(FqdnOrIpAddress.split(paramValue));
                result2 = true;
            }
        }
        logger.traceReturn(THIS_CLASS, "setParameter()");
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FqdnOrIpAddress[] getWebServerAddresses() {
        Object object = this.MUTEX;
        synchronized (object) {
            return this.webServerAddresses;
        }
    }

    public boolean isEmpty() {
        FqdnOrIpAddress[] address = this.getWebServerAddresses();
        if (address.length > 0) {
            return address[0] == null || AbstractParameters.isEmpty(address[0].getAddressValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextWebServerAddress() {
        boolean result2;
        logger.traceEnter(THIS_CLASS, "hasNextWebServerAddress()");
        Object object = this.MUTEX;
        synchronized (object) {
            result2 = this.nextWebServerAddress < this.webServerAddresses.length;
        }
        logger.traceReturn(THIS_CLASS, "hasNextWebServerAddress() " + result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FqdnOrIpAddress getNextWebServerAddress() throws MoAccessException {
        FqdnOrIpAddress result2;
        logger.traceEnter(THIS_CLASS, "getNextWebServerAddress()");
        Object object = this.MUTEX;
        synchronized (object) {
            if (!this.hasNextWebServerAddress()) {
                throw new RbsConfigurationFailedException("Internal error, there is no more webServerAddresses in list");
            }
            result2 = this.webServerAddresses[this.nextWebServerAddress++];
            this.storePersistently();
        }
        logger.traceReturn(THIS_CLASS, "getNextWebServerAddress() " + result2);
        return result2;
    }

    protected void retrievePersistently() {
        logger.traceEnter(THIS_CLASS, "retrievePersistently()");
        String webServAddrString = WebServerAddresses.notNull((String)this.rbsConfigurationMao.retrievePersistently(WEB_SERVER_ADDRESSES));
        if (webServAddrString != null && webServAddrString.trim().length() > 0) {
            int nextAddressIdDelimeterPos = webServAddrString.indexOf("#");
            this.webServerAddresses = FqdnOrIpAddress.split(webServAddrString.substring(0, nextAddressIdDelimeterPos), ",");
            this.nextWebServerAddress = Integer.parseInt(webServAddrString.substring(nextAddressIdDelimeterPos + 1));
        } else {
            this.webServerAddresses = new FqdnOrIpAddress[0];
        }
        logger.traceReturn(THIS_CLASS, "retrievePersistently() " + webServAddrString);
    }

    private void storePersistently() {
        logger.traceEnter(THIS_CLASS, "storePersistently()");
        StringBuffer webServAddrSb = new StringBuffer();
        if (this.webServerAddresses.length == 0) {
            this.rbsConfigurationMao.removeAdditionalAttribute(WEB_SERVER_ADDRESSES, null);
        } else {
            try {
                String asString = this.toStringInt();
                this.rbsConfigurationMao.storePersistently(WEB_SERVER_ADDRESSES, asString);
                logger.traceDebug(THIS_CLASS, "storePersistently() " + asString);
            }
            catch (MoAccessException hopfullyWontHappen) {
                logger.traceError(THIS_CLASS, "Failed to store WebServerAddresses=" + webServAddrSb.toString() + " persistently");
            }
        }
        logger.traceReturn(THIS_CLASS, "storePersistently()");
    }

    private String toStringInt() {
        StringBuffer webServAddrSb = new StringBuffer();
        for (int i = 0; i < this.webServerAddresses.length; ++i) {
            webServAddrSb.append((i == 0 ? "" : ",") + this.webServerAddresses[i]);
        }
        webServAddrSb.append("#" + this.nextWebServerAddress);
        return webServAddrSb.toString();
    }
}

