/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.mom.ConfigurationVersion;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.PersistentDataCleaner;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.log.LogHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.AbstractPostSetExecutor;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.FileLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IntegrationCompletePostSetExecutor
extends AbstractPostSetExecutor {
    private static final String UNLOCKING_OF_CELLS_NOT_PERFORMED = "Unlocking of cells not performed";
    private static final String ACTIVATION_OF_FEATURES_NOT_PERFORMED = "Activation of features not performed";
    public static final String OSS_IS_DONE_FINISHING_RBS_CONFIGURATION = "OSS is done finishing RBS configuration";
    private static final Class THIS_CLASS = IntegrationCompletePostSetExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final FileLogger progressReportFileHandler;

    public IntegrationCompletePostSetExecutor(RbsConfigurationMao inRbsConfigurationMao, FileLogger progressReportFileHandler2) {
        super(THIS_CLASS.getName(), inRbsConfigurationMao, RbsConfigurationDefinitions.RBS_CL_INTEGRATION_COMPLETE);
        this.progressReportFileHandler = progressReportFileHandler2;
    }

    public void execute(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.postSetHandler.finalizeSecurityActivation();
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "", "", coordinator);
        this.updateProgressReportInformation(2600, 5, OSS_IS_DONE_FINISHING_RBS_CONFIGURATION, true, coordinator);
        String featuresBooleanStr = (String)this.rbsConfigurationMao.retrievePersistently("featureActivationTriggered");
        if (Boolean.FALSE.toString().equalsIgnoreCase(featuresBooleanStr)) {
            this.updateProgressReportInformation(2525, 2, ACTIVATION_OF_FEATURES_NOT_PERFORMED, true, coordinator);
        }
        String cellsBooleanStr = (String)this.rbsConfigurationMao.retrievePersistently("unlockingOfCellsTriggered");
        if (Boolean.FALSE.toString().equalsIgnoreCase(cellsBooleanStr)) {
            this.updateProgressReportInformation(2550, 2, UNLOCKING_OF_CELLS_NOT_PERFORMED, true, coordinator);
        }
        try {
            ManagedObject managedElement = this.moRepositoryWrapper.lookup("ManagedElement=1");
            String logicalName = managedElement.getAttribute("logicalName", coordinator).toString();
            ConfigurationVersion configurationVersion = (ConfigurationVersion)this.moRepositoryWrapper.lookup("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
            LogHandler.makeZipFileOfLogFiles(logicalName, configurationVersion, this.rbsConfigurationMao, coordinator);
        }
        catch (Exception e) {
            logger.traceAbnormal(THIS_CLASS, ExceptionHelper.appendReason((String)"Failed to create ZIP file containing log files", (Throwable)e));
        }
        this.cleanData(coordinator);
        this.progressReportHandler.setIntegrationFinished(coordinator);
        this.progressReportFileHandler.integrationFinishedOrFailed();
        this.helper.integrationCompletePostSetHasBeenExecuted();
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    protected void cleanData(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "cleanData()");
        try {
            PersistentDataCleaner persistentAttributesCleaner = new PersistentDataCleaner(this.rbsConfigurationMao);
            persistentAttributesCleaner.cleanPersistentAttributesAndRemoveFiles("complete_", coordinator);
        }
        catch (MoAccessException mae) {
            logger.traceAbnormal(THIS_CLASS, "Clean of sensitive data failed.");
        }
        logger.traceReturn(THIS_CLASS, "cleanData()");
    }
}

