/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.postset;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationMmeHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.postset.AbstractPostSetExecutor;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.FileLogger;
import se.ericsson.crbs.logging.LoggingService;

public class OssPostSetExecutor
extends AbstractPostSetExecutor {
    public static final String OSS_IS_ACTIVATING_PLANNED_CONFIGURATION = "OSS is activating planned configuration";
    public static final String OSS_IS_DONE_ACTIVATING_PLANNED_CONFIGURATION = "OSS is done activating planned configuration";
    private static final Class THIS_CLASS = OssPostSetExecutor.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final FileLogger progressReportFileHandler;

    public OssPostSetExecutor(Integer theConfigurationLevel, RbsConfigurationMao theRbsConfigurationMao, FileLogger progressReportFileHandler2) {
        super(THIS_CLASS.getName(), theRbsConfigurationMao, theConfigurationLevel);
        this.progressReportFileHandler = progressReportFileHandler2;
    }

    public void execute(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (RbsConfigurationDefinitions.RBS_CL_OSS_ACTIVATING_CONFIGURATION.equals(this.configurationLevel)) {
            this.executeOssActivatingConfiguration(coordinator);
        } else if (RbsConfigurationDefinitions.RBS_CL_OSS_CONFIGURATION_SUCCESSFUL.equals(this.configurationLevel)) {
            this.executeOssConfigurationSuccessful(coordinator);
        } else if (RbsConfigurationDefinitions.RBS_CL_OSS_CONFIGURATION_FAILED.equals(this.configurationLevel)) {
            this.executeOssConfigurationFailed(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void executeOssActivatingConfiguration(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeOssActivatingConfiguration()");
        this.updateProgressReportInformation(2400, 3, OSS_IS_ACTIVATING_PLANNED_CONFIGURATION, true, coordinator);
        this.progressReportHandler.setIntegrationCanBeCancelled(Boolean.FALSE, coordinator);
        logger.traceReturn(THIS_CLASS, "executeOssActivatingConfiguration()");
    }

    private void executeOssConfigurationSuccessful(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeOssConfigurationSuccessful()");
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_UNDEFINED, "", "", coordinator);
        this.updateProgressReportInformation(2400, 5, OSS_IS_DONE_ACTIVATING_PLANNED_CONFIGURATION, true, coordinator);
        RbsConfigurationMmeHelper mmeHelper = (RbsConfigurationMmeHelper)this.rbsConfigurationContext.getHelper(RbsConfigurationMmeHelper.class);
        mmeHelper.reportOssComplete();
        this.progressReportHandler.setIntegrationCanBeCancelled(Boolean.FALSE, coordinator);
        logger.traceReturn(THIS_CLASS, "executeOssConfigurationSuccessful()");
    }

    private void executeOssConfigurationFailed(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "executeOssConfigurationFailed()");
        String faultReason = this.getOssFailureMessage(coordinator);
        this.helper.setFaultReason(RbsConfigurationDefinitions.RBS_FR_MO_CONFIGURATION_FAULT, "OSS Configuration Failed", faultReason, coordinator);
        this.updateProgressReportInformation(2400, 0, "External configuration by OSS has failed.", true, coordinator);
        this.progressReportFileHandler.integrationFinishedOrFailed();
        this.progressReportHandler.setIntegrationCanBeCancelled(Boolean.TRUE, coordinator);
        logger.traceReturn(THIS_CLASS, "executeOssConfigurationFailed()");
    }
}

