/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ErroneousInput;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationGroup;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationProcessParser;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IntegrationProcess {
    public static final String TOP_XML_TAG = "IntegrationProcess";
    public static final String REVISION_XML_ATTRIBUTE = "revision";
    public static final String IP_ADDRESS_XML_TAG = "IpAddressAfterReboot";
    public static final String IP_ADDRESS_XML_ATTRIBUTE = "ipAddress";
    public static final String RBS_STATE_XML_ATTRIBUTE = "value";
    public static final String REVISION = "R1G";
    private static final String INTEGRATION_PROCESS_XML_HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    private static final String INTEGRATION_PROCESS_START_XML_TAG = "<IntegrationProcess revision=\"R1G\">";
    private static final String INTEGRATION_PROCESS_END_XML_TAG = "</IntegrationProcess>";
    private static final String IP_ADDRESS_AFTER_REBOOT_START_XML_TAG = "<IpAddressAfterReboot ipAddress=";
    private static final String IP_ADDRESS_AFTER_REBOOT_LAST_START_XML_STRING = "/>";
    private static final Class THIS_CLASS = IntegrationProcess.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final List integrationGroupList = new ArrayList();
    private final List erroneousInputsList = new ArrayList();
    private final List rbsStatesList = new ArrayList();
    private String currentIpAddress = "";
    private String revision;

    public IntegrationProcess(String inputCurrentIpAddress) {
        this.currentIpAddress = inputCurrentIpAddress;
        this.revision = REVISION;
    }

    public void reset() {
        logger.traceEnter(THIS_CLASS, "reset()");
        this.integrationGroupList.clear();
        this.erroneousInputsList.clear();
        this.rbsStatesList.clear();
        logger.traceReturn(THIS_CLASS, "reset()");
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String inputRevision) {
        logger.traceEnter(THIS_CLASS, "setRevision(" + inputRevision + ")");
        this.revision = inputRevision;
        logger.traceReturn(THIS_CLASS, "setRevision(" + inputRevision + ")");
    }

    public void setCurrentIpAddres(String inputCurrentIpAddress) {
        logger.traceEnter(THIS_CLASS, "setCurrentIpAddres(" + inputCurrentIpAddress + ")");
        this.currentIpAddress = inputCurrentIpAddress;
        logger.traceReturn(THIS_CLASS, "setCurrentIpAddres(" + inputCurrentIpAddress + ")");
    }

    public void addErroneousInput(ErroneousInput erroneousInput) {
        this.removeErroneousInput(erroneousInput);
        this.erroneousInputsList.add(erroneousInput);
    }

    public void removeErroneousInput(ErroneousInput erroneousInput) {
        while (this.erroneousInputsList.contains(erroneousInput)) {
            this.erroneousInputsList.remove(erroneousInput);
        }
    }

    public IntegrationGroup getIntegrationGroup(String integrationGroupName) {
        IntegrationGroup integrationGroup = null;
        for (int i = 0; i < this.integrationGroupList.size(); ++i) {
            IntegrationGroup tmpIntegrationGroup = (IntegrationGroup)this.integrationGroupList.get(i);
            if (!tmpIntegrationGroup.getName().equalsIgnoreCase(integrationGroupName)) continue;
            integrationGroup = tmpIntegrationGroup;
            break;
        }
        return integrationGroup;
    }

    public IntegrationGroup[] getIntegrationGroups() {
        IntegrationGroup[] integrationGroups = new IntegrationGroup[this.integrationGroupList.size()];
        this.integrationGroupList.toArray(integrationGroups);
        return integrationGroups;
    }

    public void addIntegrationGroup(IntegrationGroup integrationGroup) {
        if (!this.integrationGroupList.contains(integrationGroup)) {
            this.integrationGroupList.add(integrationGroup);
            Object[] integrationGroups = new IntegrationGroup[this.integrationGroupList.size()];
            this.integrationGroupList.toArray(integrationGroups);
            Arrays.sort(integrationGroups);
            this.integrationGroupList.clear();
            this.integrationGroupList.addAll(Arrays.asList(integrationGroups));
        }
    }

    public RbsStateHolder[] getRbsStatusHolders() {
        RbsStateHolder[] rbsStateHolders = new RbsStateHolder[this.rbsStatesList.size()];
        this.rbsStatesList.toArray(rbsStateHolders);
        return rbsStateHolders;
    }

    public void addRbsStatus(String xmlTagName, Boolean xmlTagValue) {
        RbsStateHolder rbsStateHolder = new RbsStateHolder(xmlTagName);
        rbsStateHolder.setXmlTagValue(xmlTagValue);
        this.rbsStatesList.add(rbsStateHolder);
    }

    public static IntegrationProcess restoreFromAttribute(String progressReport) throws IOException, ClassNotFoundException {
        return IntegrationProcessParser.parse(progressReport);
    }

    public String[] getXmls() {
        ArrayList<String> xmlList = new ArrayList<String>();
        xmlList.add(INTEGRATION_PROCESS_XML_HEADER);
        xmlList.add(INTEGRATION_PROCESS_START_XML_TAG);
        this.addIntegrationGroups(xmlList);
        this.addErroneousInputs(xmlList);
        if (!"".equals(this.currentIpAddress)) {
            StringBuffer xmlBuf = new StringBuffer(500);
            xmlBuf.append(IP_ADDRESS_AFTER_REBOOT_START_XML_TAG).append(StringHelper.doubleQuote((String)this.currentIpAddress)).append(IP_ADDRESS_AFTER_REBOOT_LAST_START_XML_STRING);
            xmlList.add("  " + xmlBuf.toString());
        }
        for (int i = 0; i < this.rbsStatesList.size(); ++i) {
            RbsStateHolder rbsStateHolder = (RbsStateHolder)this.rbsStatesList.get(i);
            xmlList.add("  " + rbsStateHolder.getXml());
        }
        xmlList.add(INTEGRATION_PROCESS_END_XML_TAG);
        String[] xmls = new String[xmlList.size()];
        xmlList.toArray(xmls);
        return xmls;
    }

    private void addErroneousInputs(List xmlList) {
        if (this.erroneousInputsList.size() > 0) {
            for (int i = 0; i < this.erroneousInputsList.size(); ++i) {
                ErroneousInput erroneousInput = (ErroneousInput)this.erroneousInputsList.get(i);
                String[] erroneousInputXmls = erroneousInput.getXmls();
                for (int j = 0; j < erroneousInputXmls.length; ++j) {
                    xmlList.add("  " + erroneousInputXmls[j]);
                }
            }
        }
    }

    private void addIntegrationGroups(List xmlList) {
        for (int i = 0; i < this.integrationGroupList.size(); ++i) {
            IntegrationGroup integrationGroup = (IntegrationGroup)this.integrationGroupList.get(i);
            String[] xmls = integrationGroup.getXmls();
            for (int j = 0; j < xmls.length; ++j) {
                xmlList.add("  " + xmls[j]);
            }
        }
    }

    public static class RbsStateHolder {
        private static final char START_XML_CHAR = '<';
        private static final String VALUE_XML_STRING = " value=";
        private static final String END_XML_STRING = "/>";
        private final String xmlTagName;
        private Boolean xmlTagValue;

        public RbsStateHolder(String inputXmlTagName) {
            this.xmlTagName = inputXmlTagName;
        }

        public String getXmlTagName() {
            return this.xmlTagName;
        }

        public void setXmlTagValue(Boolean inputXmlTagValue) {
            this.xmlTagValue = inputXmlTagValue;
        }

        public Boolean getXmlTagValue() {
            return this.xmlTagValue;
        }

        public String getXml() {
            StringBuffer xmlBuf = new StringBuffer(100);
            xmlBuf.append('<').append(this.xmlTagName).append(VALUE_XML_STRING).append(StringHelper.doubleQuote((String)this.xmlTagValue.toString())).append("/>");
            return xmlBuf.toString();
        }
    }
}

