/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ErroneousInput;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationGroup;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationProcess;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationStep;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportCreator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SmrsInfo;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class IntegrationProcessParser
extends DefaultHandler {
    private static final Class THIS_CLASS = IntegrationProcessParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private String revision = "";
    private String ipAddress = "";
    private String networkLoaderCanBeStarted = "";
    private String autoIntegrationCanBeStarted = "";
    private String integrationCanBeStarted = "";
    private String integrationStarted = "";
    private String integrationFinished = "";
    private String integrationCancelled = "";
    private String integrationCanBeCancelled = "";
    private boolean insideErroneousSmrsInfo = false;
    private String smrsErrorMsg = "";
    private String smrsUserName = "";
    private String smrsPassword = "";
    private String smrsServer = "";
    private String summaryFilePath = "";
    private final IntegrationProcess newIntegrationProcess = new IntegrationProcess("");
    private final IntegrationProcess integrationProcess;
    private StringBuffer integrationStepDetailedMessage;
    private final List integrationGroupsList;
    private String integrationStepNumber = "";
    private String integrationStepName = "";
    private String integrationStepStatus = "";
    private String integrationStepTimeStamp = "";
    private boolean insideIntegrationStep;

    private IntegrationProcessParser() {
        ProgressReportCreator progressReportCreator = new ProgressReportCreator();
        progressReportCreator.createXml(this.newIntegrationProcess);
        this.integrationProcess = new IntegrationProcess("");
        this.integrationGroupsList = new ArrayList();
    }

    public IntegrationProcess getIntegrationProcess() {
        this.integrationProcess.setRevision(this.revision);
        return this.integrationProcess;
    }

    public void startElement(String namespaceUri, String simpleName, String qualifiedName, Attributes attributes) throws SAXException {
        if (!this.parseIntegrationProcess(qualifiedName, attributes) && !this.parseProgressReportCreator(qualifiedName, attributes)) {
            this.parseAttributes(qualifiedName, attributes);
        }
    }

    private boolean parseIntegrationProcess(String qualifiedName, Attributes attributes) {
        boolean result2 = true;
        if ("IntegrationProcess".equalsIgnoreCase(qualifiedName)) {
            this.revision = attributes.getValue("revision");
        } else if ("IpAddressAfterReboot".equalsIgnoreCase(qualifiedName)) {
            this.ipAddress = attributes.getValue("ipAddress");
            this.integrationProcess.setCurrentIpAddres(this.ipAddress);
        } else {
            result2 = false;
        }
        return result2;
    }

    private boolean parseProgressReportCreator(String qualifiedName, Attributes attributes) {
        boolean result2 = true;
        if ("NetworkLoaderCanBeStarted".equalsIgnoreCase(qualifiedName)) {
            this.networkLoaderCanBeStarted = attributes.getValue("value");
            Boolean booleanValue = this.getBooleanValue(this.networkLoaderCanBeStarted);
            this.integrationProcess.addRbsStatus("NetworkLoaderCanBeStarted", booleanValue);
        } else if ("AutoIntegrationCanBeStarted".equalsIgnoreCase(qualifiedName)) {
            this.autoIntegrationCanBeStarted = attributes.getValue("value");
            Boolean booleanValue = this.getBooleanValue(this.autoIntegrationCanBeStarted);
            this.integrationProcess.addRbsStatus("AutoIntegrationCanBeStarted", booleanValue);
        } else if ("RbsIntegrationCanBeStarted".equalsIgnoreCase(qualifiedName)) {
            this.integrationCanBeStarted = attributes.getValue("value");
            Boolean booleanValue = this.getBooleanValue(this.integrationCanBeStarted);
            this.integrationProcess.addRbsStatus("RbsIntegrationCanBeStarted", booleanValue);
        } else if ("RbsIntegrationStarted".equalsIgnoreCase(qualifiedName)) {
            this.integrationStarted = attributes.getValue("value");
            Boolean booleanValue = this.getBooleanValue(this.integrationStarted);
            this.integrationProcess.addRbsStatus("RbsIntegrationStarted", booleanValue);
        } else if ("RbsIntegrationFinished".equalsIgnoreCase(qualifiedName)) {
            this.integrationFinished = attributes.getValue("value");
            Boolean booleanValue = this.getBooleanValue(this.integrationFinished);
            this.integrationProcess.addRbsStatus("RbsIntegrationFinished", booleanValue);
        } else if ("RbsIntegrationCancelled".equalsIgnoreCase(qualifiedName)) {
            this.integrationCancelled = attributes.getValue("value");
            Boolean booleanValue = this.getBooleanValue(this.integrationCancelled);
            this.integrationProcess.addRbsStatus("RbsIntegrationCancelled", booleanValue);
        } else if ("RbsIntegrationCanBeCancelled".equalsIgnoreCase(qualifiedName)) {
            this.integrationCanBeCancelled = attributes.getValue("value");
            Boolean booleanValue = this.getBooleanValue(this.integrationCanBeCancelled);
            this.integrationProcess.addRbsStatus("RbsIntegrationCanBeCancelled", booleanValue);
        } else {
            result2 = false;
        }
        return result2;
    }

    private void parseAttributes(String qualifiedName, Attributes attributes) {
        if ("ErroneousInput".equalsIgnoreCase(qualifiedName)) {
            String smrsInfo = attributes.getValue("name");
            if (!smrsInfo.equalsIgnoreCase("")) {
                this.insideErroneousSmrsInfo = true;
            }
        } else if ("IntegrationGroup".equalsIgnoreCase(qualifiedName)) {
            this.parseIntegrationGroup(attributes);
        } else if ("IntegrationStep".equalsIgnoreCase(qualifiedName)) {
            this.insideIntegrationStep = true;
            this.integrationStepNumber = attributes.getValue("step");
            this.integrationStepName = this.getStepName(this.integrationStepNumber);
            attributes.getValue("name");
            this.integrationStepStatus = attributes.getValue("status");
            this.integrationStepTimeStamp = attributes.getValue("timeStamp");
            this.integrationStepDetailedMessage = new StringBuffer(5000);
        } else if (this.insideErroneousSmrsInfo && "SmrsInfo".equalsIgnoreCase(qualifiedName)) {
            this.smrsErrorMsg = attributes.getValue("errorMsg");
            this.smrsUserName = attributes.getValue("smrsUserName");
            this.smrsPassword = attributes.getValue("smrsPassword");
            this.smrsServer = attributes.getValue("smrsServer");
            this.summaryFilePath = attributes.getValue("summaryFilePath");
            SmrsInfo smrsInfo = new SmrsInfo(this.smrsErrorMsg, this.smrsUserName, this.smrsPassword, this.smrsServer, this.summaryFilePath);
            ErroneousInput erroneousInput = new ErroneousInput(smrsInfo);
            this.integrationProcess.addErroneousInput(erroneousInput);
        }
    }

    private Boolean getBooleanValue(String attributeName) {
        return Boolean.TRUE.toString().equalsIgnoreCase(attributeName) ? Boolean.TRUE : Boolean.FALSE;
    }

    private void parseIntegrationGroup(Attributes attributes) {
        String groupNumber = attributes.getValue("group");
        String name = this.getGroupName(groupNumber);
        String message = this.getGroupMessage(groupNumber);
        IntegrationGroup integrationGroup = new IntegrationGroup(Integer.parseInt(groupNumber), name, message);
        if (this.integrationGroupsList.size() > 0) {
            int lastIndex = this.integrationGroupsList.size() - 1;
            IntegrationGroup parentIntegrationGroup = (IntegrationGroup)this.integrationGroupsList.get(lastIndex);
            parentIntegrationGroup.addIntegrationGroup(integrationGroup);
        } else {
            this.integrationProcess.addIntegrationGroup(integrationGroup);
        }
        this.integrationGroupsList.add(integrationGroup);
    }

    private String getGroupName(String groupNumber) {
        String groupName = "";
        int groupNumberValue = Integer.parseInt(groupNumber);
        IntegrationGroup[] integrationGroups = this.newIntegrationProcess.getIntegrationGroups();
        for (int i = 0; i < integrationGroups.length; ++i) {
            if (groupNumberValue != integrationGroups[i].getGroupNumber()) continue;
            groupName = integrationGroups[i].getName();
            break;
        }
        return groupName;
    }

    private String getGroupMessage(String groupNumber) {
        String groupMessage = "";
        int groupNumberValue = Integer.parseInt(groupNumber);
        IntegrationGroup[] integrationGroups = this.newIntegrationProcess.getIntegrationGroups();
        for (int i = 0; i < integrationGroups.length; ++i) {
            if (groupNumberValue != integrationGroups[i].getGroupNumber()) continue;
            groupMessage = integrationGroups[i].getMessage();
            break;
        }
        return groupMessage;
    }

    private String getStepName(String stepNumber) {
        String stepName = "";
        int stepNumberValue = Integer.parseInt(stepNumber);
        IntegrationGroup[] integrationGroups = this.newIntegrationProcess.getIntegrationGroups();
        boolean found = false;
        for (int i = 0; i < integrationGroups.length; ++i) {
            IntegrationStep[] integrationSteps = integrationGroups[i].getIntegrationSteps();
            for (int j = 0; j < integrationSteps.length; ++j) {
                if (stepNumberValue != integrationSteps[j].getStepNumber()) continue;
                stepName = integrationSteps[j].getName();
                found = true;
                break;
            }
            if (found) break;
        }
        return stepName;
    }

    public void characters(char[] charArray, int start, int length) throws SAXException {
        if (this.insideIntegrationStep) {
            this.integrationStepDetailedMessage.append(charArray, start, length);
        }
    }

    public void endElement(String namespaceUri, String simpleName, String qualifiedName) throws SAXException {
        if ("ErroneousInput".equalsIgnoreCase(qualifiedName)) {
            this.insideErroneousSmrsInfo = false;
        } else if ("IntegrationGroup".equalsIgnoreCase(qualifiedName)) {
            int lastIndex = this.integrationGroupsList.size() - 1;
            this.integrationGroupsList.remove(lastIndex);
        } else if ("IntegrationStep".equalsIgnoreCase(qualifiedName)) {
            this.insideIntegrationStep = false;
            int status = 0;
            for (int i = 0; i < ProgressReportCreator.STATUS_VALUE_STRINGS.length; ++i) {
                if (!ProgressReportCreator.STATUS_VALUE_STRINGS[i].equalsIgnoreCase(this.integrationStepStatus)) continue;
                status = ProgressReportCreator.STATUS_VALUES[i];
                break;
            }
            long timeStamp = "Not started".equalsIgnoreCase(this.integrationStepTimeStamp) ? 0L : DateTimeHelper.stringToDateTime((String)this.integrationStepTimeStamp, (String)"yyyy-MM-dd HH:mm:ss.SSS").getTime();
            IntegrationStep integrationStep = new IntegrationStep(Integer.parseInt(this.integrationStepNumber), this.integrationStepName, status, timeStamp, this.integrationStepDetailedMessage.toString().trim());
            int lastIndex = this.integrationGroupsList.size() - 1;
            IntegrationGroup integrationGroup = (IntegrationGroup)this.integrationGroupsList.get(lastIndex);
            integrationGroup.addIntegrationStep(integrationStep);
        }
    }

    public static IntegrationProcess parse(String progressReport) throws IOException {
        IntegrationProcessParser integrationProcessParser = new IntegrationProcessParser();
        logger.traceEnter(THIS_CLASS, "parse(progressReport)");
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            ByteArrayInputStream bais = new ByteArrayInputStream(progressReport.getBytes());
            InputSource input = new InputSource(bais);
            logger.traceDebug(THIS_CLASS, "progressReport: \"" + progressReport + "\"");
            saxParser.parse(input, (DefaultHandler)integrationProcessParser);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        logger.traceReturn(THIS_CLASS, "parse(progressReport)");
        return integrationProcessParser.getIntegrationProcess();
    }
}

