/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport;

import java.util.ArrayList;
import java.util.Arrays;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.helper.RbsConfigurationSmrsHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ErroneousInput;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationGroup;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationProcess;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.IntegrationStep;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportCreator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.led.LEDProxyFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.ric.RicInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.smrs.SmrsInfo;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.common.ExceptionHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ProgressReportHandler {
    public static final int VLAN_SCANNING_STEP = 20;
    public static final int CREATING_INITIAL_CONFIGURATION_VERSION_STEP = 50;
    public static final int FETCHING_EGIS_DATA_STEP = 95;
    public static final int FETCHING_IP_CONFIGURATION_VIA_DHCP_STEP = 100;
    public static final int ACTIVATING_TEMPORARY_IPSEC_TUNNEL_STEP = 150;
    public static final int ACTIVATING_IP_CONFIGURATION_STEP = 200;
    public static final int FETCHING_SITE_INSTALLATION_FILE_STEP = 250;
    public static final int FETCHING_SUMMARY_FILE_STEP = 300;
    public static final int READING_SUMMARY_FILE_STEP = 400;
    public static final int INSTALLING_INTEGRATION_BASIC_PACKAGE_STEP = 420;
    public static final int FETCHING_UPGRADE_PACKAGE_STEP = 500;
    public static final int INSTALLING_UPGRADE_PACKAGE_STEP = 600;
    public static final int UPGRADING_WITH_UPGRADE_PACKAGE_STEP = 700;
    public static final int INSTALLING_LICENSE_STEP = 800;
    public static final int FETCHING_INTEGRATION_BP_FILE_STEP = 410;
    public static final int CHECK_DOWNLOAD_SPEED_STEP = 405;
    public static final int FETCHING_OAM_ACCESS_FILE_STEP = 430;
    public static final int FETCHING_CABINET_EQUIPMENT_FILE_STEP = 440;
    public static final int FETCHING_ANTENNA_SYSTEM_FILE_STEP = 450;
    public static final int FETCHING_SITE_EQUIPMENT_FILE_STEP = 900;
    public static final int READING_SITE_EQUIPMENT_FILE_STEP = 1000;
    public static final int CONFIGURING_EXTENDED_DIGITAL_EQUIPMENT_STEP = 1050;
    public static final int CONFIGURING_RADIO_EQUIPMENT_STEP = 1100;
    public static final int CONFIGURING_SUPPORT_SYSTEM_STEP = 1200;
    public static final int CONFIGURING_ANTENNA_SYSTEM_STEP = 1300;
    public static final int ACTIVATING_IP_SEC_STEP = 1450;
    public static final int FETCHING_SITE_BASIC_FILE_STEP = 1500;
    public static final int READING_SITE_BASIC_FILE_STEP = 1600;
    public static final int TEARING_DOWN_TEMPORARY_TUNNEL_STEP = 1650;
    public static final int ACTIVATING_SITE_BASIC_CONFIGURATION_STEP = 1700;
    public static final int CONFIGURING_IP_SEC_STEP = 1800;
    public static final int RESTART_EXT_DU_STEP = 1810;
    public static final int WAIT_FOR_DU_UP_STEP = 1820;
    public static final int VERIFYING_OSS_CONNECTIVITY_STEP = 1850;
    public static final int FETCHING_NODE_SECURITY_STEP = 1900;
    public static final int INSTALLING_NODE_SECURITY_STEP = 2000;
    public static final int INSTALLING_IP_SEC_STEP = 2100;
    public static final int ACTIVATING_NODE_SECURITY_STEP = 2200;
    public static final int NOTIFYING_OSS_STEP = 2300;
    public static final int CREATING_CONFIGURATION_VERSION_STEP = 2350;
    public static final int ACTIVATING_PLAN_CONFIGURATION_STEP = 2400;
    public static final int ESTABLISHING_S1_CONNECTION_STEP = 2500;
    public static final int ACTIVATION_OF_FEATURES_STEP = 2525;
    public static final int GEO_LOCATION_CHECK_STEP = 2540;
    public static final int UNLOCKING_OF_CELLS_STEP = 2550;
    public static final int CALIBRATING_ANTENNAS_STEP = 2575;
    public static final int INTEGRATION_FINISHED_STEP = 2600;
    public static final int READY_FOR_SERVICE_STEP = 2700;
    private static final Class THIS_CLASS = ProgressReportHandler.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final ProgressReportHandler INSTANCE = new ProgressReportHandler();
    private ProgressReportCreator progressReportCreator = null;
    private RbsConfigurationSmrsHelper rbsConfigurationSmrsHelper = null;
    private IntegrationProcess integrationProcess = null;
    private RbsConfigurationMao rbsConfigurationMao = null;
    private boolean updated = false;
    protected boolean faultySmrsInfoReported = false;
    protected boolean faultyRicInfoReported = false;
    protected int progressReportUpdateCounter = 0;

    private ProgressReportHandler() {
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public static final ProgressReportHandler getInstance() {
        return INSTANCE;
    }

    public void setPersistentAttribute(String attributeName, Object attributeValue) throws MoAccessException {
        this.rbsConfigurationMao.storePersistently(attributeName, attributeValue);
        logger.traceGeneral(THIS_CLASS, "The attribute " + attributeName + " has been successfully stored with the value " + attributeValue + " persistently.");
    }

    public void setCurrentIpAddress(String currentIpAddress, boolean updateProgressReport) {
        logger.traceEnter(THIS_CLASS, "setCurrentIpAddress : currentIpAddress " + currentIpAddress);
        this.integrationProcess.setCurrentIpAddres(currentIpAddress);
        if (updateProgressReport) {
            this.setProgressReport(this.generateXml(), false, null);
        }
        logger.traceGeneral(THIS_CLASS, "Set new IP address to \"" + currentIpAddress + "\" in " + this.getClass().getName());
        logger.traceReturn(THIS_CLASS, "setCurrentIpAddress");
    }

    public void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        this.updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport, null);
    }

    private void setLEDVisualStateInProgress() {
        if (LEDProxyFactory.getLEDProxy().getCurrentState() != 1) {
            LEDProxyFactory.getLEDProxy().setLEDVisualState(1);
        }
    }

    private void setLEDVisualStateContactWithOssEnabled() {
        if (LEDProxyFactory.getLEDProxy().getCurrentState() != 3) {
            LEDProxyFactory.getLEDProxy().setLEDVisualState(3);
        }
    }

    private void setLEDVisualStateFailure() {
        if (LEDProxyFactory.getLEDProxy().getCurrentState() != 1) {
            LEDProxyFactory.getLEDProxy().setLEDVisualState(1);
        }
    }

    public void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport, Coordinator coordinator) {
        if ((status == 0 || status == 4) && 1850 <= integrationStepNumber) {
            this.setLEDVisualStateFailure();
        } else if (status == 5 && 1850 <= integrationStepNumber) {
            this.setLEDVisualStateContactWithOssEnabled();
        }
        String integrationGroupName = "";
        String integrationStepName = "";
        switch (integrationStepNumber) {
            case 20: {
                integrationGroupName = "VLAN Scanning";
                integrationStepName = "VLAN scanning";
                break;
            }
            case 50: {
                integrationGroupName = "Initial creation of Configuration Version (CV)";
                integrationStepName = "Creating initial Configuration Version (CV)";
                break;
            }
            case 100: {
                integrationGroupName = "Initial IP Connectivity";
                integrationStepName = "Fetching of IP Configuration via DHCP";
                break;
            }
            case 150: {
                integrationGroupName = "Initial IP Connectivity";
                integrationStepName = "Activation of temporary IpSec tunnel";
                break;
            }
            case 200: {
                integrationGroupName = "Initial IP Connectivity";
                integrationStepName = "Activation of IP Connectivity";
                break;
            }
            case 250: {
                integrationGroupName = "Site Installation File";
                integrationStepName = "Fetching of Site Installation Configuration via Web Server";
                break;
            }
            case 300: {
                integrationGroupName = "Summary File";
                integrationStepName = "Fetching of Summary file";
                break;
            }
            case 400: {
                integrationGroupName = "Summary File";
                integrationStepName = "Reading of Summary file";
                break;
            }
            case 405: {
                integrationGroupName = "Installation of Integration Basic Package";
                integrationStepName = "Integration Basic Package check download speed";
                break;
            }
            case 410: {
                integrationGroupName = "Installation of Integration Basic Package";
                integrationStepName = "Integration Basic Package Download";
                break;
            }
            case 420: {
                integrationGroupName = "Installation of Integration Basic Package";
                integrationStepName = "Installing Integration Basic Package";
                break;
            }
            case 430: {
                integrationGroupName = "Fetching WCDMA configuration files";
                integrationStepName = "Fetching file Oam Access";
                break;
            }
            case 440: {
                integrationGroupName = "Fetching WCDMA configuration files";
                integrationStepName = "Fetching file Cabinet Equipment";
                break;
            }
            case 450: {
                integrationGroupName = "Fetching WCDMA configuration files";
                integrationStepName = "Fetching file Antenna";
                break;
            }
            case 500: {
                integrationGroupName = "Upgrade";
                integrationStepName = "Fetching of upgrade package";
                break;
            }
            case 600: {
                integrationGroupName = "Upgrade";
                integrationStepName = "Installation of upgrade package";
                break;
            }
            case 700: {
                integrationGroupName = "Upgrade";
                integrationStepName = "Upgrade of installed upgrade package";
                break;
            }
            case 800: {
                integrationGroupName = "Licensing";
                integrationStepName = "Installation of license key file";
                break;
            }
            case 1450: {
                integrationGroupName = "IP Security Activation";
                integrationStepName = "Activating IP Security";
                break;
            }
            case 1500: {
                integrationGroupName = "Site Basic Configuration";
                integrationStepName = "Fetching of Site Basic file";
                break;
            }
            case 1600: {
                integrationGroupName = "Site Basic Configuration";
                integrationStepName = "Reading of Site Basic file";
                break;
            }
            case 1650: {
                integrationGroupName = "Site Basic Configuration";
                integrationStepName = "Tearing down the temporary IpSec tunnel";
                break;
            }
            case 1700: {
                integrationGroupName = "Site Basic Configuration";
                integrationStepName = "Activation of Site Basic configuration";
                break;
            }
            case 1800: {
                integrationGroupName = "Site Basic Configuration";
                integrationStepName = "Configuration of IPSec";
                break;
            }
            case 1810: {
                integrationGroupName = "Extension DU activation for IDL2 configuration";
                integrationStepName = "Restarting extension DU";
                break;
            }
            case 1820: {
                integrationGroupName = "Extension DU activation for IDL2 configuration";
                integrationStepName = "Waiting for DUs up";
                break;
            }
            case 1850: {
                integrationGroupName = "OSS Connectivity Verification";
                integrationStepName = "Verifying OSS connectivity";
                if (status != 5 && status != 2) break;
                this.setLEDVisualStateContactWithOssEnabled();
                break;
            }
            case 900: {
                integrationGroupName = "Site Equipment Configuration";
                integrationStepName = "Fetching of Site Equipment file";
                break;
            }
            case 1000: {
                integrationGroupName = "Site Equipment Configuration";
                integrationStepName = "Reading of Site Equipment file";
                break;
            }
            case 1200: {
                integrationGroupName = "Site Equipment Configuration";
                integrationStepName = "Configuration of support system";
                break;
            }
            case 1050: {
                integrationGroupName = "Site Equipment Configuration";
                integrationStepName = "Configuration of multi DU digitalEquipment";
                break;
            }
            case 1100: {
                integrationGroupName = "Site Equipment Configuration";
                integrationStepName = "Configuration of radio equipment";
                break;
            }
            case 1300: {
                integrationGroupName = "Site Equipment Configuration";
                integrationStepName = "Configuration of antenna systems";
                break;
            }
            case 2000: {
                integrationGroupName = "Security Configuration";
                integrationStepName = "Installation of node security";
                break;
            }
            case 1900: {
                integrationGroupName = "Security Configuration";
                integrationStepName = "Fetching of Initial Security Containment File (ISCF)";
                break;
            }
            case 2100: {
                integrationGroupName = "Security Configuration";
                integrationStepName = "Installation of IPSec certificates";
                break;
            }
            case 2200: {
                integrationGroupName = "Security Configuration";
                integrationStepName = "Activation of node security";
                break;
            }
            case 2300: {
                integrationGroupName = "OSS Configuration";
                integrationStepName = "Notification of OSS";
                break;
            }
            case 2350: {
                integrationGroupName = "OSS Configuration";
                integrationStepName = "Creating Configuration Version (CV)";
                break;
            }
            case 2400: {
                integrationGroupName = "OSS Configuration";
                integrationStepName = "Activation of planned configuration - RN and TN";
                break;
            }
            case 2500: {
                integrationGroupName = "OSS Configuration";
                integrationStepName = "Establishment of S1 connection";
                break;
            }
            case 2525: {
                integrationGroupName = "OSS Configuration";
                integrationStepName = "Activation of features";
                break;
            }
            case 2540: {
                integrationGroupName = "OSS Configuration";
                integrationStepName = "Geographic location check";
                break;
            }
            case 2550: {
                integrationGroupName = "OSS Configuration";
                integrationStepName = "Unlocking of cells";
                break;
            }
            case 2575: {
                integrationGroupName = "Integration status";
                integrationStepName = "Calibration of antennas";
                break;
            }
            case 2600: {
                integrationGroupName = "Integration status";
                integrationStepName = "Integration finished";
                break;
            }
            case 2700: {
                integrationGroupName = "Integration status";
                integrationStepName = "Ready for service";
                break;
            }
        }
        if (!"".equalsIgnoreCase(integrationGroupName) && !"".equalsIgnoreCase(integrationStepName)) {
            this.updateProgressReportAndSetAttributeValue(integrationGroupName, integrationStepName, status, detailedInformation, updateProgressReport, coordinator);
        }
    }

    public void setIntegrationCanBeStarted(Boolean integrationCanBeStarted) {
        this.setIntegrationCanBeStarted(integrationCanBeStarted, null);
    }

    public void setIntegrationCanBeStarted(Boolean integrationCanBeStarted, Coordinator coordinator) {
        boolean useCoordinator;
        boolean bl = useCoordinator = coordinator != null;
        if (integrationCanBeStarted.booleanValue()) {
            this.setIntegrationAndNetworkLoaderCanBeStarted(coordinator);
        } else {
            this.setRbsStateHolder("NetworkLoaderCanBeStarted", integrationCanBeStarted, false, useCoordinator, coordinator);
            this.setRbsStateHolder("RbsIntegrationCanBeStarted", integrationCanBeStarted, true, useCoordinator, coordinator);
        }
    }

    public void setIntegrationAndNetworkLoaderCanBeStarted() {
        this.setIntegrationAndNetworkLoaderCanBeStarted(null);
    }

    public void setIntegrationAndNetworkLoaderCanBeStarted(Coordinator coordinator) {
        Boolean networkLoaderCanBeStarted = Boolean.TRUE;
        Boolean autoIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationCanBeStarted = Boolean.TRUE;
        Boolean rbsIntegrationStarted = Boolean.FALSE;
        Boolean rbsIntegrationFinished = Boolean.FALSE;
        Boolean rbsIntegrationCancelled = Boolean.FALSE;
        Boolean rbsIntegrationCanBeCancelled = Boolean.FALSE;
        this.updateRbsStatHolderFlags(networkLoaderCanBeStarted, autoIntegrationCanBeStarted, rbsIntegrationCanBeStarted, rbsIntegrationStarted, rbsIntegrationFinished, rbsIntegrationCancelled, rbsIntegrationCanBeCancelled, coordinator);
    }

    public void setAutoIntegrationAndNetworkLoaderCanBeStarted() {
        this.setAutoIntegrationAndNetworkLoaderCanBeStarted(null);
    }

    public void setAutoIntegrationAndNetworkLoaderCanBeStarted(Coordinator coordinator) {
        Boolean networkLoaderCanBeStarted = Boolean.TRUE;
        Boolean autoIntegrationCanBeStarted = Boolean.TRUE;
        Boolean rbsIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationStarted = Boolean.FALSE;
        Boolean rbsIntegrationFinished = Boolean.FALSE;
        Boolean rbsIntegrationCancelled = Boolean.FALSE;
        Boolean rbsIntegrationCanBeCancelled = Boolean.FALSE;
        this.updateRbsStatHolderFlags(networkLoaderCanBeStarted, autoIntegrationCanBeStarted, rbsIntegrationCanBeStarted, rbsIntegrationStarted, rbsIntegrationFinished, rbsIntegrationCancelled, rbsIntegrationCanBeCancelled, coordinator);
    }

    public void integrationHasBeenStarted(boolean activateSecurity, boolean activateIpSecurity) {
        logger.traceEnter(THIS_CLASS, "setIntegrationStarted: activateSecurity = " + activateSecurity + ", activateIpSecurity = " + activateIpSecurity);
        this.setLEDVisualStateInProgress();
        this.prepareProgressReport(activateSecurity, activateIpSecurity);
        this.setIntegrationAndNetworkLoaderStarted();
        logger.traceReturn(THIS_CLASS, "setIntegrationStarted: activateSecurity = " + activateSecurity + ", activateIpSecurity = " + activateIpSecurity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareProgressReport(boolean activateSecurity, boolean activateIpSecurity) {
        String prXml;
        ProgressReportHandler progressReportHandler = INSTANCE;
        synchronized (progressReportHandler) {
            this.integrationProcess.reset();
            this.progressReportCreator.createXml(this.integrationProcess);
            this.checkSecuritySteps(activateSecurity, activateIpSecurity);
            prXml = this.generateXml();
        }
        this.setProgressReport(prXml, false, null);
    }

    public void setIntegrationAndNetworkLoaderStarted() {
        Boolean networkLoaderCanBeStarted = Boolean.FALSE;
        Boolean autoIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationStarted = Boolean.TRUE;
        Boolean rbsIntegrationFinished = Boolean.FALSE;
        Boolean rbsIntegrationCancelled = Boolean.FALSE;
        Boolean rbsIntegrationCanBeCancelled = Boolean.TRUE;
        this.updateRbsStatHolderFlags(networkLoaderCanBeStarted, autoIntegrationCanBeStarted, rbsIntegrationCanBeStarted, rbsIntegrationStarted, rbsIntegrationFinished, rbsIntegrationCancelled, rbsIntegrationCanBeCancelled);
    }

    public void setIntegrationFinished(Coordinator coordinator) {
        Boolean networkLoaderCanBeStarted = Boolean.FALSE;
        Boolean autoIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationStarted = Boolean.TRUE;
        Boolean rbsIntegrationFinished = Boolean.TRUE;
        Boolean rbsIntegrationCancelled = Boolean.FALSE;
        Boolean rbsIntegrationCanBeCancelled = Boolean.FALSE;
        this.updateRbsStatHolderFlags(networkLoaderCanBeStarted, autoIntegrationCanBeStarted, rbsIntegrationCanBeStarted, rbsIntegrationStarted, rbsIntegrationFinished, rbsIntegrationCancelled, rbsIntegrationCanBeCancelled, coordinator);
    }

    public void setIntegrationCancelled() {
        Boolean networkLoaderCanBeStarted = Boolean.FALSE;
        Boolean autoIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationStarted = Boolean.FALSE;
        Boolean rbsIntegrationFinished = Boolean.FALSE;
        Boolean rbsIntegrationCancelled = Boolean.TRUE;
        Boolean rbsIntegrationCanBeCancelled = Boolean.FALSE;
        this.updateRbsStatHolderFlags(networkLoaderCanBeStarted, autoIntegrationCanBeStarted, rbsIntegrationCanBeStarted, rbsIntegrationStarted, rbsIntegrationFinished, rbsIntegrationCancelled, rbsIntegrationCanBeCancelled);
    }

    public void setIntegrationCanBeCancelled(Boolean integrationCanBeCancelled) {
        logger.traceEnter(THIS_CLASS, "setIntegrationCanBeCancelled");
        this.setIntegrationCanBeCancelled(integrationCanBeCancelled, null);
        logger.traceReturn(THIS_CLASS, "setIntegrationCanBeCancelled");
    }

    public void setIntegrationCanBeCancelled(Boolean integrationCanBeCancelled, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setIntegrationCanBeCancelled");
        this.setRbsStateHolder("RbsIntegrationCanBeCancelled", integrationCanBeCancelled, true, false, coordinator);
        logger.traceReturn(THIS_CLASS, "setIntegrationCanBeCancelled");
    }

    public void setForEnableAiWoLaptop() {
        Boolean networkLoaderCanBeStarted = Boolean.FALSE;
        Boolean autoIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationCanBeStarted = Boolean.FALSE;
        Boolean rbsIntegrationStarted = Boolean.TRUE;
        Boolean rbsIntegrationFinished = Boolean.FALSE;
        Boolean rbsIntegrationCancelled = Boolean.FALSE;
        Boolean rbsIntegrationCanBeCancelled = Boolean.TRUE;
        this.updateRbsStatHolderFlags(networkLoaderCanBeStarted, autoIntegrationCanBeStarted, rbsIntegrationCanBeStarted, rbsIntegrationStarted, rbsIntegrationFinished, rbsIntegrationCancelled, rbsIntegrationCanBeCancelled);
    }

    public void updateRbsStatHolderFlags(Boolean networkLoaderCanBeStarted, Boolean autoIntegrationCanBeStarted, Boolean rbsIntegrationCanBeStarted, Boolean rbsIntegrationStarted, Boolean rbsIntegrationFinished, Boolean rbsIntegrationCancelled, Boolean rbsIntegrationCanBeCancelled) {
        this.updateRbsStatHolderFlags(networkLoaderCanBeStarted, autoIntegrationCanBeStarted, rbsIntegrationCanBeStarted, rbsIntegrationStarted, rbsIntegrationFinished, rbsIntegrationCancelled, rbsIntegrationCanBeCancelled, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRbsStatHolderFlags(Boolean networkLoaderCanBeStarted, Boolean autoIntegrationCanBeStarted, Boolean rbsIntegrationCanBeStarted, Boolean rbsIntegrationStarted, Boolean rbsIntegrationFinished, Boolean rbsIntegrationCancelled, Boolean rbsIntegrationCanBeCancelled, Coordinator coordinator) {
        boolean useCoordinator = coordinator != null;
        boolean valueUpdated = false;
        boolean updateProgressReport = true;
        String prXml = null;
        ProgressReportHandler progressReportHandler = INSTANCE;
        synchronized (progressReportHandler) {
            IntegrationProcess.RbsStateHolder[] rbsStateHolders = this.integrationProcess.getRbsStatusHolders();
            for (int i = 0; i < rbsStateHolders.length; ++i) {
                if (rbsStateHolders[i].getXmlTagName().equalsIgnoreCase("NetworkLoaderCanBeStarted") && !rbsStateHolders[i].getXmlTagValue().equals(networkLoaderCanBeStarted)) {
                    rbsStateHolders[i].setXmlTagValue(networkLoaderCanBeStarted);
                    logger.traceGeneral(THIS_CLASS, "Set, \"NetworkLoaderCanBeStarted\" to \"" + networkLoaderCanBeStarted + "\"");
                    valueUpdated = true;
                    continue;
                }
                if (rbsStateHolders[i].getXmlTagName().equalsIgnoreCase("AutoIntegrationCanBeStarted") && !rbsStateHolders[i].getXmlTagValue().equals(autoIntegrationCanBeStarted)) {
                    rbsStateHolders[i].setXmlTagValue(autoIntegrationCanBeStarted);
                    logger.traceGeneral(THIS_CLASS, "Set, \"AutoIntegrationCanBeStarted\" to \"" + autoIntegrationCanBeStarted + "\"");
                    valueUpdated = true;
                    continue;
                }
                if (rbsStateHolders[i].getXmlTagName().equalsIgnoreCase("RbsIntegrationCanBeStarted") && !rbsStateHolders[i].getXmlTagValue().equals(rbsIntegrationCanBeStarted)) {
                    rbsStateHolders[i].setXmlTagValue(rbsIntegrationCanBeStarted);
                    logger.traceGeneral(THIS_CLASS, "Set, \"RbsIntegrationCanBeStarted\" to \"" + rbsIntegrationCanBeStarted + "\"");
                    valueUpdated = true;
                    continue;
                }
                if (rbsStateHolders[i].getXmlTagName().equalsIgnoreCase("RbsIntegrationStarted") && !rbsStateHolders[i].getXmlTagValue().equals(rbsIntegrationStarted)) {
                    rbsStateHolders[i].setXmlTagValue(rbsIntegrationStarted);
                    logger.traceGeneral(THIS_CLASS, "Set, \"RbsIntegrationStarted\" to \"" + rbsIntegrationStarted + "\"");
                    valueUpdated = true;
                    continue;
                }
                if (rbsStateHolders[i].getXmlTagName().equalsIgnoreCase("RbsIntegrationFinished") && !rbsStateHolders[i].getXmlTagValue().equals(rbsIntegrationFinished)) {
                    rbsStateHolders[i].setXmlTagValue(rbsIntegrationFinished);
                    logger.traceGeneral(THIS_CLASS, "Set, \"RbsIntegrationFinished\" to \"" + rbsIntegrationFinished + "\"");
                    valueUpdated = true;
                    continue;
                }
                if (rbsStateHolders[i].getXmlTagName().equalsIgnoreCase("RbsIntegrationCancelled") && !rbsStateHolders[i].getXmlTagValue().equals(rbsIntegrationCancelled)) {
                    rbsStateHolders[i].setXmlTagValue(rbsIntegrationCancelled);
                    logger.traceGeneral(THIS_CLASS, "Set, \"RbsIntegrationCancelled\" to \"" + rbsIntegrationCancelled + "\"");
                    valueUpdated = true;
                    continue;
                }
                if (!rbsStateHolders[i].getXmlTagName().equalsIgnoreCase("RbsIntegrationCanBeCancelled") || rbsStateHolders[i].getXmlTagValue().equals(rbsIntegrationCanBeCancelled)) continue;
                rbsStateHolders[i].setXmlTagValue(rbsIntegrationCanBeCancelled);
                logger.traceGeneral(THIS_CLASS, "Set, \"RbsIntegrationCanBeCancelled\" to \"" + rbsIntegrationCanBeCancelled + "\"");
                valueUpdated = true;
            }
        }
        if (updateProgressReport) {
            prXml = this.generateXml();
        }
        if (valueUpdated && updateProgressReport) {
            this.setProgressReport(prXml, useCoordinator, coordinator);
        }
    }

    public void setProgressReport(String progressReport, boolean useCoordinator, Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "setProgressReport() - " + useCoordinator + ", " + coordinator);
        try {
            if (useCoordinator || coordinator != null) {
                this.rbsConfigurationMao.setReadOnlyAttribute("progressReport", progressReport, coordinator);
                ++this.progressReportUpdateCounter;
                this.rbsConfigurationMao.setReadOnlyAttribute("progressReportUpdateCounter", new Integer(this.progressReportUpdateCounter), coordinator);
                this.updated = true;
            } else {
                this.rbsConfigurationMao.setReadOnlyAttribute("progressReport", progressReport);
                ++this.progressReportUpdateCounter;
                this.rbsConfigurationMao.setReadOnlyAttribute("progressReportUpdateCounter", new Integer(this.progressReportUpdateCounter));
                this.updated = true;
            }
        }
        catch (MoAccessException mae) {
            String errorMsg = ExceptionHelper.appendReason((String)"Could not set the progressReport attribute in the RbsConfiguration MO. ", (Throwable)mae);
            logger.info(THIS_CLASS, "setProgressReport(): " + errorMsg);
        }
        logger.traceReturn(THIS_CLASS, "setProgressReport()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrongRbsIntegrationCode(RicInfo faultyRicInfo) {
        String prXml = null;
        ErroneousInput erroneousInput = new ErroneousInput(faultyRicInfo);
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.integrationProcess.addErroneousInput(erroneousInput);
            this.faultyRicInfoReported = true;
            prXml = this.generateXml();
        }
        this.setProgressReport(prXml, false, null);
        logger.traceGeneral(THIS_CLASS, "Added erroneous RIC input: " + erroneousInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWrongUserAndOrPassword(String errorMsg, SmrsInfo faultySmrsInfo) {
        String prXml = null;
        boolean xmlGenerated = false;
        ErroneousInput erroneousInput = null;
        SmrsInfo currentSmrsInfo = this.rbsConfigurationSmrsHelper.getSmrsInfo();
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (!this.faultySmrsInfoReported && faultySmrsInfo.equals(currentSmrsInfo)) {
                SmrsInfo smrsInfo = new SmrsInfo(errorMsg, faultySmrsInfo.getSmrsUserName(), "", faultySmrsInfo.getSmrsServer(), faultySmrsInfo.getSummaryFilePath());
                erroneousInput = new ErroneousInput(smrsInfo);
                this.integrationProcess.addErroneousInput(erroneousInput);
                this.faultySmrsInfoReported = true;
                prXml = this.generateXml();
                xmlGenerated = true;
            }
        }
        if (xmlGenerated) {
            this.setProgressReport(prXml, false, null);
            logger.traceGeneral(THIS_CLASS, "Added erroneous SMRS input: " + erroneousInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErroneousSmrsInfo() {
        SmrsInfo smrsInfo = new SmrsInfo("", "", "", "", "");
        String prXml = null;
        Object object = THIS_CLASS;
        synchronized (object) {
            ErroneousInput erroneousInput = new ErroneousInput(smrsInfo);
            this.integrationProcess.removeErroneousInput(erroneousInput);
            this.faultySmrsInfoReported = false;
            prXml = this.generateXml();
        }
        this.setProgressReport(prXml, false, null);
        logger.traceGeneral(THIS_CLASS, "Removed erroneous SMRS input");
        object = RbsConfigurationHelper.WAITING_MUTEX;
        synchronized (object) {
            RbsConfigurationHelper.WAITING_MUTEX.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWrongRbsIntegrationCode() {
        String prXml = null;
        Object object = THIS_CLASS;
        synchronized (object) {
            RicInfo ricInfo = new RicInfo("");
            ErroneousInput erroneousInput = new ErroneousInput(ricInfo);
            this.integrationProcess.removeErroneousInput(erroneousInput);
            this.faultyRicInfoReported = false;
            prXml = this.generateXml();
        }
        this.setProgressReport(prXml, false, null);
        logger.traceGeneral(THIS_CLASS, "Removed erroneous SMRS input");
        object = RbsConfigurationHelper.WAITING_MUTEX;
        synchronized (object) {
            RbsConfigurationHelper.WAITING_MUTEX.notifyAll();
        }
    }

    public String getProgressReport() {
        return this.generateXml();
    }

    public String getTraceMessage() {
        StringBuffer result2 = new StringBuffer();
        int nbrOfSteps = 0;
        int nbrDoneSteps = 0;
        IntegrationGroup[] integrationGroups = this.integrationProcess.getIntegrationGroups();
        for (int g = 0; g < integrationGroups.length; ++g) {
            result2.append((g == 0 ? "" : ", ") + integrationGroups[g].getGroupNumber() + "(");
            IntegrationStep[] integrationSteps = integrationGroups[g].getIntegrationSteps();
            for (int s = 0; s < integrationSteps.length; ++s) {
                result2.append((s == 0 ? "" : ",") + integrationSteps[s].getShortStatusString());
                ++nbrOfSteps;
                if (0 != integrationSteps[s].getStatus() && 2 != integrationSteps[s].getStatus() && 5 != integrationSteps[s].getStatus() && 6 != integrationSteps[s].getStatus()) continue;
                ++nbrDoneSteps;
            }
            result2.append(")");
        }
        result2.insert(0, nbrDoneSteps + "/" + nbrOfSteps + " - ");
        return result2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String currentIpAddress, String progressReport, RbsConfigurationMao inputRbsConfigurationMao) {
        logger.traceEnter(THIS_CLASS, "init()");
        this.rbsConfigurationMao = inputRbsConfigurationMao;
        this.progressReportCreator = new ProgressReportCreator();
        try {
            this.rbsConfigurationSmrsHelper = (RbsConfigurationSmrsHelper)inputRbsConfigurationMao.getRbsConfigurationContext().getHelper(RbsConfigurationSmrsHelper.class);
            this.integrationProcess = IntegrationProcess.restoreFromAttribute(progressReport);
            IntegrationProcess newIntegrationProcess = new IntegrationProcess("");
            this.progressReportCreator.createXml(newIntegrationProcess);
            String currentRevision = this.integrationProcess.getRevision();
            String newRevision = newIntegrationProcess.getRevision();
            if (!newRevision.equalsIgnoreCase(currentRevision)) {
                logger.traceGeneral(THIS_CLASS, "The revision has been changed - new revision: " + newRevision + ". Copying from original version: " + currentRevision);
                this.copyFromOrgToNew(this.integrationProcess, newIntegrationProcess);
                this.setNewAlreadyPassedIntegrationStepsAsSkipped(newIntegrationProcess);
                this.integrationProcess = newIntegrationProcess;
            }
            this.setUpdateCounter();
        }
        catch (Exception e) {
            this.integrationProcess = new IntegrationProcess(currentIpAddress);
            this.progressReportCreator.createXml(this.integrationProcess);
        }
        finally {
            this.updated = false;
        }
        logger.traceReturn(THIS_CLASS, "init()");
    }

    private void setUpdateCounter() {
        Object attrObj = "0";
        try {
            attrObj = this.rbsConfigurationMao.getAttribute("progressReportUpdateCounter");
            this.progressReportUpdateCounter = Integer.parseInt(attrObj.toString());
        }
        catch (Exception e) {
            this.progressReportUpdateCounter = 0;
        }
    }

    private void checkSecuritySteps(boolean activateNodeSecurity, boolean activateIpSecurity) {
        logger.traceEnter(THIS_CLASS, "checkSecuritySteps: activateSecurity = " + activateNodeSecurity + ", activateIpSecurity = " + activateIpSecurity);
        ArrayList<IntegrationStep> integrationStepsList = new ArrayList<IntegrationStep>();
        IntegrationGroup[] integrationGroups = this.integrationProcess.getIntegrationGroups();
        for (int i = 0; i < integrationGroups.length; ++i) {
            IntegrationStep[] integrationSteps = integrationGroups[i].getIntegrationSteps();
            integrationStepsList.addAll(Arrays.asList(integrationSteps));
        }
        IntegrationStep[] integrationSteps = new IntegrationStep[integrationStepsList.size()];
        integrationStepsList.toArray(integrationSteps);
        this.checkIfToSkipNodeSecurity(activateNodeSecurity, integrationSteps);
        this.checkIfToSkipIpSecurity(activateIpSecurity, integrationSteps);
        logger.traceReturn(THIS_CLASS, "checkSecuritySteps");
    }

    private void checkIfToSkipNodeSecurity(boolean activateNodeSecurity, IntegrationStep[] integrationSteps) {
        long timeStamp = System.currentTimeMillis();
        for (int i = 0; i < integrationSteps.length; ++i) {
            if (activateNodeSecurity || 1900 != integrationSteps[i].getStepNumber() && 2000 != integrationSteps[i].getStepNumber() && 2200 != integrationSteps[i].getStepNumber()) continue;
            logger.traceDebug(THIS_CLASS, "checkSecuritySteps: skipping step " + integrationSteps[i].getStepNumber());
            integrationSteps[i].setStatus(2);
            integrationSteps[i].setTimeStamp(timeStamp);
            integrationSteps[i].setDetailedInformation("Node security not activated.");
        }
    }

    private void checkIfToSkipIpSecurity(boolean activateIpSecurity, IntegrationStep[] integrationSteps) {
        long timeStamp = System.currentTimeMillis();
        for (int i = 0; i < integrationSteps.length; ++i) {
            if (activateIpSecurity || 1800 != integrationSteps[i].getStepNumber() && 2100 != integrationSteps[i].getStepNumber() && 1450 != integrationSteps[i].getStepNumber() && 1850 != integrationSteps[i].getStepNumber()) continue;
            logger.traceDebug(THIS_CLASS, "checkSecuritySteps: skipping step " + integrationSteps[i].getStepNumber());
            integrationSteps[i].setStatus(2);
            integrationSteps[i].setTimeStamp(timeStamp);
            integrationSteps[i].setDetailedInformation("Ip security not activated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRbsStateHolder(String rbsStateXmlTagName, Boolean rbsStateXmlTagValue, boolean updateProgressReport, boolean useCoordinator, Coordinator coordinator) {
        boolean valueUpdated = false;
        String prXml = null;
        ProgressReportHandler progressReportHandler = INSTANCE;
        synchronized (progressReportHandler) {
            IntegrationProcess.RbsStateHolder[] rbsStateHolders = this.integrationProcess.getRbsStatusHolders();
            for (int i = 0; i < rbsStateHolders.length; ++i) {
                if (!rbsStateHolders[i].getXmlTagName().equalsIgnoreCase(rbsStateXmlTagName) || rbsStateHolders[i].getXmlTagValue().equals(rbsStateXmlTagValue)) continue;
                rbsStateHolders[i].setXmlTagValue(rbsStateXmlTagValue);
                logger.traceGeneral(THIS_CLASS, "Set, \"" + rbsStateXmlTagName + "\" to \"" + rbsStateXmlTagValue + "\"");
                valueUpdated = true;
                if (!updateProgressReport) break;
                prXml = this.generateXml();
                break;
            }
        }
        if (valueUpdated && updateProgressReport) {
            this.setProgressReport(prXml, useCoordinator, coordinator);
        }
        return valueUpdated;
    }

    private Boolean getRbsStateHolder(String rbsStateXmlTagName) {
        Boolean rbsStateXmlTagValue = null;
        IntegrationProcess.RbsStateHolder[] rbsStateHolders = this.integrationProcess.getRbsStatusHolders();
        for (int i = 0; i < rbsStateHolders.length; ++i) {
            if (!rbsStateHolders[i].getXmlTagName().equalsIgnoreCase(rbsStateXmlTagName)) continue;
            rbsStateXmlTagValue = rbsStateHolders[i].getXmlTagValue();
            logger.traceDebug(THIS_CLASS, "getRbsStateHolder parameter = " + rbsStateHolders[i].getXmlTagName());
            break;
        }
        logger.traceDebug(THIS_CLASS, " getRbsStateHolder() RETURN  " + rbsStateXmlTagValue);
        return rbsStateXmlTagValue;
    }

    public Boolean getIntegrationCanBeCancelled() {
        return this.getRbsStateHolder("RbsIntegrationCanBeCancelled");
    }

    public Boolean getAutoIntegrationCanBeStarted() {
        return this.getRbsStateHolder("AutoIntegrationCanBeStarted");
    }

    public Boolean getNetworkLoaderCanBeStarted() {
        return this.getRbsStateHolder("NetworkLoaderCanBeStarted");
    }

    public Boolean getRbsIntegrationCanBeStarted() {
        return this.getRbsStateHolder("RbsIntegrationCanBeStarted");
    }

    public Boolean getRbsIntegrationStarted() {
        return this.getRbsStateHolder("RbsIntegrationStarted");
    }

    public Boolean getRbsIntegrationFinished() {
        return this.getRbsStateHolder("RbsIntegrationFinished");
    }

    public Boolean getIntegrationCancelled() {
        return this.getRbsStateHolder("RbsIntegrationCancelled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgressReportAndSetAttributeValue(String integrationGroupName, String integrationStepName, int status, String detailedInformation, boolean updateProgressReport, Coordinator coordinator) {
        String prXml = null;
        boolean xmlGenerated = false;
        ProgressReportHandler progressReportHandler = INSTANCE;
        synchronized (progressReportHandler) {
            IntegrationGroup integrationGroup = this.integrationProcess.getIntegrationGroup(integrationGroupName);
            IntegrationStep[] integrationSteps = integrationGroup.getIntegrationSteps();
            for (int i = 0; i < integrationSteps.length; ++i) {
                if (!integrationSteps[i].getName().equalsIgnoreCase(integrationStepName)) continue;
                if (!integrationSteps[i].setStatus(status)) {
                    integrationSteps[i].setDetailedInformation(detailedInformation);
                    integrationSteps[i].setTimeStamp(System.currentTimeMillis());
                    logger.traceDebug(THIS_CLASS, "Updated progress information: " + integrationSteps[i].toString());
                }
                if (!updateProgressReport) break;
                prXml = this.generateXml();
                xmlGenerated = true;
                break;
            }
        }
        if (xmlGenerated) {
            this.setProgressReport(prXml, false, coordinator);
        }
    }

    private void copyFromOrgToNew(IntegrationProcess orgIntegrationProcess, IntegrationProcess newIntegrationProcess) {
        IntegrationStep[] newIntegrationSteps;
        logger.traceEnter(THIS_CLASS, "copyFromOrgToNew()");
        IntegrationGroup[] orgIntegrationGroups = orgIntegrationProcess.getIntegrationGroups();
        ArrayList<IntegrationStep> orgIntegrationStepsList = new ArrayList<IntegrationStep>();
        for (int i = 0; i < orgIntegrationGroups.length; ++i) {
            IntegrationStep[] orgIntegrationSteps = orgIntegrationGroups[i].getIntegrationSteps();
            orgIntegrationStepsList.addAll(Arrays.asList(orgIntegrationSteps));
        }
        IntegrationGroup[] newIntegrationGroups = newIntegrationProcess.getIntegrationGroups();
        ArrayList<IntegrationStep> newIntegrationStepsList = new ArrayList<IntegrationStep>();
        for (int i = 0; i < newIntegrationGroups.length; ++i) {
            newIntegrationSteps = newIntegrationGroups[i].getIntegrationSteps();
            newIntegrationStepsList.addAll(Arrays.asList(newIntegrationSteps));
        }
        IntegrationStep[] orgIntegrationSteps = new IntegrationStep[orgIntegrationStepsList.size()];
        orgIntegrationStepsList.toArray(orgIntegrationSteps);
        newIntegrationSteps = new IntegrationStep[newIntegrationStepsList.size()];
        newIntegrationStepsList.toArray(newIntegrationSteps);
        this.copyGroupsAndSteps(orgIntegrationSteps, newIntegrationSteps);
        this.copyStates(orgIntegrationProcess, newIntegrationProcess);
        logger.traceReturn(THIS_CLASS, "copyFromOrgToNew()");
    }

    private void copyStates(IntegrationProcess orgIntegrationProcess, IntegrationProcess newIntegrationProcess) {
        IntegrationProcess.RbsStateHolder[] orgRbsStateHolders = orgIntegrationProcess.getRbsStatusHolders();
        IntegrationProcess.RbsStateHolder[] newRbsStateHolders = newIntegrationProcess.getRbsStatusHolders();
        for (int i = 0; i < orgRbsStateHolders.length; ++i) {
            for (int j = 0; j < newRbsStateHolders.length; ++j) {
                if (!orgRbsStateHolders[i].getXmlTagName().equalsIgnoreCase(newRbsStateHolders[j].getXmlTagName())) continue;
                newRbsStateHolders[j].setXmlTagValue(orgRbsStateHolders[i].getXmlTagValue());
            }
        }
    }

    private void copyGroupsAndSteps(IntegrationStep[] orgIntegrationSteps, IntegrationStep[] newIntegrationSteps) {
        block0: for (int i = 0; i < orgIntegrationSteps.length; ++i) {
            for (int j = 0; j < newIntegrationSteps.length; ++j) {
                if (orgIntegrationSteps[i].getStepNumber() != newIntegrationSteps[j].getStepNumber()) continue;
                newIntegrationSteps[j].setStatus(orgIntegrationSteps[i].getStatus());
                long timeStamp = "Not started".equalsIgnoreCase(orgIntegrationSteps[i].getTimeStamp()) ? 0L : DateTimeHelper.stringToDateTime((String)orgIntegrationSteps[i].getTimeStamp(), (String)"yyyy-MM-dd HH:mm:ss.SSS").getTime();
                newIntegrationSteps[j].setTimeStamp(timeStamp);
                newIntegrationSteps[j].setDetailedInformation(orgIntegrationSteps[i].getDetailedInformation());
                continue block0;
            }
        }
    }

    private void setNewAlreadyPassedIntegrationStepsAsSkipped(IntegrationProcess newIntegrationProcess) {
        boolean setToSkippedIfNotStarted = false;
        IntegrationGroup[] integrationGroups = newIntegrationProcess.getIntegrationGroups();
        for (int i = integrationGroups.length - 1; i >= 0; --i) {
            IntegrationStep[] integrationSteps = integrationGroups[i].getIntegrationSteps();
            for (int s = integrationSteps.length - 1; s >= 0; --s) {
                if (integrationSteps[s].getStatus() == 1) {
                    if (!setToSkippedIfNotStarted) continue;
                    integrationSteps[s].setStatus(2);
                    integrationSteps[s].setTimeStamp(System.currentTimeMillis());
                    integrationSteps[s].setDetailedInformation("Found new integration step after upgrade");
                    continue;
                }
                setToSkippedIfNotStarted = true;
            }
        }
    }

    private String generateXml() {
        String[] xmls = this.integrationProcess.getXmls();
        StringBuffer xmlBuf = new StringBuffer(65000);
        for (int i = 0; i < xmls.length; ++i) {
            xmlBuf.append(xmls[i]);
            if (i >= xmls.length - 1) continue;
            xmlBuf.append("\n");
        }
        return xmlBuf.toString();
    }
}

